/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraphFormatException;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraphLoader;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCommitGraph {
    private static final Logger LOG = LoggerFactory.getLogger(FileCommitGraph.class);
    private final AtomicReference<GraphSnapshot> baseGraph;

    FileCommitGraph(File objectsDir) {
        this.baseGraph = new AtomicReference<GraphSnapshot>(new GraphSnapshot(new File(objectsDir, "info/commit-graph")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CommitGraph get() {
        GraphSnapshot original = this.baseGraph.get();
        AtomicReference<GraphSnapshot> atomicReference = this.baseGraph;
        synchronized (atomicReference) {
            GraphSnapshot n;
            GraphSnapshot o;
            do {
                if ((o = this.baseGraph.get()) != original) {
                    return o.getCommitGraph();
                }
                n = o.refresh();
                if (n != o) continue;
                return n.getCommitGraph();
            } while (!this.baseGraph.compareAndSet(o, n));
            return n.getCommitGraph();
        }
    }

    private static final class GraphSnapshot {
        private final File file;
        private final FileSnapshot snapshot;
        private final CommitGraph graph;

        GraphSnapshot(@NonNull File file2) {
            this(file2, null, null);
        }

        GraphSnapshot(@NonNull File file2, FileSnapshot snapshot, CommitGraph graph) {
            this.file = file2;
            this.snapshot = snapshot;
            this.graph = graph;
        }

        CommitGraph getCommitGraph() {
            return this.graph;
        }

        GraphSnapshot refresh() {
            if (this.graph == null && !this.file.exists()) {
                return this;
            }
            if (this.snapshot != null && !this.snapshot.isModified(this.file)) {
                return this;
            }
            return new GraphSnapshot(this.file, FileSnapshot.save(this.file), GraphSnapshot.open(this.file));
        }

        private static CommitGraph open(File file2) {
            try {
                return CommitGraphLoader.open(file2);
            }
            catch (FileNotFoundException noFile) {
                return null;
            }
            catch (IOException e2) {
                if (e2 instanceof CommitGraphFormatException) {
                    LOG.warn(MessageFormat.format(JGitText.get().corruptCommitGraph, file2), e2);
                } else {
                    LOG.error(MessageFormat.format(JGitText.get().exceptionWhileLoadingCommitGraph, file2), e2);
                }
                return null;
            }
        }
    }
}

