/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.reftable.MergedReftable;
import org.eclipse.jgit.internal.storage.reftable.ReftableCompactor;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.util.FileUtils;

public class FileReftableStack
implements AutoCloseable {
    private MergedReftable mergedReftable;
    private List<StackEntry> stack;
    private AtomicReference<FileSnapshot> snapshot = new AtomicReference<FileSnapshot>(FileSnapshot.DIRTY);
    private long lastNextUpdateIndex;
    private final File tablesListFile;
    private final File reftableDir;
    private final Runnable onChange;
    private final SecureRandom random = new SecureRandom();
    private final Supplier<Config> configSupplier;
    private final CompactionStats stats;
    private final CoreConfig.TrustStat trustTablesListStat;
    private static long OVERHEAD = 91L;

    public FileReftableStack(File reftableDir, @Nullable Runnable onChange, Supplier<Config> configSupplier) throws IOException {
        this.tablesListFile = new File(reftableDir, "tables.list");
        this.reftableDir = reftableDir;
        this.stack = new ArrayList<StackEntry>();
        this.configSupplier = configSupplier;
        this.onChange = onChange;
        this.lastNextUpdateIndex = 0L;
        this.reload();
        this.stats = new CompactionStats();
        this.trustTablesListStat = configSupplier.get().get(CoreConfig.KEY).getTrustTablesListStat();
    }

    CompactionStats getStats() {
        return this.stats;
    }

    private void reloadOnce(List<String> names2) throws IOException, FileNotFoundException {
        Map<String, ReftableReader> current = this.stack.stream().collect(Collectors.toMap(e2 -> e2.name, e2 -> e2.reftableReader));
        ArrayList<ReftableReader> newTables = new ArrayList<ReftableReader>();
        ArrayList<StackEntry> newStack = new ArrayList<StackEntry>(this.stack.size() + 1);
        try {
            for (String name : names2) {
                StackEntry entry = new StackEntry();
                entry.name = name;
                ReftableReader t3 = null;
                if (current.containsKey(name)) {
                    t3 = current.remove(name);
                } else {
                    File subtable = new File(this.reftableDir, name);
                    FileInputStream is = new FileInputStream(subtable);
                    t3 = new ReftableReader(BlockSource.from(is));
                    newTables.add(t3);
                }
                entry.reftableReader = t3;
                newStack.add(entry);
            }
            this.stack = newStack;
            newTables.clear();
            current.values().forEach(r -> {
                try {
                    r.close();
                }
                catch (IOException e2) {
                    throw new AssertionError((Object)e2);
                }
            });
        }
        catch (Throwable throwable) {
            newTables.forEach(t2 -> {
                try {
                    t2.close();
                }
                catch (IOException ioe) {
                    throw new AssertionError((Object)ioe);
                }
            });
            throw throwable;
        }
        newTables.forEach(t2 -> {
            try {
                t2.close();
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
        });
    }

    void reload() throws IOException {
        long deadline = System.currentTimeMillis() + 2500L;
        long min2 = 1L;
        long max2 = 1000L;
        long delay2 = 0L;
        boolean success = false;
        for (int tries = 0; tries < 3 || System.currentTimeMillis() < deadline; ++tries) {
            List<String> names2 = this.readTableNames();
            try {
                this.reloadOnce(names2);
                success = true;
                break;
            }
            catch (FileNotFoundException e2) {
                List<String> changed = this.readTableNames();
                if (changed.equals(names2)) {
                    throw e2;
                }
                delay2 = FileUtils.delay(delay2, min2, max2);
                try {
                    Thread.sleep(delay2);
                    continue;
                }
                catch (InterruptedException e3) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e3);
                }
            }
        }
        if (!success) {
            throw new LockFailedException(this.tablesListFile);
        }
        this.mergedReftable = new MergedReftable(this.stack.stream().map(x -> x.reftableReader).collect(Collectors.toList()));
        long curr = this.nextUpdateIndex();
        if (this.lastNextUpdateIndex > 0L && this.lastNextUpdateIndex != curr && this.onChange != null) {
            this.onChange.run();
        }
        this.lastNextUpdateIndex = curr;
    }

    public MergedReftable getMergedReftable() {
        return this.mergedReftable;
    }

    private List<String> readTableNames() throws IOException {
        ArrayList<String> names2 = new ArrayList<String>(this.stack.size() + 1);
        FileSnapshot old = this.snapshot.get();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.tablesListFile), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    names2.add(line);
                }
                this.snapshot.compareAndSet(old, FileSnapshot.save(this.tablesListFile));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e2) {
            this.snapshot.compareAndSet(old, FileSnapshot.MISSING_FILE);
        }
        return names2;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    boolean isUpToDate() throws IOException {
        try {
            switch (this.trustTablesListStat) {
                case NEVER: {
                    break;
                }
                case AFTER_OPEN: {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try {
                            InputStream stream = Files.newInputStream(this.reftableDir.toPath(), new OpenOption[0]);
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (FileNotFoundException | NoSuchFileException iOException) {
                        // empty catch block
                    }
                }
                case ALWAYS: {
                    if (this.snapshot.get().isModified(this.tablesListFile)) break;
                    return true;
                }
                case INHERIT: {
                    throw new IllegalStateException();
                }
            }
            List<String> names2 = this.readTableNames();
            if (names2.size() != this.stack.size()) {
                return false;
            }
            int i2 = 0;
            while (i2 < names2.size()) {
                if (!names2.get(i2).equals(this.stack.get((int)i2).name)) {
                    return false;
                }
                ++i2;
            }
        }
        catch (FileNotFoundException e2) {
            return this.stack.isEmpty();
        }
        return true;
    }

    @Override
    public void close() {
        for (StackEntry entry : this.stack) {
            try {
                entry.reftableReader.close();
            }
            catch (Exception e2) {
                throw new AssertionError((Object)e2);
            }
        }
    }

    private long nextUpdateIndex() throws IOException {
        return this.stack.size() > 0 ? this.stack.get((int)(this.stack.size() - 1)).reftableReader.maxUpdateIndex() + 1L : 1L;
    }

    private String filename(long low, long high) {
        return String.format("%012x-%012x-%08x", low, high, this.random.nextInt());
    }

    public boolean addReftable(Writer w) throws IOException {
        LockFile lock = new LockFile(this.tablesListFile);
        try {
            ReftableWriter.Stats s2;
            if (!lock.lockForAppend()) {
                return false;
            }
            if (!this.isUpToDate()) {
                return false;
            }
            Object fn = this.filename(this.nextUpdateIndex(), this.nextUpdateIndex());
            File tmpTable = File.createTempFile((String)fn + "_", ".ref", this.reftableDir);
            Throwable throwable = null;
            Object var7_7 = null;
            try (FileOutputStream fos = new FileOutputStream(tmpTable);){
                ReftableWriter rw = new ReftableWriter(this.reftableConfig(), fos);
                w.call(rw);
                rw.finish();
                s2 = rw.getStats();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (s2.minUpdateIndex() < this.nextUpdateIndex()) {
                return false;
            }
            fn = (String)fn + (s2.refCount() > 0L ? ".ref" : ".log");
            File dest = new File(this.reftableDir, (String)fn);
            FileUtils.rename(tmpTable, dest, StandardCopyOption.ATOMIC_MOVE);
            lock.write(((String)fn + "\n").getBytes(StandardCharsets.UTF_8));
            if (!lock.commit()) {
                FileUtils.delete(dest);
                return false;
            }
            this.reload();
            this.autoCompact();
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    private ReftableConfig reftableConfig() {
        return new ReftableConfig(this.configSupplier.get());
    }

    private File compactLocked(int first2, int last2) throws IOException {
        String fn = this.filename(first2, last2);
        File tmpTable = File.createTempFile(fn + "_", ".ref", this.reftableDir);
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileOutputStream fos = new FileOutputStream(tmpTable);){
            ReftableCompactor c2 = new ReftableCompactor(fos).setConfig(this.reftableConfig()).setIncludeDeletes(first2 > 0);
            ArrayList<ReftableReader> compactMe = new ArrayList<ReftableReader>();
            long totalBytes = 0L;
            int i2 = first2;
            while (i2 <= last2) {
                compactMe.add(this.stack.get((int)i2).reftableReader);
                totalBytes += this.stack.get((int)i2).reftableReader.size();
                ++i2;
            }
            c2.addAll(compactMe);
            c2.compact();
            this.stats.bytes += totalBytes;
            this.stats.tables += (long)(first2 - last2 + 1);
            ++this.stats.attempted;
            this.stats.refCount += c2.getStats().refCount();
            this.stats.logCount += c2.getStats().logCount();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return tmpTable;
    }

    /*
     * Exception decompiling
     */
    boolean compactRange(int first, int last) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 24[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static int log(long sz) {
        long base = 2L;
        if (sz <= 0L) {
            throw new IllegalArgumentException("log2 negative");
        }
        int l = 0;
        while (sz > 0L) {
            ++l;
            sz /= base;
        }
        return l - 1;
    }

    static List<Segment> segmentSizes(long[] sizes) {
        ArrayList<Segment> segments2 = new ArrayList<Segment>();
        Segment cur = new Segment();
        int i2 = 0;
        while (i2 < sizes.length) {
            int l = FileReftableStack.log(sizes[i2]);
            if (l != cur.log && cur.bytes > 0L) {
                segments2.add(cur);
                cur = new Segment();
                cur.start = i2;
                cur.log = l;
            }
            cur.log = l;
            cur.end = i2 + 1;
            cur.bytes += sizes[i2];
            ++i2;
        }
        segments2.add(cur);
        return segments2;
    }

    private static Optional<Segment> autoCompactCandidate(long[] sizes) {
        if (sizes.length == 0) {
            return Optional.empty();
        }
        List<Segment> segments2 = FileReftableStack.segmentSizes(sizes);
        if ((segments2 = segments2.stream().filter(s2 -> s2.size() > 1).collect(Collectors.toList())).isEmpty()) {
            return Optional.empty();
        }
        Optional<Segment> optMinSeg = segments2.stream().min(Comparator.comparing(s2 -> s2.log));
        Segment smallCollected = optMinSeg.get();
        while (smallCollected.start > 0) {
            int prev = smallCollected.start - 1;
            long prevSize = sizes[prev];
            if (FileReftableStack.log(smallCollected.bytes) < FileReftableStack.log(prevSize)) break;
            smallCollected.start = prev;
            smallCollected.bytes += prevSize;
        }
        return Optional.of(smallCollected);
    }

    private void autoCompact() throws IOException {
        Optional<Segment> cand = FileReftableStack.autoCompactCandidate(this.tableSizes());
        if (cand.isPresent() && !this.compactRange(cand.get().start, cand.get().end - 1)) {
            ++this.stats.failed;
        }
    }

    private long[] tableSizes() throws IOException {
        long[] sizes = new long[this.stack.size()];
        int i2 = 0;
        while (i2 < this.stack.size()) {
            sizes[i2] = this.stack.get((int)i2).reftableReader.size() - OVERHEAD;
            ++i2;
        }
        return sizes;
    }

    void compactFully() throws IOException {
        if (!this.compactRange(0, this.stack.size() - 1)) {
            ++this.stats.failed;
        }
    }

    static class CompactionStats {
        long tables = 0L;
        long bytes = 0L;
        int attempted = 0;
        int failed = 0;
        long refCount = 0L;
        long logCount = 0L;

        CompactionStats() {
        }
    }

    static class Segment {
        int log;
        long bytes;
        int start;
        int end;

        int size() {
            return this.end - this.start;
        }

        Segment(int start2, int end2, int log2, long bytes) {
            this.log = log2;
            this.start = start2;
            this.end = end2;
            this.bytes = bytes;
        }

        Segment() {
            this(0, 0, 0, 0L);
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Segment)) {
                return false;
            }
            Segment o = (Segment)other;
            return o.bytes == this.bytes && o.log == this.log && o.start == this.start && o.end == this.end;
        }

        public String toString() {
            return String.format("{ [%d,%d) l=%d sz=%d }", this.start, this.end, this.log, this.bytes);
        }
    }

    private static class StackEntry {
        String name;
        ReftableReader reftableReader;

        private StackEntry() {
        }
    }

    public static interface Writer {
        public void call(ReftableWriter var1) throws IOException;
    }
}

