/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.UnpackedObject;
import org.eclipse.jgit.internal.storage.file.UnpackedObjectCache;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LooseObjects {
    private static final Logger LOG = LoggerFactory.getLogger(LooseObjects.class);
    private static final int MAX_STALE_READ_RETRIES = 5;
    private final File directory;
    private final UnpackedObjectCache unpackedObjectCache;
    private final CoreConfig.TrustStat trustLooseObjectStat;

    LooseObjects(Config config2, File dir) {
        this.directory = dir;
        this.unpackedObjectCache = new UnpackedObjectCache();
        this.trustLooseObjectStat = config2.get(CoreConfig.KEY).getTrustLooseObjectStat();
    }

    File getDirectory() {
        return this.directory;
    }

    void create() throws IOException {
        FileUtils.mkdirs(this.directory);
    }

    void close() {
        this.unpackedObjectCache().clear();
    }

    public String toString() {
        return "LooseObjects[" + String.valueOf(this.directory) + "]";
    }

    boolean hasCached(AnyObjectId id) {
        return this.unpackedObjectCache().isUnpacked(id);
    }

    boolean has(AnyObjectId objectId) {
        boolean exists = this.hasWithoutRefresh(objectId);
        if (this.trustLooseObjectStat == CoreConfig.TrustStat.ALWAYS || exists) {
            return exists;
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                InputStream stream = Files.newInputStream(this.directory.toPath(), new OpenOption[0]);
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            return false;
        }
        return this.hasWithoutRefresh(objectId);
    }

    private boolean hasWithoutRefresh(AnyObjectId objectId) {
        return this.fileFor(objectId).exists();
    }

    boolean resolve(Set<ObjectId> matches2, AbbreviatedObjectId id, int matchLimit) {
        String fanOut = id.name().substring(0, 2);
        String[] entries2 = new File(this.directory, fanOut).list();
        if (entries2 != null) {
            String[] stringArray = entries2;
            int n = entries2.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    String e2 = stringArray[n2];
                    if (e2.length() == 38) {
                        block6: {
                            try {
                                ObjectId entId = ObjectId.fromString(fanOut + e2);
                                if (id.prefixCompare(entId) != 0) break block6;
                                matches2.add(entId);
                            }
                            catch (IllegalArgumentException notId) {
                                break block7;
                            }
                        }
                        if (matches2.size() > matchLimit) {
                            return false;
                        }
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    ObjectLoader open(WindowCursor curs, AnyObjectId id) throws IOException {
        File path2 = this.fileFor(id);
        int retries = 0;
        while (retries < 5) {
            block20: {
                boolean reload = true;
                switch (this.trustLooseObjectStat) {
                    case NEVER: {
                        break;
                    }
                    case AFTER_OPEN: {
                        try {
                            Throwable throwable = null;
                            Object var7_10 = null;
                            try {
                                InputStream stream = Files.newInputStream(path2.getParentFile().toPath(), new OpenOption[0]);
                                if (stream != null) {
                                    stream.close();
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (FileNotFoundException | NoSuchFileException iOException) {
                            // empty catch block
                        }
                    }
                    case ALWAYS: {
                        if (path2.exists()) break;
                        reload = false;
                        break;
                    }
                    case INHERIT: {
                        throw new IllegalStateException();
                    }
                }
                if (reload) {
                    try {
                        return this.getObjectLoader(curs, path2, id);
                    }
                    catch (FileNotFoundException noFile) {
                        if (!path2.exists()) break;
                        throw noFile;
                    }
                    catch (IOException e2) {
                        if (!FileUtils.isStaleFileHandleInCausalChain(e2)) {
                            throw e2;
                        }
                        if (!LOG.isDebugEnabled()) break block20;
                        LOG.debug(MessageFormat.format(JGitText.get().looseObjectHandleIsStale, id.name(), retries, 5));
                    }
                }
            }
            ++retries;
        }
        this.unpackedObjectCache().remove(id);
        return null;
    }

    ObjectLoader getObjectLoader(WindowCursor curs, File path2, AnyObjectId id) throws IOException {
        try {
            return this.getObjectLoaderWithoutRefresh(curs, path2, id);
        }
        catch (FileNotFoundException e2) {
            if (this.trustLooseObjectStat == CoreConfig.TrustStat.ALWAYS) {
                throw e2;
            }
            Throwable throwable = null;
            Object var6_6 = null;
            try {
                InputStream stream = Files.newInputStream(this.directory.toPath(), new OpenOption[0]);
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return this.getObjectLoaderWithoutRefresh(curs, path2, id);
        }
    }

    private ObjectLoader getObjectLoaderWithoutRefresh(WindowCursor curs, File path2, AnyObjectId id) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream in = new FileInputStream(path2);){
            this.unpackedObjectCache().add(id);
            return UnpackedObject.open(in, path2, id, curs);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    UnpackedObjectCache unpackedObjectCache() {
        return this.unpackedObjectCache;
    }

    long getSize(WindowCursor curs, AnyObjectId id) throws IOException {
        try {
            return this.getSizeWithoutRefresh(curs, id);
        }
        catch (FileNotFoundException noFile) {
            try {
                if (this.trustLooseObjectStat == CoreConfig.TrustStat.ALWAYS) {
                    throw noFile;
                }
                Throwable throwable = null;
                Object var5_6 = null;
                try {
                    InputStream stream = Files.newInputStream(this.directory.toPath(), new OpenOption[0]);
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return this.getSizeWithoutRefresh(curs, id);
            }
            catch (FileNotFoundException unused) {
                if (this.fileFor(id).exists()) {
                    throw noFile;
                }
                this.unpackedObjectCache().remove(id);
                return -1L;
            }
        }
    }

    private long getSizeWithoutRefresh(WindowCursor curs, AnyObjectId id) throws IOException {
        File f2 = this.fileFor(id);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream in = new FileInputStream(f2);){
            this.unpackedObjectCache().add(id);
            return UnpackedObject.getSize(in, id, curs);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    FileObjectDatabase.InsertLooseObjectResult insert(File tmp, ObjectId id) throws IOException {
        File dst = this.fileFor(id);
        if (dst.exists()) {
            FileUtils.delete(tmp, 6);
            return FileObjectDatabase.InsertLooseObjectResult.EXISTS_LOOSE;
        }
        try {
            return this.tryMove(tmp, dst, id);
        }
        catch (NoSuchFileException e2) {
            FileUtils.mkdir(dst.getParentFile(), true);
        }
        catch (IOException e3) {
            LOG.error(e3.getMessage(), e3);
            FileUtils.delete(tmp, 6);
            return FileObjectDatabase.InsertLooseObjectResult.FAILURE;
        }
        try {
            return this.tryMove(tmp, dst, id);
        }
        catch (IOException e4) {
            LOG.error(e4.getMessage(), e4);
            FileUtils.delete(tmp, 6);
            return FileObjectDatabase.InsertLooseObjectResult.FAILURE;
        }
    }

    private FileObjectDatabase.InsertLooseObjectResult tryMove(File tmp, File dst, ObjectId id) throws IOException {
        Files.move(FileUtils.toPath(tmp), FileUtils.toPath(dst), StandardCopyOption.ATOMIC_MOVE);
        dst.setReadOnly();
        this.unpackedObjectCache().add(id);
        return FileObjectDatabase.InsertLooseObjectResult.INSERTED;
    }

    File fileFor(AnyObjectId objectId) {
        String n = objectId.name();
        String d2 = n.substring(0, 2);
        String f2 = n.substring(2);
        return new File(new File(this.getDirectory(), d2), f2);
    }
}

