/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.BasePackBitmapIndex;
import org.eclipse.jgit.internal.storage.pack.BitmapCommit;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.util.BlockList;

public class PackBitmapIndexBuilder
extends BasePackBitmapIndex {
    private static final int MAX_XOR_OFFSET_SEARCH = 10;
    private final EWAHCompressedBitmap commits;
    private final EWAHCompressedBitmap trees;
    private final EWAHCompressedBitmap blobs;
    private final EWAHCompressedBitmap tags;
    private final BlockList<PositionEntry> byOffset;
    private final ArrayDeque<BasePackBitmapIndex.StoredBitmap> bitmapsToWriteXorBuffer = new ArrayDeque();
    private List<StoredEntry> bitmapsToWrite = new ArrayList<StoredEntry>();
    final ObjectIdOwnerMap<PositionEntry> positionEntries = new ObjectIdOwnerMap();

    public PackBitmapIndexBuilder(List<ObjectToPack> objects) {
        super(new ObjectIdOwnerMap<BasePackBitmapIndex.StoredBitmap>());
        this.byOffset = new BlockList(objects.size());
        PackBitmapIndexBuilder.sortByOffsetAndIndex(this.byOffset, this.positionEntries, objects);
        int sizeInWords = Math.max(4, this.byOffset.size() / 64 / 3);
        this.commits = new EWAHCompressedBitmap(sizeInWords);
        this.trees = new EWAHCompressedBitmap(sizeInWords);
        this.blobs = new EWAHCompressedBitmap(sizeInWords);
        this.tags = new EWAHCompressedBitmap(sizeInWords);
        int i2 = 0;
        while (i2 < objects.size()) {
            int type2 = objects.get(i2).getType();
            switch (type2) {
                case 1: {
                    this.commits.set(i2);
                    break;
                }
                case 2: {
                    this.trees.set(i2);
                    break;
                }
                case 3: {
                    this.blobs.set(i2);
                    break;
                }
                case 4: {
                    this.tags.set(i2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().badObjectType, String.valueOf(type2)));
                }
            }
            ++i2;
        }
        this.commits.trim();
        this.trees.trim();
        this.blobs.trim();
        this.tags.trim();
    }

    private static void sortByOffsetAndIndex(BlockList<PositionEntry> byOffset, ObjectIdOwnerMap<PositionEntry> positionEntries, List<ObjectToPack> entries2) {
        int i2 = 0;
        while (i2 < entries2.size()) {
            positionEntries.add(new PositionEntry(entries2.get(i2), i2));
            ++i2;
        }
        Collections.sort(entries2, (a2, b2) -> Long.signum(a2.getOffset() - b2.getOffset()));
        i2 = 0;
        while (i2 < entries2.size()) {
            PositionEntry e2 = positionEntries.get(entries2.get(i2));
            e2.ridxPosition = i2++;
            byOffset.add(e2);
        }
    }

    public ObjectIdOwnerMap<ObjectIdOwnerMap.Entry> getObjectSet() {
        ObjectIdOwnerMap<ObjectIdOwnerMap.Entry> r = new ObjectIdOwnerMap<ObjectIdOwnerMap.Entry>();
        for (PositionEntry e2 : this.byOffset) {
            r.add(new ObjectIdOwnerMap.Entry(e2){});
        }
        return r;
    }

    public void addBitmap(AnyObjectId objectId, BitmapIndex.Bitmap bitmap, int flags) {
        this.addBitmap(objectId, bitmap.retrieveCompressed(), flags);
    }

    public void processBitmapForWrite(BitmapCommit c2, BitmapIndex.Bitmap bitmap, int flags) {
        EWAHCompressedBitmap compressed = bitmap.retrieveCompressed();
        compressed.trim();
        BasePackBitmapIndex.StoredBitmap newest = new BasePackBitmapIndex.StoredBitmap(c2, compressed, null, flags);
        this.bitmapsToWriteXorBuffer.add(newest);
        if (this.bitmapsToWriteXorBuffer.size() > 10) {
            this.bitmapsToWrite.add(this.generateStoredEntry(this.bitmapsToWriteXorBuffer.pollFirst()));
        }
        if (c2.isAddToIndex()) {
            this.addBitmap((AnyObjectId)c2, bitmap, flags);
        }
    }

    private StoredEntry generateStoredEntry(BasePackBitmapIndex.StoredBitmap bitmapToWrite) {
        int bestXorOffset = 0;
        EWAHCompressedBitmap bestBitmap = bitmapToWrite.getBitmap();
        int offset = 1;
        for (BasePackBitmapIndex.StoredBitmap curr : this.bitmapsToWriteXorBuffer) {
            EWAHCompressedBitmap bitmap = curr.getBitmap().xor(bitmapToWrite.getBitmap());
            if (bitmap.sizeInBytes() < bestBitmap.sizeInBytes()) {
                bestBitmap = bitmap;
                bestXorOffset = offset;
            }
            ++offset;
        }
        PositionEntry entry = this.positionEntries.get(bitmapToWrite);
        if (entry == null) {
            throw new IllegalStateException();
        }
        bestBitmap.trim();
        StoredEntry result2 = new StoredEntry(entry, entry.idxPosition, bestBitmap, bestXorOffset, bitmapToWrite.getFlags());
        return result2;
    }

    public void addBitmap(AnyObjectId objectId, EWAHCompressedBitmap bitmap, int flags) {
        bitmap.trim();
        BasePackBitmapIndex.StoredBitmap result2 = new BasePackBitmapIndex.StoredBitmap(objectId, bitmap, null, flags);
        this.getBitmaps().add(result2);
    }

    @Override
    public EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap bitmap, int type2) {
        switch (type2) {
            case 3: {
                return this.getBlobs().and(bitmap);
            }
            case 2: {
                return this.getTrees().and(bitmap);
            }
            case 1: {
                return this.getCommits().and(bitmap);
            }
            case 4: {
                return this.getTags().and(bitmap);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int findPosition(AnyObjectId objectId) {
        PositionEntry entry = this.positionEntries.get(objectId);
        if (entry == null) {
            return -1;
        }
        return entry.ridxPosition;
    }

    @Override
    public ObjectId getObject(int position) throws IllegalArgumentException {
        ObjectId objectId = this.byOffset.get(position);
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        return objectId;
    }

    public EWAHCompressedBitmap getCommits() {
        return this.commits;
    }

    public EWAHCompressedBitmap getTrees() {
        return this.trees;
    }

    public EWAHCompressedBitmap getBlobs() {
        return this.blobs;
    }

    public EWAHCompressedBitmap getTags() {
        return this.tags;
    }

    public int getOptions() {
        return 1;
    }

    @Override
    public int getBitmapCount() {
        return this.bitmapsToWriteXorBuffer.size() + this.bitmapsToWrite.size();
    }

    public void resetBitmaps(int size2) {
        this.getBitmaps().clear();
        this.bitmapsToWrite = new ArrayList<StoredEntry>(size2);
    }

    @Override
    public int getObjectCount() {
        return this.byOffset.size();
    }

    public List<StoredEntry> getCompressedBitmaps() {
        while (!this.bitmapsToWriteXorBuffer.isEmpty()) {
            this.bitmapsToWrite.add(this.generateStoredEntry(this.bitmapsToWriteXorBuffer.pollFirst()));
        }
        ArrayList<StoredEntry> bitmapsToReturn = new ArrayList<StoredEntry>(this.bitmapsToWrite);
        Collections.reverse(bitmapsToReturn);
        return bitmapsToReturn;
    }

    private static final class PositionEntry
    extends ObjectIdOwnerMap.Entry {
        final int idxPosition;
        int ridxPosition;

        PositionEntry(AnyObjectId objectId, int idxPosition) {
            super(objectId);
            this.idxPosition = idxPosition;
        }
    }

    public static final class StoredEntry {
        private final ObjectId objectId;
        private final long idxPosition;
        private final EWAHCompressedBitmap bitmap;
        private final int xorOffset;
        private final int flags;

        public StoredEntry(ObjectId objectId, long idxPosition, EWAHCompressedBitmap bitmap, int xorOffset, int flags) {
            this.objectId = objectId;
            this.idxPosition = idxPosition;
            this.bitmap = bitmap;
            this.xorOffset = xorOffset;
            this.flags = flags;
        }

        public EWAHCompressedBitmap getBitmap() {
            return this.bitmap;
        }

        public int getXorOffset() {
            return this.xorOffset;
        }

        public int getFlags() {
            return this.flags;
        }

        public long getIdxPosition() {
            return this.idxPosition;
        }

        public ObjectId getObjectId() {
            return this.objectId;
        }
    }
}

