/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.IntIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jgit.internal.storage.file.BasePackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.BitSet;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;

public class PackBitmapIndexRemapper
implements PackBitmapIndex,
Iterable<Entry> {
    private final BasePackBitmapIndex oldPackIndex;
    final PackBitmapIndex newPackIndex;
    private final BitSet inflated;
    private final int[] prevToNewMapping;

    public static PackBitmapIndexRemapper newPackBitmapIndex(BitmapIndex prevBitmapIndex, PackBitmapIndex newIndex) {
        if (!(prevBitmapIndex instanceof BitmapIndexImpl)) {
            return new PackBitmapIndexRemapper(newIndex);
        }
        PackBitmapIndex prevIndex = ((BitmapIndexImpl)prevBitmapIndex).getPackBitmapIndex();
        if (!(prevIndex instanceof BasePackBitmapIndex)) {
            return new PackBitmapIndexRemapper(newIndex);
        }
        return new PackBitmapIndexRemapper((BasePackBitmapIndex)prevIndex, newIndex);
    }

    private PackBitmapIndexRemapper(PackBitmapIndex newPackIndex) {
        this.oldPackIndex = null;
        this.newPackIndex = newPackIndex;
        this.inflated = null;
        this.prevToNewMapping = null;
    }

    private PackBitmapIndexRemapper(BasePackBitmapIndex oldPackIndex, PackBitmapIndex newPackIndex) {
        this.oldPackIndex = oldPackIndex;
        this.newPackIndex = newPackIndex;
        this.inflated = new BitSet(newPackIndex.getObjectCount());
        this.prevToNewMapping = new int[oldPackIndex.getObjectCount()];
        int pos = 0;
        while (pos < this.prevToNewMapping.length) {
            this.prevToNewMapping[pos] = newPackIndex.findPosition(oldPackIndex.getObject(pos));
            ++pos;
        }
    }

    @Override
    public int findPosition(AnyObjectId objectId) {
        return this.newPackIndex.findPosition(objectId);
    }

    @Override
    public ObjectId getObject(int position) throws IllegalArgumentException {
        return this.newPackIndex.getObject(position);
    }

    @Override
    public int getObjectCount() {
        return this.newPackIndex.getObjectCount();
    }

    @Override
    public int getBaseBitmapCount() {
        return this.newPackIndex.getBaseBitmapCount();
    }

    @Override
    public long getBaseBitmapSizeInBytes() {
        return this.newPackIndex.getBaseBitmapSizeInBytes();
    }

    @Override
    public int getXorBitmapCount() {
        return this.newPackIndex.getXorBitmapCount();
    }

    @Override
    public long getXorBitmapSizeInBytes() {
        return this.newPackIndex.getXorBitmapSizeInBytes();
    }

    @Override
    public EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap bitmap, int type2) {
        return this.newPackIndex.ofObjectType(bitmap, type2);
    }

    @Override
    public Iterator<Entry> iterator() {
        if (this.oldPackIndex == null) {
            return Collections.emptyList().iterator();
        }
        final Iterator<BasePackBitmapIndex.StoredBitmap> it = this.oldPackIndex.getBitmaps().iterator();
        return new Iterator<Entry>(){
            private Entry entry;

            @Override
            public boolean hasNext() {
                while (this.entry == null && it.hasNext()) {
                    BasePackBitmapIndex.StoredBitmap sb = (BasePackBitmapIndex.StoredBitmap)it.next();
                    if (PackBitmapIndexRemapper.this.newPackIndex.findPosition(sb) == -1) continue;
                    this.entry = new Entry(sb, sb.getFlags());
                }
                return this.entry != null;
            }

            @Override
            public Entry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Entry res = this.entry;
                this.entry = null;
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public EWAHCompressedBitmap getBitmap(AnyObjectId objectId) {
        EWAHCompressedBitmap bitmap = this.newPackIndex.getBitmap(objectId);
        if (bitmap != null || this.oldPackIndex == null) {
            return bitmap;
        }
        BasePackBitmapIndex.StoredBitmap oldBitmap = this.oldPackIndex.getBitmaps().get(objectId);
        if (oldBitmap == null) {
            return null;
        }
        if (this.newPackIndex.findPosition(objectId) == -1) {
            return null;
        }
        this.inflated.clear();
        IntIterator i2 = oldBitmap.getBitmapWithoutCaching().intIterator();
        while (i2.hasNext()) {
            this.inflated.set(this.prevToNewMapping[i2.next()]);
        }
        bitmap = this.inflated.toEWAHCompressedBitmap();
        bitmap.trim();
        return bitmap;
    }

    @Override
    public int getBitmapCount() {
        return 0;
    }

    public static final class Entry
    extends ObjectId {
        private final int flags;

        Entry(AnyObjectId src, int flags) {
            super(src);
            this.flags = flags;
        }

        public int getFlags() {
            return this.flags;
        }
    }
}

