/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackObjectSizeIndex;
import org.eclipse.jgit.internal.storage.file.UInt24Array;
import org.eclipse.jgit.util.NB;

class PackObjectSizeIndexV1
implements PackObjectSizeIndex {
    private static final byte BITS_24 = 24;
    private static final byte BITS_32 = 32;
    private final int threshold;
    private final UInt24Array positions24;
    private final IntArray positions32;
    private final IntArray sizes32;
    private final LongArray sizes64;

    static PackObjectSizeIndex parse(InputStream in) throws IOException {
        byte[] buffer = new byte[8];
        in.readNBytes(buffer, 0, 8);
        int threshold = NB.decodeInt32(buffer, 0);
        int objCount = NB.decodeInt32(buffer, 4);
        if (objCount == 0) {
            return new EmptyPackObjectSizeIndex(threshold);
        }
        return new PackObjectSizeIndexV1(in, threshold, objCount);
    }

    private PackObjectSizeIndexV1(InputStream stream, int threshold, int objCount) throws IOException {
        byte positionEncoding;
        this.threshold = threshold;
        UInt24Array pos24 = null;
        IntArray pos32 = null;
        StreamHelper helper = new StreamHelper();
        while ((positionEncoding = helper.readByte(stream)) != 0) {
            int sz;
            if (Byte.compareUnsigned(positionEncoding, (byte)24) == 0) {
                sz = helper.readInt(stream);
                pos24 = new UInt24Array(stream.readNBytes(sz * 3));
                continue;
            }
            if (Byte.compareUnsigned(positionEncoding, (byte)32) == 0) {
                sz = helper.readInt(stream);
                pos32 = IntArray.from(stream, sz);
                continue;
            }
            throw new UnsupportedEncodingException(String.format(JGitText.get().unknownPositionEncoding, Integer.toHexString(positionEncoding)));
        }
        this.positions24 = pos24 != null ? pos24 : UInt24Array.EMPTY;
        this.positions32 = pos32 != null ? pos32 : IntArray.EMPTY;
        this.sizes32 = IntArray.from(stream, objCount);
        int c64sizes = helper.readInt(stream);
        if (c64sizes == 0) {
            this.sizes64 = LongArray.EMPTY;
            return;
        }
        this.sizes64 = LongArray.from(stream, c64sizes);
        int c128sizes = helper.readInt(stream);
        if (c128sizes != 0) {
            throw new IOException(JGitText.get().unsupportedSizesObjSizeIndex);
        }
    }

    @Override
    public long getSize(int idxOffset) {
        int pos32;
        int pos = -1;
        if (!this.positions24.isEmpty() && idxOffset <= this.positions24.getLastValue()) {
            pos = this.positions24.binarySearch(idxOffset);
        } else if (!this.positions32.empty() && idxOffset >= this.positions32.get(0) && (pos32 = this.positions32.binarySearch(idxOffset)) >= 0) {
            pos = pos32 + this.positions24.size();
        }
        if (pos < 0) {
            return -1L;
        }
        int objSize = this.sizes32.get(pos);
        if (objSize < 0) {
            int secondPos = Math.abs(objSize) - 1;
            return this.sizes64.get(secondPos);
        }
        return objSize;
    }

    @Override
    public long getObjectCount() {
        return (long)this.positions24.size() + (long)this.positions32.size();
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    private static class EmptyPackObjectSizeIndex
    implements PackObjectSizeIndex {
        private final int threshold;

        EmptyPackObjectSizeIndex(int threshold) {
            this.threshold = threshold;
        }

        @Override
        public long getSize(int idxOffset) {
            return -1L;
        }

        @Override
        public long getObjectCount() {
            return 0L;
        }

        @Override
        public int getThreshold() {
            return this.threshold;
        }
    }

    private static class IntArray {
        private static final IntArray EMPTY = new IntArray(new byte[0]);
        private static final int INT_SIZE = 4;
        private final byte[] data;
        private final int size;

        static IntArray from(InputStream in, int ints) throws IOException {
            int expectedBytes = ints * 4;
            byte[] data2 = in.readNBytes(expectedBytes);
            if (data2.length < expectedBytes) {
                throw new IOException(MessageFormat.format(JGitText.get().unableToReadFullArray, ints));
            }
            return new IntArray(data2);
        }

        private IntArray(byte[] data2) {
            this.data = data2;
            this.size = data2.length / 4;
        }

        int binarySearch(int needle) {
            if (this.size == 0) {
                return -1;
            }
            int high = this.size;
            int low = 0;
            do {
                int mid;
                int cmp;
                if ((cmp = Integer.compare(needle, this.get(mid = low + high >>> 1))) < 0) {
                    high = mid;
                    continue;
                }
                if (cmp == 0) {
                    return mid;
                }
                low = mid + 1;
            } while (low < high);
            return -1;
        }

        int get(int position) {
            if (position < 0 || position >= this.size) {
                throw new IndexOutOfBoundsException(position);
            }
            return NB.decodeInt32(this.data, position * 4);
        }

        boolean empty() {
            return this.size == 0;
        }

        int size() {
            return this.size;
        }
    }

    private static class LongArray {
        private static final LongArray EMPTY = new LongArray(new byte[0]);
        private static final int LONG_SIZE = 8;
        private final byte[] data;
        private final int size;

        static LongArray from(InputStream in, int longs) throws IOException {
            byte[] data2 = in.readNBytes(longs * 8);
            if (data2.length < longs * 8) {
                throw new IOException(MessageFormat.format(JGitText.get().unableToReadFullArray, longs));
            }
            return new LongArray(data2);
        }

        private LongArray(byte[] data2) {
            this.data = data2;
            this.size = data2.length / 8;
        }

        long get(int position) {
            if (position < 0 || position >= this.size) {
                throw new IndexOutOfBoundsException(position);
            }
            return NB.decodeInt64(this.data, position * 8);
        }
    }

    private static class StreamHelper {
        private final byte[] buffer = new byte[8];

        private StreamHelper() {
        }

        int readInt(InputStream in) throws IOException {
            int n = in.readNBytes(this.buffer, 0, 4);
            if (n < 4) {
                throw new IOException(JGitText.get().unableToReadFullInt);
            }
            return NB.decodeInt32(this.buffer, 0);
        }

        byte readByte(InputStream in) throws IOException {
            int n = in.readNBytes(this.buffer, 0, 1);
            if (n != 1) {
                throw new IOException(JGitText.get().cannotReadByte);
            }
            return this.buffer[0];
        }
    }
}

