/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.internal.storage.file.ReflogEntryImpl;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

class ReflogReaderImpl
implements ReflogReader {
    private File logName;

    ReflogReaderImpl(Repository db, String refname) {
        File logBaseDir = refname.equals("HEAD") ? db.getDirectory() : db.getCommonDirectory();
        this.logName = new File(logBaseDir, "logs/" + refname);
    }

    @Override
    public ReflogEntry getLastEntry() throws IOException {
        return this.getReverseEntry(0);
    }

    @Override
    public List<ReflogEntry> getReverseEntries() throws IOException {
        return this.getReverseEntries(Integer.MAX_VALUE);
    }

    @Override
    public ReflogEntry getReverseEntry(int number) throws IOException {
        byte[] log2;
        if (number < 0) {
            throw new IllegalArgumentException();
        }
        try {
            log2 = IO.readFully(this.logName);
        }
        catch (FileNotFoundException e2) {
            if (this.logName.exists()) {
                throw e2;
            }
            return null;
        }
        int rs = RawParseUtils.prevLF(log2, log2.length);
        int current = 0;
        while (rs >= 0) {
            rs = RawParseUtils.prevLF(log2, rs);
            if (number == current) {
                return new ReflogEntryImpl(log2, rs < 0 ? 0 : rs + 2);
            }
            ++current;
        }
        return null;
    }

    @Override
    public List<ReflogEntry> getReverseEntries(int max2) throws IOException {
        byte[] log2;
        try {
            log2 = IO.readFully(this.logName);
        }
        catch (FileNotFoundException e2) {
            if (this.logName.exists()) {
                throw e2;
            }
            return Collections.emptyList();
        }
        int rs = RawParseUtils.prevLF(log2, log2.length);
        ArrayList<ReflogEntry> ret = new ArrayList<ReflogEntry>();
        while (rs >= 0 && max2-- > 0) {
            ReflogEntryImpl entry = new ReflogEntryImpl(log2, (rs = RawParseUtils.prevLF(log2, rs)) < 0 ? 0 : rs + 2);
            ret.add(entry);
        }
        return ret;
    }
}

