/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public abstract class BlockSource
implements AutoCloseable {
    public static BlockSource from(final byte[] content2) {
        return new BlockSource(){

            @Override
            public ByteBuffer read(long pos, int cnt) {
                ByteBuffer buf = ByteBuffer.allocate(cnt);
                if (pos < (long)content2.length) {
                    int p = (int)pos;
                    int n = Math.min(cnt, content2.length - p);
                    buf.put(content2, p, n);
                }
                return buf;
            }

            @Override
            public long size() {
                return content2.length;
            }

            @Override
            public void close() {
            }
        };
    }

    public static BlockSource from(FileInputStream in) {
        return BlockSource.from(in.getChannel());
    }

    public static BlockSource from(final FileChannel ch) {
        return new BlockSource(){

            @Override
            public ByteBuffer read(long pos, int blockSize) throws IOException {
                int n;
                ByteBuffer b2 = ByteBuffer.allocate(blockSize);
                ch.position(pos);
                while ((n = ch.read(b2)) > 0 && b2.position() < blockSize) {
                }
                return b2;
            }

            @Override
            public long size() throws IOException {
                return ch.size();
            }

            @Override
            public void close() {
                try {
                    ch.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }

    public abstract ByteBuffer read(long var1, int var3) throws IOException;

    public abstract long size() throws IOException;

    public void adviseSequentialRead(long startPos, long endPos) {
    }

    @Override
    public abstract void close();
}

