/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.memory;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.StringUtils;

public final class TernarySearchTree<Value> {
    private static final char WILDCARD = '?';
    private final ReadWriteLock lock;
    private final AtomicInteger size = new AtomicInteger(0);
    private Node<Value> root;

    private static void validateKey(String key2) {
        if (StringUtils.isEmptyOrNull(key2)) {
            throw new IllegalArgumentException(JGitText.get().illegalTernarySearchTreeKey);
        }
    }

    private static <V> void validateValue(V value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(JGitText.get().illegalTernarySearchTreeValue);
        }
    }

    public TernarySearchTree() {
        this.lock = new ReentrantReadWriteLock();
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public int replace(Iterable<Map.Entry<String, Value>> loader) {
        this.lock.writeLock().lock();
        try {
            this.clear();
            for (Map.Entry<String, Value> e2 : loader) {
                this.insertImpl(e2.getKey(), e2.getValue());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.size.get();
    }

    public int reload(Iterable<Map.Entry<String, Value>> loader) {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<String, Value> e2 : loader) {
                this.insertImpl(e2.getKey(), e2.getValue());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.size.get();
    }

    public int delete(Iterable<String> delete2) {
        this.lock.writeLock().lock();
        try {
            for (String s2 : delete2) {
                this.delete(s2);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.size.get();
    }

    public int size() {
        return this.size.get();
    }

    @Nullable
    public Value get(String key2) {
        TernarySearchTree.validateKey(key2);
        this.lock.readLock().lock();
        try {
            Node<Value> node = this.get(this.root, key2, 0);
            if (node == null) {
                return null;
            }
            Object Value2 = node.val;
            return Value2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean contains(String key2) {
        return this.get(key2) != null;
    }

    public int insert(String key2, Value value2) {
        this.lock.writeLock().lock();
        try {
            this.insertImpl(key2, value2);
            int n = this.size.get();
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int insert(Map<String, Value> map2) {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<String, Value> e2 : map2.entrySet()) {
                this.insertImpl(e2.getKey(), e2.getValue());
            }
            int n = this.size.get();
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void insertImpl(String key2, Value value2) {
        TernarySearchTree.validateValue(value2);
        if (!this.contains(key2)) {
            this.size.addAndGet(1);
        }
        this.root = this.insert(this.root, key2, value2, 0);
    }

    public int delete(String key2) {
        this.lock.writeLock().lock();
        try {
            if (this.contains(key2)) {
                this.size.addAndGet(-1);
                this.root = this.insert(this.root, key2, null, 0);
            }
            int n = this.size.get();
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.size.set(0);
            this.root = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Nullable
    public String keyLongestPrefixOf(String query2) {
        if (StringUtils.isEmptyOrNull(query2)) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            int length = 0;
            Node<Value> node = this.root;
            int i2 = 0;
            while (node != null && i2 < query2.length()) {
                char c2 = query2.charAt(i2);
                if (node.c > c2) {
                    node = node.lo;
                    continue;
                }
                if (node.c < c2) {
                    node = node.hi;
                    continue;
                }
                ++i2;
                if (node.hasValue()) {
                    length = i2;
                }
                node = node.eq;
            }
            String string = query2.substring(0, length);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Iterable<String> getKeys() {
        ArrayDeque<String> queue = new ArrayDeque<String>();
        this.lock.readLock().lock();
        try {
            this.findKeysWithPrefix(this.root, new StringBuilder(), queue);
            ArrayDeque<String> arrayDeque = queue;
            return arrayDeque;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Iterable<String> getKeysWithPrefix(String prefix2) {
        ArrayDeque<String> keys2 = new ArrayDeque<String>();
        if (prefix2 == null) {
            return keys2;
        }
        if (prefix2.isEmpty()) {
            return this.getKeys();
        }
        this.lock.readLock().lock();
        try {
            TernarySearchTree.validateKey(prefix2);
            Node<Value> node = this.get(this.root, prefix2, 0);
            if (node == null) {
                ArrayDeque<String> arrayDeque = keys2;
                return arrayDeque;
            }
            if (node.hasValue()) {
                keys2.add(prefix2);
            }
            this.findKeysWithPrefix(node.eq, new StringBuilder(prefix2), keys2);
            ArrayDeque<String> arrayDeque = keys2;
            return arrayDeque;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<String, Value> getAll() {
        HashMap entries2 = new HashMap();
        this.lock.readLock().lock();
        try {
            this.findWithPrefix(this.root, new StringBuilder(), entries2);
            HashMap hashMap = entries2;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<Value> getAllValues() {
        ArrayList values2 = new ArrayList();
        this.lock.readLock().lock();
        try {
            this.findValuesWithPrefix(this.root, new StringBuilder(), values2);
            ArrayList arrayList = values2;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<String, Value> getWithPrefix(String prefix2) {
        HashMap entries2 = new HashMap();
        if (prefix2 == null) {
            return entries2;
        }
        if (prefix2.isEmpty()) {
            return this.getAll();
        }
        this.lock.readLock().lock();
        try {
            TernarySearchTree.validateKey(prefix2);
            Node<Value> node = this.get(this.root, prefix2, 0);
            if (node == null) {
                HashMap hashMap = entries2;
                return hashMap;
            }
            if (node.hasValue()) {
                entries2.put(prefix2, node.val);
            }
            this.findWithPrefix(node.eq, new StringBuilder(prefix2), entries2);
            HashMap hashMap = entries2;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<Value> getValuesWithPrefix(String prefix2) {
        ArrayList values2 = new ArrayList();
        if (prefix2 == null) {
            return values2;
        }
        if (prefix2.isEmpty()) {
            return this.getAllValues();
        }
        this.lock.readLock().lock();
        try {
            TernarySearchTree.validateKey(prefix2);
            Node<Value> node = this.get(this.root, prefix2, 0);
            if (node == null) {
                ArrayList arrayList = values2;
                return arrayList;
            }
            if (node.hasValue()) {
                values2.add(node.val);
            }
            this.findValuesWithPrefix(node.eq, new StringBuilder(prefix2), values2);
            ArrayList arrayList = values2;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Iterable<String> getKeysMatching(String pattern2) {
        ArrayDeque<String> keys2 = new ArrayDeque<String>();
        this.lock.readLock().lock();
        try {
            this.findKeysWithPrefix(this.root, new StringBuilder(), 0, pattern2, keys2);
            ArrayDeque<String> arrayDeque = keys2;
            return arrayDeque;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Node<Value> get(Node<Value> node, String key2, int depth) {
        if (node == null) {
            return null;
        }
        char c2 = key2.charAt(depth);
        if (node.c > c2) {
            return this.get(node.lo, key2, depth);
        }
        if (node.c < c2) {
            return this.get(node.hi, key2, depth);
        }
        if (depth < key2.length() - 1) {
            return this.get(node.eq, key2, depth + 1);
        }
        return node;
    }

    private Node<Value> insert(Node<Value> node, String key2, Value val, int depth) {
        char c2 = key2.charAt(depth);
        if (node == null) {
            node = new Node(c2);
        }
        if (node.c > c2) {
            node.lo = this.insert(node.lo, key2, val, depth);
        } else if (node.c < c2) {
            node.hi = this.insert(node.hi, key2, val, depth);
        } else if (depth < key2.length() - 1) {
            node.eq = this.insert(node.eq, key2, val, depth + 1);
        } else {
            node.val = val;
        }
        return node;
    }

    private void findKeysWithPrefix(Node<Value> node, StringBuilder prefix2, Queue<String> keys2) {
        if (node == null) {
            return;
        }
        this.findKeysWithPrefix(node.lo, prefix2, keys2);
        if (node.hasValue()) {
            keys2.add(prefix2.toString() + node.c);
        }
        this.findKeysWithPrefix(node.eq, prefix2.append(node.c), keys2);
        prefix2.deleteCharAt(prefix2.length() - 1);
        this.findKeysWithPrefix(node.hi, prefix2, keys2);
    }

    private void findWithPrefix(Node<Value> node, StringBuilder prefix2, Map<String, Value> entries2) {
        if (node == null) {
            return;
        }
        this.findWithPrefix(node.lo, prefix2, entries2);
        if (node.hasValue()) {
            entries2.put(prefix2.toString() + node.c, node.val);
        }
        this.findWithPrefix(node.eq, prefix2.append(node.c), entries2);
        prefix2.deleteCharAt(prefix2.length() - 1);
        this.findWithPrefix(node.hi, prefix2, entries2);
    }

    private void findValuesWithPrefix(Node<Value> node, StringBuilder prefix2, List<Value> values2) {
        if (node == null) {
            return;
        }
        this.findValuesWithPrefix(node.lo, prefix2, values2);
        if (node.hasValue()) {
            values2.add(node.val);
        }
        this.findValuesWithPrefix(node.eq, prefix2.append(node.c), values2);
        prefix2.deleteCharAt(prefix2.length() - 1);
        this.findValuesWithPrefix(node.hi, prefix2, values2);
    }

    private void findKeysWithPrefix(Node<Value> node, StringBuilder prefix2, int i2, String pattern2, Queue<String> keys2) {
        if (node == null || StringUtils.isEmptyOrNull(pattern2)) {
            return;
        }
        char c2 = pattern2.charAt(i2);
        if (c2 == '?' || node.c > c2) {
            this.findKeysWithPrefix(node.lo, prefix2, i2, pattern2, keys2);
        }
        if (c2 == '?' || node.c == c2) {
            if (i2 == pattern2.length() - 1 && node.hasValue()) {
                keys2.add(prefix2.toString() + node.c);
            }
            if (i2 < pattern2.length() - 1) {
                this.findKeysWithPrefix(node.eq, prefix2.append(node.c), i2 + 1, pattern2, keys2);
                prefix2.deleteCharAt(prefix2.length() - 1);
            }
        }
        if (c2 == '?' || node.c < c2) {
            this.findKeysWithPrefix(node.hi, prefix2, i2, pattern2, keys2);
        }
    }

    public static interface Loader<Value> {
        public Map<String, Value> loadAll();
    }

    private static class Node<Value> {
        final char c;
        Node<Value> lo;
        Node<Value> eq;
        Node<Value> hi;
        Value val;

        Node(char c2) {
            this.c = c2;
        }

        boolean hasValue() {
            return this.val != null;
        }
    }
}

