/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.midx;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.io.CancellableDigestOutputStream;
import org.eclipse.jgit.internal.storage.midx.PackIndexMerger;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.util.NB;

public class MultiPackIndexWriter {
    private static final int LIMIT_31_BITS = Integer.MAX_VALUE;
    private static final int MIDX_HEADER_SIZE = 12;

    public long write(ProgressMonitor monitor, OutputStream outputStream2, Map<String, PackIndex> inputs) throws IOException {
        PackIndexMerger data2 = new PackIndexMerger(inputs);
        List<ChunkHeader> chunkHeaders = this.createChunkHeaders(data2);
        long expectedSize = MultiPackIndexWriter.calculateExpectedSize(chunkHeaders);
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try (CancellableDigestOutputStream out2 = new CancellableDigestOutputStream(monitor, outputStream2);){
                this.writeHeader(out2, chunkHeaders.size(), data2.getPackCount());
                this.writeChunkLookup(out2, chunkHeaders);
                WriteContext ctx = new WriteContext(out2, data2);
                for (ChunkHeader chunk : chunkHeaders) {
                    chunk.writerFn.write(ctx);
                }
                this.writeCheckSum(out2);
                if (expectedSize != out2.length()) {
                    throw new IllegalStateException(String.format(JGitText.get().multiPackIndexUnexpectedSize, expectedSize, out2.length()));
                }
                return expectedSize;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (InterruptedIOException e2) {
            throw new IOException(JGitText.get().multiPackIndexWritingCancelled, e2);
        }
    }

    private static long calculateExpectedSize(List<ChunkHeader> chunks) {
        int chunkLookup = (chunks.size() + 1) * 12;
        long chunkContent = chunks.stream().mapToLong(c2 -> c2.size).sum();
        return (long)(12 + chunkLookup) + chunkContent + 20L;
    }

    private List<ChunkHeader> createChunkHeaders(PackIndexMerger data2) {
        ArrayList<ChunkHeader> chunkHeaders = new ArrayList<ChunkHeader>();
        chunkHeaders.add(new ChunkHeader(1330201670, 1024L, this::writeFanoutTable));
        chunkHeaders.add(new ChunkHeader(1330201676, (long)data2.getUniqueObjectCount() * 20L, this::writeOidLookUp));
        chunkHeaders.add(new ChunkHeader(0x4F4F4646, 8L * (long)data2.getUniqueObjectCount(), this::writeObjectOffsets));
        if (data2.needsLargeOffsetsChunk()) {
            chunkHeaders.add(new ChunkHeader(1280263750, 8L * (long)data2.getOffsetsOver31BitsCount(), this::writeObjectLargeOffsets));
        }
        chunkHeaders.add(new ChunkHeader(1380533336, 4L * (long)data2.getUniqueObjectCount(), this::writeRidx));
        int packNamesSize = data2.getPackNames().stream().mapToInt(String::length).map(i2 -> i2 + 1).sum();
        chunkHeaders.add(new ChunkHeader(1347305805, packNamesSize, this::writePackfileNames));
        return chunkHeaders;
    }

    private void writeHeader(CancellableDigestOutputStream out2, int numChunks, int packCount) throws IOException {
        byte[] headerBuffer = new byte[12];
        NB.encodeInt32(headerBuffer, 0, 1296647256);
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[2] = (byte)numChunks;
        byte[] buff = byArray;
        System.arraycopy(buff, 0, headerBuffer, 4, 4);
        NB.encodeInt32(headerBuffer, 8, packCount);
        out2.write(headerBuffer, 0, headerBuffer.length);
        out2.flush();
    }

    private void writeChunkLookup(CancellableDigestOutputStream out2, List<ChunkHeader> chunkHeaders) throws IOException {
        long chunkStart = 12L + (long)(chunkHeaders.size() + 1) * 12L;
        byte[] chunkEntry = new byte[12];
        for (ChunkHeader chunkHeader : chunkHeaders) {
            NB.encodeInt32(chunkEntry, 0, chunkHeader.chunkId);
            NB.encodeInt64(chunkEntry, 4, chunkStart);
            out2.write(chunkEntry);
            chunkStart += chunkHeader.size;
        }
        NB.encodeInt32(chunkEntry, 0, 0);
        NB.encodeInt64(chunkEntry, 4, chunkStart);
        out2.write(chunkEntry);
    }

    private void writeFanoutTable(WriteContext ctx) throws IOException {
        byte[] tmp = new byte[4];
        int[] fanout = new int[256];
        Iterator<PackIndexMerger.MidxMutableEntry> iterator2 = ctx.data.bySha1Iterator();
        while (iterator2.hasNext()) {
            PackIndexMerger.MidxMutableEntry e2 = iterator2.next();
            int n = e2.getObjectId().getFirstByte() & 0xFF;
            fanout[n] = fanout[n] + 1;
        }
        int i2 = 1;
        while (i2 < fanout.length) {
            int n = i2;
            fanout[n] = fanout[n] + fanout[i2 - 1];
            ++i2;
        }
        int[] nArray = fanout;
        int n = fanout.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            NB.encodeInt32(tmp, 0, n3);
            ctx.out.write(tmp, 0, 4);
            ++n2;
        }
    }

    private void writeOidLookUp(WriteContext ctx) throws IOException {
        byte[] tmp = new byte[20];
        Iterator<PackIndexMerger.MidxMutableEntry> iterator2 = ctx.data.bySha1Iterator();
        while (iterator2.hasNext()) {
            PackIndexMerger.MidxMutableEntry e2 = iterator2.next();
            e2.getObjectId().copyRawTo(tmp, 0);
            ctx.out.write(tmp, 0, 20);
        }
    }

    private void writeObjectOffsets(WriteContext ctx) throws IOException {
        byte[] entry = new byte[8];
        Iterator<PackIndexMerger.MidxMutableEntry> iterator2 = ctx.data.bySha1Iterator();
        while (iterator2.hasNext()) {
            PackIndexMerger.MidxMutableEntry e2 = iterator2.next();
            NB.encodeInt32(entry, 0, e2.getPackId());
            if (!ctx.data.needsLargeOffsetsChunk() || MultiPackIndexWriter.fitsIn31bits(e2.getOffset())) {
                NB.encodeInt32(entry, 4, (int)e2.getOffset());
            } else {
                int offloadedPosition = ctx.largeOffsets.append(e2.getOffset());
                NB.encodeInt32(entry, 4, offloadedPosition | Integer.MIN_VALUE);
            }
            ctx.out.write(entry);
        }
    }

    private void writeRidx(WriteContext ctx) throws IOException {
        HashMap<Integer, List> packOffsets = new HashMap<Integer, List>(ctx.data.getPackCount());
        Iterator<PackIndexMerger.MidxMutableEntry> iterator2 = ctx.data.bySha1Iterator();
        int midxPosition = 0;
        while (iterator2.hasNext()) {
            PackIndexMerger.MidxMutableEntry e2 = iterator2.next();
            OffsetPosition op = new OffsetPosition(e2.getOffset(), midxPosition);
            ++midxPosition;
            packOffsets.computeIfAbsent(e2.getPackId(), k2 -> new ArrayList()).add(op);
        }
        int i2 = 0;
        while (i2 < ctx.data.getPackCount()) {
            List offsetsForPack = (List)packOffsets.get(i2);
            if (offsetsForPack != null) {
                offsetsForPack.sort(Comparator.comparing(OffsetPosition::offset));
                byte[] ridxForPack = new byte[4 * offsetsForPack.size()];
                int j2 = 0;
                while (j2 < offsetsForPack.size()) {
                    NB.encodeInt32(ridxForPack, j2 * 4, ((OffsetPosition)offsetsForPack.get((int)j2)).position);
                    ++j2;
                }
                ctx.out.write(ridxForPack);
            }
            ++i2;
        }
    }

    private void writeObjectLargeOffsets(WriteContext ctx) throws IOException {
        ctx.out.write(ctx.largeOffsets.offsets, 0, ctx.largeOffsets.bytePosition);
    }

    private void writePackfileNames(WriteContext ctx) throws IOException {
        for (String packName : ctx.data.getPackNames()) {
            ctx.out.write(packName.getBytes(StandardCharsets.UTF_8));
            ctx.out.write(0);
        }
    }

    private void writeCheckSum(CancellableDigestOutputStream out2) throws IOException {
        out2.write(out2.getDigest());
        out2.flush();
    }

    private static boolean fitsIn31bits(long offset) {
        return offset <= Integer.MAX_VALUE;
    }

    private record ChunkHeader(int chunkId, long size, ChunkWriter writerFn) {
    }

    @FunctionalInterface
    private static interface ChunkWriter {
        public void write(WriteContext var1) throws IOException;
    }

    private static class LargeOffsets {
        private final byte[] offsets;
        private int bytePosition;

        LargeOffsets(int largeOffsetsCount) {
            this.offsets = new byte[largeOffsetsCount * 8];
            this.bytePosition = 0;
        }

        int append(long largeOffset) {
            int at = this.bytePosition;
            NB.encodeInt64(this.offsets, at, largeOffset);
            this.bytePosition += 8;
            return at / 8;
        }
    }

    private record OffsetPosition(long offset, int position) {
    }

    private static class WriteContext {
        final CancellableDigestOutputStream out;
        final PackIndexMerger data;
        final LargeOffsets largeOffsets;

        WriteContext(CancellableDigestOutputStream out2, PackIndexMerger data2) {
            this.out = out2;
            this.data = data2;
            this.largeOffsets = new LargeOffsets(data2.getOffsetsOver31BitsCount());
        }
    }
}

