/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import org.eclipse.jgit.internal.storage.pack.DeltaIndex;

class DeltaIndexScanner {
    final int[] table;
    final long[] entries;
    final int[] next;
    final int tableMask;
    private int entryCnt;

    DeltaIndexScanner(byte[] raw, int len2) {
        len2 -= len2 % 16;
        int worstCaseBlockCnt = len2 / 16;
        if (worstCaseBlockCnt < 1) {
            this.table = new int[0];
            this.tableMask = 0;
            this.entries = new long[0];
            this.next = new int[0];
        } else {
            this.table = new int[DeltaIndexScanner.tableSize(worstCaseBlockCnt)];
            this.tableMask = this.table.length - 1;
            this.entries = new long[1 + worstCaseBlockCnt];
            this.next = new int[this.entries.length];
            this.scan(raw, len2);
        }
    }

    private void scan(byte[] raw, int end2) {
        int lastHash = 0;
        int ptr = end2 - 16;
        do {
            int key2;
            int tIdx;
            int head2;
            if ((head2 = this.table[tIdx = (key2 = DeltaIndex.hashBlock(raw, ptr)) & this.tableMask]) != 0 && lastHash == key2) {
                this.entries[head2] = (long)key2 << 32 | (long)ptr;
            } else {
                int eIdx = ++this.entryCnt;
                this.entries[eIdx] = (long)key2 << 32 | (long)ptr;
                this.next[eIdx] = head2;
                this.table[tIdx] = eIdx;
            }
            lastHash = key2;
        } while ((ptr -= 16) >= 0);
    }

    private static int tableSize(int worstCaseBlockCnt) {
        int shift = 32 - Integer.numberOfLeadingZeros(worstCaseBlockCnt);
        int sz = 1 << shift - 1;
        if (sz < worstCaseBlockCnt) {
            sz <<= 1;
        }
        return sz;
    }
}

