/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.storage.pack.DeltaCache;
import org.eclipse.jgit.internal.storage.pack.DeltaIndex;
import org.eclipse.jgit.internal.storage.pack.DeltaTask;
import org.eclipse.jgit.internal.storage.pack.DeltaWindowEntry;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.util.TemporaryBuffer;

final class DeltaWindow {
    private static final boolean NEXT_RES = false;
    private static final boolean NEXT_SRC = true;
    private final PackConfig config;
    private final DeltaCache deltaCache;
    private final ObjectReader reader;
    private final ProgressMonitor monitor;
    private final long bytesPerUnit;
    private long bytesProcessed;
    private final long maxMemory;
    private final int maxDepth;
    private final ObjectToPack[] toSearch;
    private int cur;
    private int end;
    private long loaded;
    private DeltaWindowEntry res;
    private DeltaWindowEntry bestBase;
    private int deltaLen;
    private Object deltaBuf;
    private Deflater deflater;

    DeltaWindow(PackConfig pc, DeltaCache dc, ObjectReader or, ProgressMonitor pm, long bpu, ObjectToPack[] in, int beginIndex, int endIndex) {
        this.config = pc;
        this.deltaCache = dc;
        this.reader = or;
        this.monitor = pm;
        this.bytesPerUnit = bpu;
        this.toSearch = in;
        this.cur = beginIndex;
        this.end = endIndex;
        this.maxMemory = Math.max(0L, this.config.getDeltaSearchMemoryLimit());
        this.maxDepth = this.config.getMaxDeltaDepth();
        this.res = DeltaWindowEntry.createWindow(this.config.getDeltaSearchWindowSize());
    }

    synchronized DeltaTask.Slice remaining() {
        int e2 = this.end;
        int halfRemaining = e2 - this.cur >>> 1;
        if (halfRemaining == 0) {
            return null;
        }
        int split2 = e2 - halfRemaining;
        int h2 = this.toSearch[split2].getPathHash();
        int n = split2 + 1;
        while (n < e2) {
            if (h2 != this.toSearch[n].getPathHash()) {
                return new DeltaTask.Slice(n, e2);
            }
            ++n;
        }
        if (h2 != this.toSearch[this.cur].getPathHash()) {
            int p = split2 - 1;
            while (this.cur < p) {
                if (h2 != this.toSearch[p].getPathHash()) {
                    return new DeltaTask.Slice(p + 1, e2);
                }
                --p;
            }
        }
        return null;
    }

    synchronized boolean tryStealWork(DeltaTask.Slice s2) {
        if (s2.beginIndex <= this.cur || this.end <= s2.beginIndex) {
            return false;
        }
        this.end = s2.beginIndex;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void search() throws IOException {
        try {
            while (true) {
                ObjectToPack next2;
                DeltaWindow deltaWindow = this;
                synchronized (deltaWindow) {
                    if (this.end <= this.cur) {
                        break;
                    }
                    next2 = this.toSearch[this.cur++];
                }
                if (this.maxMemory != 0L) {
                    this.clear(this.res);
                    long need = DeltaWindow.estimateSize(next2);
                    DeltaWindowEntry n = this.res.next;
                    while (this.maxMemory < this.loaded + need && n != this.res) {
                        this.clear(n);
                        n = n.next;
                    }
                }
                this.res.set(next2);
                this.clearWindowOnTypeSwitch();
                if (this.res.object.isEdge() || this.res.object.doNotAttemptDelta()) {
                    this.keepInWindow();
                    continue;
                }
                if (this.bytesPerUnit <= (this.bytesProcessed += (long)next2.getWeight())) {
                    int d2 = (int)(this.bytesProcessed / this.bytesPerUnit);
                    this.monitor.update(d2);
                    this.bytesProcessed -= (long)d2 * this.bytesPerUnit;
                }
                this.searchInWindow();
            }
        }
        finally {
            if (this.deflater != null) {
                this.deflater.end();
            }
        }
    }

    private static long estimateSize(ObjectToPack ent) {
        return DeltaIndex.estimateIndexSize(ent.getWeight());
    }

    private static long estimateIndexSize(DeltaWindowEntry ent) {
        if (ent.buffer == null) {
            return DeltaWindow.estimateSize(ent.object);
        }
        int len2 = ent.buffer.length;
        return DeltaIndex.estimateIndexSize(len2) - (long)len2;
    }

    private void clearWindowOnTypeSwitch() {
        DeltaWindowEntry p = this.res.prev;
        if (!p.empty() && this.res.type() != p.type()) {
            while (p != this.res) {
                this.clear(p);
                p = p.prev;
            }
        }
    }

    private void clear(DeltaWindowEntry ent) {
        if (ent.index != null) {
            this.loaded -= ent.index.getIndexSize();
        } else if (ent.buffer != null) {
            this.loaded -= (long)ent.buffer.length;
        }
        ent.set(null);
    }

    private void searchInWindow() throws IOException {
        DeltaWindowEntry src = this.res.prev;
        while (src != this.res) {
            if (src.empty()) break;
            if (!this.delta(src)) {
                this.bestBase = null;
                this.deltaBuf = null;
                return;
            }
            src = src.prev;
        }
        if (this.bestBase == null) {
            this.keepInWindow();
            return;
        }
        ObjectToPack srcObj = this.bestBase.object;
        ObjectToPack resObj = this.res.object;
        if (srcObj.isEdge()) {
            resObj.setDeltaBase(srcObj.copy());
        } else {
            resObj.setDeltaBase(srcObj);
        }
        int depth = srcObj.getDeltaDepth() + 1;
        resObj.setDeltaDepth(depth);
        resObj.clearReuseAsIs();
        this.cacheDelta(srcObj, resObj);
        if (depth < this.maxDepth) {
            this.res.makeNext(this.bestBase);
            this.res = this.bestBase.next;
        }
        this.bestBase = null;
        this.deltaBuf = null;
    }

    private boolean delta(DeltaWindowEntry src) throws IOException {
        byte[] resBuf;
        DeltaIndex srcIndex;
        if (this.res.size() < src.size() >>> 4) {
            return true;
        }
        int msz = this.deltaSizeLimit(src);
        if (msz <= 8) {
            return true;
        }
        if (this.res.size() - src.size() > msz) {
            return true;
        }
        try {
            srcIndex = this.index(src);
        }
        catch (LargeObjectException tooBig) {
            return true;
        }
        catch (IOException notAvailable) {
            if (src.object.isEdge()) {
                return true;
            }
            throw notAvailable;
        }
        try {
            resBuf = this.buffer(this.res);
        }
        catch (LargeObjectException tooBig) {
            return false;
        }
        try {
            OutputStream delta;
            OutputStream outputStream2 = delta = msz <= 8192 ? new ArrayStream(msz) : new TemporaryBuffer.Heap(msz);
            if (srcIndex.encode(delta, resBuf, msz)) {
                this.selectDeltaBase(src, delta);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private void selectDeltaBase(DeltaWindowEntry src, OutputStream delta) {
        this.bestBase = src;
        if (delta instanceof ArrayStream) {
            ArrayStream a2 = (ArrayStream)delta;
            this.deltaBuf = a2.buf;
            this.deltaLen = a2.cnt;
        } else {
            TemporaryBuffer.Heap b2 = (TemporaryBuffer.Heap)delta;
            this.deltaBuf = b2;
            this.deltaLen = (int)b2.length();
        }
    }

    private int deltaSizeLimit(DeltaWindowEntry src) {
        if (this.bestBase == null) {
            int n = this.res.size() >>> 1;
            return n * (this.maxDepth - src.depth()) / this.maxDepth;
        }
        int d2 = this.bestBase.depth();
        int n = this.deltaLen;
        return n * (this.maxDepth - src.depth()) / (this.maxDepth - d2);
    }

    private void cacheDelta(ObjectToPack srcObj, ObjectToPack resObj) {
        if (this.deltaCache.canCache(this.deltaLen, srcObj, resObj)) {
            try {
                byte[] zbuf = new byte[DeltaWindow.deflateBound(this.deltaLen)];
                ZipStream zs = new ZipStream(this.deflater(), zbuf);
                if (this.deltaBuf instanceof byte[]) {
                    zs.write((byte[])this.deltaBuf, 0, this.deltaLen);
                } else {
                    ((TemporaryBuffer.Heap)this.deltaBuf).writeTo(zs, null);
                }
                this.deltaBuf = null;
                int len2 = zs.finish();
                resObj.setCachedDelta(this.deltaCache.cache(zbuf, len2, this.deltaLen));
                resObj.setCachedSize(this.deltaLen);
            }
            catch (IOException | OutOfMemoryError err) {
                this.deltaCache.credit(this.deltaLen);
            }
        }
    }

    private static int deflateBound(int insz) {
        return insz + (insz + 7 >> 3) + (insz + 63 >> 6) + 11;
    }

    private void keepInWindow() {
        this.res = this.res.next;
    }

    private DeltaIndex index(DeltaWindowEntry ent) throws MissingObjectException, IncorrectObjectTypeException, IOException, LargeObjectException {
        DeltaIndex idx = ent.index;
        if (idx == null) {
            this.checkLoadable(ent, DeltaWindow.estimateIndexSize(ent));
            try {
                idx = new DeltaIndex(this.buffer(ent));
            }
            catch (OutOfMemoryError noMemory) {
                LargeObjectException.OutOfMemory e2 = new LargeObjectException.OutOfMemory(noMemory);
                e2.setObjectId(ent.object);
                throw e2;
            }
            if (this.maxMemory != 0L) {
                this.loaded += idx.getIndexSize() - idx.getSourceSize();
            }
            ent.index = idx;
        }
        return idx;
    }

    private byte[] buffer(DeltaWindowEntry ent) throws MissingObjectException, IncorrectObjectTypeException, IOException, LargeObjectException {
        byte[] buf = ent.buffer;
        if (buf == null) {
            this.checkLoadable(ent, ent.size());
            buf = PackWriter.buffer(this.config, this.reader, ent.object);
            if (this.maxMemory != 0L) {
                this.loaded += (long)buf.length;
            }
            ent.buffer = buf;
        }
        return buf;
    }

    private void checkLoadable(DeltaWindowEntry ent, long need) {
        if (this.maxMemory == 0L) {
            return;
        }
        DeltaWindowEntry n = this.res.next;
        while (this.maxMemory < this.loaded + need) {
            this.clear(n);
            if (n == ent) {
                throw new LargeObjectException.ExceedsLimit(this.maxMemory, this.loaded + need);
            }
            n = n.next;
        }
    }

    private Deflater deflater() {
        if (this.deflater == null) {
            this.deflater = new Deflater(this.config.getCompressionLevel());
        } else {
            this.deflater.reset();
        }
        return this.deflater;
    }

    static final class ArrayStream
    extends OutputStream {
        final byte[] buf;
        int cnt;

        ArrayStream(int max2) {
            this.buf = new byte[max2];
        }

        @Override
        public void write(int b2) throws IOException {
            if (this.cnt == this.buf.length) {
                throw new IOException();
            }
            this.buf[this.cnt++] = (byte)b2;
        }

        @Override
        public void write(byte[] b2, int off, int len2) throws IOException {
            if (len2 > this.buf.length - this.cnt) {
                throw new IOException();
            }
            System.arraycopy(b2, off, this.buf, this.cnt, len2);
            this.cnt += len2;
        }
    }

    static final class ZipStream
    extends OutputStream {
        private final Deflater deflater;
        private final byte[] zbuf;
        private int outPtr;

        ZipStream(Deflater deflater, byte[] zbuf) {
            this.deflater = deflater;
            this.zbuf = zbuf;
        }

        int finish() throws IOException {
            this.deflater.finish();
            while (true) {
                if (this.outPtr == this.zbuf.length) {
                    throw new EOFException();
                }
                int n = this.deflater.deflate(this.zbuf, this.outPtr, this.zbuf.length - this.outPtr);
                if (n == 0) {
                    if (this.deflater.finished()) {
                        return this.outPtr;
                    }
                    throw new IOException();
                }
                this.outPtr += n;
            }
        }

        @Override
        public void write(byte[] b2, int off, int len2) throws IOException {
            this.deflater.setInput(b2, off, len2);
            while (true) {
                if (this.outPtr == this.zbuf.length) {
                    throw new EOFException();
                }
                int n = this.deflater.deflate(this.zbuf, this.outPtr, this.zbuf.length - this.outPtr);
                if (n == 0) {
                    if (this.deflater.needsInput()) break;
                    throw new IOException();
                }
                this.outPtr += n;
            }
        }

        @Override
        public void write(int b2) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

