/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.internal.storage.io.CancellableDigestOutputStream;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.util.NB;

public final class PackOutputStream
extends CancellableDigestOutputStream {
    private final PackWriter packWriter;
    private final byte[] headerBuffer = new byte[32];
    private final byte[] copyBuffer = new byte[65536];
    private boolean ofsDelta;

    public PackOutputStream(ProgressMonitor writeMonitor, OutputStream out2, PackWriter pw) {
        super(writeMonitor, out2);
        this.packWriter = pw;
    }

    final void writeFileHeader(int version2, long objectCount) throws IOException {
        System.arraycopy(Constants.PACK_SIGNATURE, 0, this.headerBuffer, 0, 4);
        NB.encodeInt32(this.headerBuffer, 4, version2);
        NB.encodeInt32(this.headerBuffer, 8, (int)objectCount);
        this.write(this.headerBuffer, 0, 12);
        this.ofsDelta = this.packWriter.isDeltaBaseAsOffset();
    }

    public final void writeObject(ObjectToPack otp) throws IOException {
        this.packWriter.writeObject(this, otp);
    }

    public final void writeHeader(ObjectToPack otp, long rawLength) throws IOException {
        ObjectToPack b2 = otp.getDeltaBase();
        if (b2 != null && b2.isWritten() & this.ofsDelta) {
            int n = PackOutputStream.objectHeader(rawLength, 6, this.headerBuffer);
            n = PackOutputStream.ofsDelta(this.length() - b2.getOffset(), this.headerBuffer, n);
            this.write(this.headerBuffer, 0, n);
        } else if (otp.isDeltaRepresentation()) {
            int n = PackOutputStream.objectHeader(rawLength, 7, this.headerBuffer);
            otp.getDeltaBaseId().copyRawTo(this.headerBuffer, n);
            this.write(this.headerBuffer, 0, n + 20);
        } else {
            int n = PackOutputStream.objectHeader(rawLength, otp.getType(), this.headerBuffer);
            this.write(this.headerBuffer, 0, n);
        }
    }

    private static final int objectHeader(long len2, int type2, byte[] buf) {
        byte b2 = (byte)((long)(type2 << 4) | len2 & 0xFL);
        int n = 0;
        len2 >>>= 4;
        while (len2 != 0L) {
            buf[n++] = (byte)(0x80 | b2);
            b2 = (byte)(len2 & 0x7FL);
            len2 >>>= 7;
        }
        buf[n++] = b2;
        return n;
    }

    private static final int ofsDelta(long diff, byte[] buf, int p) {
        int n = p += PackOutputStream.ofsDeltaVarIntLength(diff);
        buf[--n] = (byte)(diff & 0x7FL);
        while ((diff >>>= 7) != 0L) {
            buf[--n] = (byte)(0x80L | --diff & 0x7FL);
        }
        return p;
    }

    private static final int ofsDeltaVarIntLength(long v) {
        int n = 1;
        while ((v >>>= 7) != 0L) {
            --v;
            ++n;
        }
        return n;
    }

    public final byte[] getCopyBuffer() {
        return this.copyBuffer;
    }

    void endObject() {
        this.getWriteMonitor().update(1);
    }
}

