/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter;
import org.eclipse.jgit.internal.storage.reftable.ReftableConstants;
import org.eclipse.jgit.lib.CheckoutEntry;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.util.LongList;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;

class BlockReader {
    private byte blockType;
    private long endPosition;
    private byte[] buf;
    private int bufLen;
    private int ptr;
    private int keysStart;
    private int keysEnd;
    private int restartCnt;
    private int restartTbl;
    private byte[] nameBuf = new byte[256];
    private int nameLen;
    private int valueType;

    BlockReader() {
    }

    byte type() {
        return this.blockType;
    }

    long endPosition() {
        return this.endPosition;
    }

    boolean next() {
        return this.ptr < this.keysEnd;
    }

    void parseKey() {
        int pfx = this.readVarint32();
        this.valueType = this.readVarint32();
        int sfx = this.valueType >>> 3;
        if (pfx + sfx > this.nameBuf.length) {
            int n = Math.max(pfx + sfx, this.nameBuf.length * 2);
            this.nameBuf = Arrays.copyOf(this.nameBuf, n);
        }
        System.arraycopy(this.buf, this.ptr, this.nameBuf, pfx, sfx);
        this.ptr += sfx;
        this.nameLen = pfx + sfx;
    }

    String name() {
        int len2 = this.nameLen;
        if (this.blockType == 103) {
            len2 -= 9;
        }
        return RawParseUtils.decode(StandardCharsets.UTF_8, this.nameBuf, 0, len2);
    }

    boolean match(byte[] match2, boolean matchIsPrefix) {
        int len2 = this.nameLen;
        if (this.blockType == 103) {
            len2 -= 9;
        }
        if (matchIsPrefix) {
            return len2 >= match2.length && BlockWriter.compare(match2, 0, match2.length, this.nameBuf, 0, match2.length) == 0;
        }
        return BlockWriter.compare(match2, 0, match2.length, this.nameBuf, 0, len2) == 0;
    }

    long readPositionFromIndex() throws IOException {
        if (this.blockType != 105) {
            throw BlockReader.invalidBlock();
        }
        this.readVarint32();
        int n = this.readVarint32() >>> 3;
        this.ptr += n;
        return this.readVarint64();
    }

    long readUpdateIndexDelta() {
        return this.readVarint64();
    }

    Ref readRef(long minUpdateIndex) throws IOException {
        long updateIndex = minUpdateIndex + this.readUpdateIndexDelta();
        String name = RawParseUtils.decode(StandardCharsets.UTF_8, this.nameBuf, 0, this.nameLen);
        switch (this.valueType & 7) {
            case 0: {
                return BlockReader.newRef(name, updateIndex);
            }
            case 1: {
                return new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name, this.readValueId(), updateIndex);
            }
            case 2: {
                ObjectId id1 = this.readValueId();
                ObjectId id2 = this.readValueId();
                return new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, name, id1, id2, updateIndex);
            }
            case 3: {
                String val = this.readValueString();
                return new SymbolicRef(name, BlockReader.newRef(val, updateIndex), updateIndex);
            }
        }
        throw BlockReader.invalidBlock();
    }

    @Nullable
    LongList readBlockPositionList() {
        int n = this.valueType & 7;
        if (n == 0 && (n = this.readVarint32()) == 0) {
            return null;
        }
        LongList b2 = new LongList(n);
        b2.add(this.readVarint64());
        int j2 = 1;
        while (j2 < n) {
            long prior = b2.get(j2 - 1);
            b2.add(prior + this.readVarint64());
            ++j2;
        }
        return b2;
    }

    long readLogUpdateIndex() {
        return ReftableConstants.reverseUpdateIndex(NB.decodeUInt64(this.nameBuf, this.nameLen - 8));
    }

    @Nullable
    ReflogEntry readLogEntry() {
        if ((this.valueType & 7) == 0) {
            return null;
        }
        final ObjectId oldId = this.readValueId();
        final ObjectId newId = this.readValueId();
        final PersonIdent who = this.readPersonIdent();
        final String msg = this.readValueString();
        return new ReflogEntry(){

            @Override
            public ObjectId getOldId() {
                return oldId;
            }

            @Override
            public ObjectId getNewId() {
                return newId;
            }

            @Override
            public PersonIdent getWho() {
                return who;
            }

            @Override
            public String getComment() {
                return msg;
            }

            @Override
            public CheckoutEntry parseCheckout() {
                return null;
            }
        };
    }

    private ObjectId readValueId() {
        ObjectId id = ObjectId.fromRaw(this.buf, this.ptr);
        this.ptr += 20;
        return id;
    }

    private String readValueString() {
        int len2 = this.readVarint32();
        int end2 = this.ptr + len2;
        String s2 = RawParseUtils.decode(StandardCharsets.UTF_8, this.buf, this.ptr, end2);
        this.ptr = end2;
        return s2;
    }

    private PersonIdent readPersonIdent() {
        String name = this.readValueString();
        String email = this.readValueString();
        long epochSeconds = this.readVarint64();
        ZoneOffset tz = ZoneOffset.ofTotalSeconds(this.readInt16() * 60);
        return new PersonIdent(name, email, Instant.ofEpochSecond(epochSeconds), tz);
    }

    void readBlock(BlockSource src, long pos, int fileBlockSize) throws IOException {
        this.readBlockIntoBuf(src, pos, fileBlockSize);
        this.parseBlockStart(src, pos, fileBlockSize);
    }

    private void readBlockIntoBuf(BlockSource src, long pos, int size2) throws IOException {
        ByteBuffer b2 = src.read(pos, size2);
        this.bufLen = b2.position();
        if (this.bufLen <= 0) {
            throw BlockReader.invalidBlock();
        }
        if (b2.hasArray() && b2.arrayOffset() == 0) {
            this.buf = b2.array();
        } else {
            this.buf = new byte[this.bufLen];
            b2.flip();
            b2.get(this.buf);
        }
        this.endPosition = pos + (long)this.bufLen;
    }

    private void parseBlockStart(BlockSource src, long pos, int fileBlockSize) throws IOException {
        this.ptr = 0;
        if (pos == 0L) {
            if (this.bufLen == 24) {
                this.setupEmptyFileBlock();
                return;
            }
            this.ptr += 24;
        }
        int typeAndSize = NB.decodeInt32(this.buf, this.ptr);
        this.ptr += 4;
        this.blockType = (byte)(typeAndSize >>> 24);
        int blockLen = BlockReader.decodeBlockLen(typeAndSize);
        if (this.blockType == 103) {
            long deflatedSize = this.inflateBuf(src, pos, blockLen, fileBlockSize);
            this.endPosition = pos + 4L + deflatedSize;
        } else if (this.bufLen < blockLen) {
            this.readBlockIntoBuf(src, pos, blockLen);
        } else if (this.bufLen > blockLen) {
            this.bufLen = blockLen;
        }
        if (this.blockType != 82) {
            this.restartCnt = NB.decodeUInt16(this.buf, this.bufLen - 2);
            this.restartTbl = this.bufLen - (this.restartCnt * 3 + 2);
            this.keysStart = this.ptr;
            this.keysEnd = this.restartTbl;
        } else {
            this.keysStart = this.ptr;
            this.keysEnd = this.ptr;
        }
    }

    static int decodeBlockLen(int typeAndSize) {
        return typeAndSize & 0xFFFFFF;
    }

    private long inflateBuf(BlockSource src, long pos, int blockLen, int fileBlockSize) throws IOException {
        long deflatedSize;
        byte[] dst;
        block8: {
            dst = new byte[blockLen];
            System.arraycopy(this.buf, 0, dst, 0, 4);
            deflatedSize = 0L;
            Inflater inf = InflaterCache.get();
            try {
                try {
                    inf.setInput(this.buf, this.ptr, this.bufLen - this.ptr);
                    int o = 4;
                    while (true) {
                        int n = inf.inflate(dst, o, dst.length - o);
                        o += n;
                        if (inf.finished()) {
                            deflatedSize = inf.getBytesRead();
                            break block8;
                        }
                        if (n <= 0 && inf.needsInput()) {
                            long p = pos + 4L + inf.getBytesRead();
                            this.readBlockIntoBuf(src, p, fileBlockSize);
                            inf.setInput(this.buf, 0, this.bufLen);
                            continue;
                        }
                        if (n <= 0) break;
                    }
                    throw BlockReader.invalidBlock();
                }
                catch (DataFormatException e2) {
                    throw BlockReader.invalidBlock(e2);
                }
            }
            finally {
                InflaterCache.release(inf);
            }
        }
        this.buf = dst;
        this.bufLen = dst.length;
        return deflatedSize;
    }

    private void setupEmptyFileBlock() {
        this.blockType = (byte)82;
        this.ptr = 24;
        this.restartCnt = 0;
        this.restartTbl = this.bufLen;
        this.keysStart = this.bufLen;
        this.keysEnd = this.bufLen;
    }

    void verifyIndex() throws IOException {
        if (this.blockType != 105) {
            throw BlockReader.invalidBlock();
        }
    }

    int seekKey(byte[] key2) {
        int cmp;
        int p;
        int low = 0;
        int end2 = this.restartCnt;
        do {
            int mid = low + end2 >>> 1;
            p = NB.decodeUInt24(this.buf, this.restartTbl + mid * 3);
            this.ptr = p + 1;
            int n = this.readVarint32() >>> 3;
            cmp = BlockWriter.compare(key2, 0, key2.length, this.buf, this.ptr, n);
            if (cmp < 0) {
                end2 = mid;
                continue;
            }
            if (cmp == 0) {
                this.ptr = p;
                return 0;
            }
            low = mid + 1;
        } while (low < end2);
        return this.scanToKey(key2, p, low, cmp);
    }

    private int scanToKey(byte[] key2, int rPtr, int rIdx, int rCmp) {
        int cmp;
        if (rCmp < 0) {
            if (rIdx == 0) {
                this.ptr = this.keysStart;
                return -1;
            }
            this.ptr = NB.decodeUInt24(this.buf, this.restartTbl + (rIdx - 1) * 3);
        } else {
            this.ptr = rPtr;
        }
        do {
            int savePtr = this.ptr;
            this.parseKey();
            cmp = BlockWriter.compare(key2, 0, key2.length, this.nameBuf, 0, this.nameLen);
            if (cmp <= 0) {
                this.ptr = savePtr;
                return cmp < 0 && savePtr == this.keysStart ? -1 : 0;
            }
            this.skipValue();
        } while (this.ptr < this.keysEnd);
        return cmp;
    }

    void skipValue() {
        switch (this.blockType) {
            case 114: {
                this.readVarint64();
                switch (this.valueType & 7) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        this.ptr += 20;
                        return;
                    }
                    case 2: {
                        this.ptr += 40;
                        return;
                    }
                    case 3: {
                        this.skipString();
                        return;
                    }
                }
                break;
            }
            case 111: {
                int n = this.valueType & 7;
                if (n == 0) {
                    n = this.readVarint32();
                }
                while (n-- > 0) {
                    this.readVarint32();
                }
                return;
            }
            case 105: {
                this.readVarint32();
                return;
            }
            case 103: {
                if ((this.valueType & 7) == 0) {
                    return;
                }
                if ((this.valueType & 7) != 1) break;
                this.ptr += 40;
                this.skipString();
                this.skipString();
                this.readVarint64();
                this.ptr += 2;
                this.skipString();
                return;
            }
        }
        throw new IllegalStateException();
    }

    private void skipString() {
        int n = this.readVarint32();
        this.ptr += n;
    }

    private short readInt16() {
        short result2 = (short)NB.decodeUInt16(this.buf, this.ptr);
        this.ptr += 2;
        return result2;
    }

    private int readVarint32() {
        byte c2 = this.buf[this.ptr++];
        int val = c2 & 0x7F;
        while ((c2 & 0x80) != 0) {
            c2 = this.buf[this.ptr++];
            ++val;
            val <<= 7;
            val |= c2 & 0x7F;
        }
        return val;
    }

    private long readVarint64() {
        byte c2 = this.buf[this.ptr++];
        long val = c2 & 0x7F;
        while ((c2 & 0x80) != 0) {
            c2 = this.buf[this.ptr++];
            ++val;
            val <<= 7;
            val |= (long)(c2 & 0x7F);
        }
        return val;
    }

    private static Ref newRef(String name, long updateIndex) {
        return new ObjectIdRef.Unpeeled(Ref.Storage.NEW, name, null, updateIndex);
    }

    private static IOException invalidBlock() {
        return BlockReader.invalidBlock(null);
    }

    private static IOException invalidBlock(Throwable cause) {
        return new IOException(JGitText.get().invalidReftableBlock, cause);
    }
}

