/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.eclipse.jgit.internal.storage.reftable.LogCursor;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.Reftable;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.ReflogEntry;

public class MergedReftable
extends Reftable {
    private final ReftableReader[] tables;

    public MergedReftable(List<ReftableReader> tableStack) {
        ReftableReader[] reftableReaderArray = this.tables = tableStack.toArray(new ReftableReader[0]);
        int n = this.tables.length;
        int n2 = 0;
        while (n2 < n) {
            ReftableReader t2 = reftableReaderArray[n2];
            t2.setIncludeDeletes(true);
            ++n2;
        }
    }

    @Override
    public long maxUpdateIndex() throws IOException {
        if (this.tables.length == 0) {
            return 0L;
        }
        long maxUpdateIndex = this.tables[this.tables.length - 1].maxUpdateIndex();
        int i2 = this.tables.length - 2;
        while (i2 >= 0) {
            if (maxUpdateIndex < this.tables[i2].maxUpdateIndex()) {
                maxUpdateIndex = this.tables[i2].maxUpdateIndex();
            }
            --i2;
        }
        return maxUpdateIndex;
    }

    @Override
    public long minUpdateIndex() throws IOException {
        if (this.tables.length == 0) {
            return 0L;
        }
        long minUpdateIndex = this.tables[0].minUpdateIndex();
        int i2 = 1;
        while (i2 < this.tables.length) {
            if (this.tables[i2].minUpdateIndex() < minUpdateIndex) {
                minUpdateIndex = this.tables[i2].minUpdateIndex();
            }
            ++i2;
        }
        return minUpdateIndex;
    }

    @Override
    public boolean hasObjectMap() throws IOException {
        boolean has = true;
        int i2 = 0;
        while (has && i2 < this.tables.length) {
            has = has && this.tables[i2].hasObjectMap();
            ++i2;
        }
        return has;
    }

    @Override
    public RefCursor allRefs() throws IOException {
        MergedRefCursor m4 = new MergedRefCursor();
        int i2 = 0;
        while (i2 < this.tables.length) {
            m4.add(new RefQueueEntry(this.tables[i2].allRefs(), i2));
            ++i2;
        }
        return m4;
    }

    @Override
    public RefCursor seekRef(String name) throws IOException {
        MergedRefCursor m4 = new MergedRefCursor();
        int i2 = 0;
        while (i2 < this.tables.length) {
            m4.add(new RefQueueEntry(this.tables[i2].seekRef(name), i2));
            ++i2;
        }
        return m4;
    }

    @Override
    public RefCursor seekRefsWithPrefix(String prefix2) throws IOException {
        MergedRefCursor m4 = new MergedRefCursor();
        int i2 = 0;
        while (i2 < this.tables.length) {
            m4.add(new RefQueueEntry(this.tables[i2].seekRefsWithPrefix(prefix2), i2));
            ++i2;
        }
        return m4;
    }

    @Override
    public RefCursor byObjectId(AnyObjectId name) throws IOException {
        FilteringMergedRefCursor m4 = new FilteringMergedRefCursor(name);
        int i2 = 0;
        while (i2 < this.tables.length) {
            m4.add(new RefQueueEntry(this.tables[i2].byObjectId(name), i2));
            ++i2;
        }
        return m4;
    }

    @Override
    public LogCursor allLogs() throws IOException {
        MergedLogCursor m4 = new MergedLogCursor();
        int i2 = 0;
        while (i2 < this.tables.length) {
            m4.add(new LogQueueEntry(this.tables[i2].allLogs(), i2));
            ++i2;
        }
        return m4;
    }

    @Override
    public LogCursor seekLog(String refName, long updateIdx) throws IOException {
        MergedLogCursor m4 = new MergedLogCursor();
        int i2 = 0;
        while (i2 < this.tables.length) {
            m4.add(new LogQueueEntry(this.tables[i2].seekLog(refName, updateIdx), i2));
            ++i2;
        }
        return m4;
    }

    int queueSize() {
        return Math.max(1, this.tables.length);
    }

    private class FilteringMergedRefCursor
    extends MergedRefCursor {
        final AnyObjectId filterId;
        Ref filteredRef;

        FilteringMergedRefCursor(AnyObjectId id) {
            this.filterId = id;
            this.filteredRef = null;
        }

        @Override
        public Ref getRef() {
            return this.filteredRef;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean next() throws IOException {
            boolean ok;
            while (ok = super.next()) {
                String name = super.getRef().getName();
                Throwable throwable = null;
                Object var4_5 = null;
                try {
                    RefCursor c2 = MergedReftable.this.seekRef(name);
                    try {
                        if (!c2.next() || !this.filterId.equals(c2.getRef().getObjectId())) continue;
                        this.filteredRef = c2.getRef();
                        return true;
                    }
                    finally {
                        if (c2 == null) continue;
                        c2.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            return false;
        }
    }

    private static class LogQueueEntry {
        final LogCursor lc;
        final int stackIdx;

        static int compare(LogQueueEntry a2, LogQueueEntry b2) {
            int cmp = a2.name().compareTo(b2.name());
            if (cmp == 0) {
                cmp = Long.signum(b2.index() - a2.index());
            }
            if (cmp == 0) {
                cmp = b2.stackIdx - a2.stackIdx;
            }
            return cmp;
        }

        LogQueueEntry(LogCursor lc, int stackIdx) {
            this.lc = lc;
            this.stackIdx = stackIdx;
        }

        String name() {
            return this.lc.getRefName();
        }

        long index() {
            return this.lc.getUpdateIndex();
        }
    }

    private class MergedLogCursor
    extends LogCursor {
        private final PriorityQueue<LogQueueEntry> queue;
        private String refName;
        private long updateIndex;
        private ReflogEntry entry;

        MergedLogCursor() {
            this.queue = new PriorityQueue(MergedReftable.this.queueSize(), LogQueueEntry::compare);
        }

        void add(LogQueueEntry t2) throws IOException {
            if (t2.lc.next()) {
                this.queue.add(t2);
            } else {
                t2.lc.close();
            }
        }

        @Override
        public boolean next() throws IOException {
            boolean include;
            do {
                LogQueueEntry t2;
                if ((t2 = this.queue.poll()) == null) {
                    return false;
                }
                this.refName = t2.lc.getRefName();
                this.updateIndex = t2.lc.getUpdateIndex();
                this.entry = t2.lc.getReflogEntry();
                include = MergedReftable.this.includeDeletes || this.entry != null;
                this.skipShadowed(this.refName, this.updateIndex);
                this.add(t2);
            } while (!include);
            return true;
        }

        private void skipShadowed(String name, long index) throws IOException {
            LogQueueEntry t2;
            while ((t2 = this.queue.peek()) != null && name.equals(t2.name()) && index == t2.index()) {
                this.add((LogQueueEntry)this.queue.remove());
            }
        }

        @Override
        public String getRefName() {
            return this.refName;
        }

        @Override
        public long getUpdateIndex() {
            return this.updateIndex;
        }

        @Override
        public ReflogEntry getReflogEntry() {
            return this.entry;
        }

        @Override
        public void close() {
            while (!this.queue.isEmpty()) {
                ((LogQueueEntry)this.queue.remove()).lc.close();
            }
        }
    }

    private class MergedRefCursor
    extends RefCursor {
        private final PriorityQueue<RefQueueEntry> queue;
        private RefQueueEntry head;
        private Ref ref;

        MergedRefCursor() {
            this.queue = new PriorityQueue(MergedReftable.this.queueSize(), RefQueueEntry::compare);
        }

        void add(RefQueueEntry t2) throws IOException {
            if (!t2.rc.next()) {
                t2.rc.close();
            } else if (this.head == null) {
                RefQueueEntry p = this.queue.peek();
                if (p == null || RefQueueEntry.compare(t2, p) < 0) {
                    this.head = t2;
                } else {
                    this.head = this.queue.poll();
                    this.queue.add(t2);
                }
            } else if (RefQueueEntry.compare(t2, this.head) > 0) {
                this.queue.add(t2);
            } else {
                this.queue.add(this.head);
                this.head = t2;
            }
        }

        @Override
        public boolean next() throws IOException {
            boolean include;
            do {
                RefQueueEntry t2;
                if ((t2 = this.poll()) == null) {
                    return false;
                }
                this.ref = t2.rc.getRef();
                include = MergedReftable.this.includeDeletes || !t2.rc.wasDeleted();
                this.add(t2);
                this.skipShadowedRefs(this.ref.getName());
            } while (!include);
            return true;
        }

        @Override
        public void seekPastPrefix(String prefixName) throws IOException {
            ArrayList<RefQueueEntry> entriesToAdd = new ArrayList<RefQueueEntry>();
            entriesToAdd.addAll(this.queue);
            if (this.head != null) {
                entriesToAdd.add(this.head);
            }
            this.head = null;
            this.queue.clear();
            for (RefQueueEntry entry : entriesToAdd) {
                entry.rc.seekPastPrefix(prefixName);
                this.add(entry);
            }
        }

        private RefQueueEntry poll() {
            RefQueueEntry e2 = this.head;
            if (e2 != null) {
                this.head = null;
                return e2;
            }
            return this.queue.poll();
        }

        private void skipShadowedRefs(String name) throws IOException {
            while (true) {
                RefQueueEntry t2;
                RefQueueEntry refQueueEntry = t2 = this.head != null ? this.head : this.queue.peek();
                if (t2 == null || !name.equals(t2.name())) break;
                this.add(this.poll());
            }
        }

        @Override
        public Ref getRef() {
            return this.ref;
        }

        @Override
        public void close() {
            if (this.head != null) {
                this.head.rc.close();
                this.head = null;
            }
            while (!this.queue.isEmpty()) {
                ((RefQueueEntry)this.queue.remove()).rc.close();
            }
        }
    }

    private static class RefQueueEntry {
        final RefCursor rc;
        final int stackIdx;

        static int compare(RefQueueEntry a2, RefQueueEntry b2) {
            int cmp = a2.name().compareTo(b2.name());
            if (cmp == 0) {
                cmp = Long.signum(b2.updateIndex() - a2.updateIndex());
            }
            if (cmp == 0) {
                cmp = b2.stackIdx - a2.stackIdx;
            }
            return cmp;
        }

        RefQueueEntry(RefCursor rc2, int stackIdx) {
            this.rc = rc2;
            this.stackIdx = stackIdx;
        }

        String name() {
            return this.rc.getRef().getName();
        }

        long updateIndex() {
            return this.rc.getRef().getUpdateIndex();
        }
    }
}

