/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.reftable.MergedReftable;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.Reftable;
import org.eclipse.jgit.internal.storage.reftable.ReftableReflogReader;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.transport.ReceiveCommand;

public abstract class ReftableDatabase {
    private final ReentrantLock lock = new ReentrantLock(true);
    private Reftable mergedTables;

    protected abstract MergedReftable openMergedReftable() throws IOException;

    public long nextUpdateIndex() throws IOException {
        this.lock.lock();
        try {
            long l = this.reader().maxUpdateIndex() + 1L;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ReflogReader getReflogReader(String refname) throws IOException {
        this.lock.lock();
        try {
            ReftableReflogReader reftableReflogReader = new ReftableReflogReader(this.lock, this.reader(), refname);
            return reftableReflogReader;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static ReceiveCommand toCommand(Ref oldRef, Ref newRef) {
        String name;
        ObjectId oldId = ReftableDatabase.toId(oldRef);
        ObjectId newId = ReftableDatabase.toId(newRef);
        String string = name = oldRef != null ? oldRef.getName() : newRef.getName();
        if (oldRef != null && oldRef.isSymbolic()) {
            if (newRef != null) {
                if (newRef.isSymbolic()) {
                    return ReceiveCommand.link(oldRef.getTarget().getName(), newRef.getTarget().getName(), name);
                }
                return ReceiveCommand.unlink(oldRef.getTarget().getName(), newId, name);
            }
            return ReceiveCommand.unlink(oldRef.getTarget().getName(), ObjectId.zeroId(), name);
        }
        if (newRef != null && newRef.isSymbolic()) {
            if (oldRef != null) {
                if (oldRef.isSymbolic()) {
                    return ReceiveCommand.link(oldRef.getTarget().getName(), newRef.getTarget().getName(), name);
                }
                return ReceiveCommand.link(oldId, newRef.getTarget().getName(), name);
            }
            return ReceiveCommand.link(ObjectId.zeroId(), newRef.getTarget().getName(), name);
        }
        return new ReceiveCommand(oldId, newId, name);
    }

    private static ObjectId toId(Ref ref) {
        ObjectId id;
        if (ref != null && (id = ref.getObjectId()) != null) {
            return id;
        }
        return ObjectId.zeroId();
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    private Reftable reader() throws IOException {
        if (!this.lock.isLocked()) {
            throw new IllegalStateException("must hold lock to access merged table");
        }
        if (this.mergedTables == null) {
            this.mergedTables = this.openMergedReftable();
        }
        return this.mergedTables;
    }

    public boolean isNameConflicting(String refName, TreeSet<String> added, Set<String> deleted) throws IOException {
        this.lock.lock();
        try {
            Object prefix2;
            Reftable table = this.reader();
            int lastSlash = refName.lastIndexOf(47);
            while (lastSlash > 0) {
                prefix2 = refName.substring(0, lastSlash);
                if (!deleted.contains(prefix2) && (table.hasRef((String)prefix2) || added.contains(prefix2))) {
                    return true;
                }
                lastSlash = refName.lastIndexOf(47, lastSlash - 1);
            }
            prefix2 = refName + "/";
            RefCursor c2 = table.seekRefsWithPrefix((String)prefix2);
            while (c2.next()) {
                if (deleted.contains(c2.getRef().getName())) continue;
                return true;
            }
            String it = added.ceiling(refName + "/");
            return it != null && it.startsWith((String)prefix2);
            {
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public Ref exactRef(String name) throws IOException {
        this.lock.lock();
        try {
            Reftable table = this.reader();
            Ref ref = table.exactRef(name);
            if (ref != null && ref.isSymbolic()) {
                Ref ref2 = table.resolve(ref);
                return ref2;
            }
            Ref ref3 = ref;
            return ref3;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Ref> getRefsByPrefix(String prefix2) throws IOException {
        ArrayList<Ref> all = new ArrayList<Ref>();
        this.lock.lock();
        try {
            Reftable table = this.reader();
            Throwable throwable = null;
            Object var5_6 = null;
            try (RefCursor rc2 = "".equals(prefix2) ? table.allRefs() : table.seekRefsWithPrefix(prefix2);){
                while (rc2.next()) {
                    Ref ref = table.resolve(rc2.getRef());
                    if (ref == null || ref.getObjectId() == null) continue;
                    all.add(ref);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.lock.unlock();
        }
        return Collections.unmodifiableList(all);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Ref> getRefsByPrefixWithExclusions(String include, Set<String> excludes) throws IOException {
        if (excludes.isEmpty()) {
            return this.getRefsByPrefix(include);
        }
        ArrayList<Ref> results2 = new ArrayList<Ref>();
        this.lock.lock();
        try {
            Reftable table = this.reader();
            Iterator excludeIterator = excludes.stream().sorted().collect(Collectors.toList()).iterator();
            String currentExclusion = excludeIterator.hasNext() ? (String)excludeIterator.next() : null;
            Throwable throwable = null;
            Object var8_9 = null;
            try (RefCursor rc2 = "".equals(include) ? table.allRefs() : table.seekRefsWithPrefix(include);){
                block8: while (true) {
                    if (!rc2.next()) {
                        return Collections.unmodifiableList(results2);
                    }
                    Ref ref = table.resolve(rc2.getRef());
                    if (ref == null || ref.getObjectId() == null) continue;
                    while (true) {
                        if (!excludeIterator.hasNext() || ref.getName().startsWith(currentExclusion) || ref.getName().compareTo(currentExclusion) <= 0) {
                            if (currentExclusion == null || !ref.getName().startsWith(currentExclusion)) break;
                            rc2.seekPastPrefix(currentExclusion);
                            continue block8;
                        }
                        currentExclusion = (String)excludeIterator.next();
                    }
                    results2.add(ref);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasFastTipsWithSha1() throws IOException {
        this.lock.lock();
        try {
            boolean bl = this.reader().hasObjectMap();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<Ref> getTipsWithSha1(ObjectId id) throws IOException {
        this.lock.lock();
        try {
            RefCursor cursor = this.reader().byObjectId(id);
            HashSet<Ref> refs = new HashSet<Ref>();
            while (cursor.next()) {
                refs.add(cursor.getRef());
            }
            HashSet<Ref> hashSet = refs;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearCache() {
        this.lock.lock();
        try {
            this.mergedTables = null;
        }
        finally {
            this.lock.unlock();
        }
    }
}

