/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.zip.CRC32;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.reftable.BlockReader;
import org.eclipse.jgit.internal.storage.reftable.BlockWriter;
import org.eclipse.jgit.internal.storage.reftable.EmptyLogCursor;
import org.eclipse.jgit.internal.storage.reftable.LogCursor;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.Reftable;
import org.eclipse.jgit.internal.storage.reftable.ReftableConstants;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.util.LongList;
import org.eclipse.jgit.util.LongMap;
import org.eclipse.jgit.util.NB;

public class ReftableReader
extends Reftable
implements AutoCloseable {
    private final BlockSource src;
    private int blockSize = -1;
    private long minUpdateIndex;
    private long maxUpdateIndex;
    private long refEnd;
    private long objPosition;
    private long objEnd;
    private long logPosition;
    private long logEnd;
    private int objIdLen;
    private long refIndexPosition = -1L;
    private long objIndexPosition = -1L;
    private long logIndexPosition = -1L;
    private BlockReader refIndex;
    private BlockReader objIndex;
    private BlockReader logIndex;
    private LongMap<BlockReader> indexCache;
    static final LongList EMPTY_LONG_LIST = new LongList(0);

    public ReftableReader(BlockSource src) {
        this.src = src;
    }

    public int blockSize() throws IOException {
        if (this.blockSize == -1) {
            this.readFileHeader();
        }
        return this.blockSize;
    }

    @Override
    public boolean hasObjectMap() throws IOException {
        if (this.objIndexPosition == -1L) {
            this.readFileFooter();
        }
        return this.objPosition > 0L || this.refEnd == 24L || this.refIndexPosition == 0L;
    }

    @Override
    public long minUpdateIndex() throws IOException {
        if (this.blockSize == -1) {
            this.readFileHeader();
        }
        return this.minUpdateIndex;
    }

    @Override
    public long maxUpdateIndex() throws IOException {
        if (this.blockSize == -1) {
            this.readFileHeader();
        }
        return this.maxUpdateIndex;
    }

    @Override
    public RefCursor allRefs() throws IOException {
        if (this.blockSize == -1) {
            this.readFileHeader();
        }
        if (this.refEnd == 0L) {
            this.readFileFooter();
        }
        this.src.adviseSequentialRead(0L, this.refEnd);
        RefCursorImpl i2 = new RefCursorImpl(this.refEnd, null, false);
        i2.block = this.readBlock(0L, this.refEnd);
        return i2;
    }

    @Override
    public RefCursor seekRef(String refName) throws IOException {
        this.initRefIndex();
        byte[] key2 = refName.getBytes(StandardCharsets.UTF_8);
        RefCursorImpl i2 = new RefCursorImpl(this.refEnd, key2, false);
        i2.block = this.seek((byte)114, key2, this.refIndex, 0L, this.refEnd);
        return i2;
    }

    @Override
    public RefCursor seekRefsWithPrefix(String prefix2) throws IOException {
        this.initRefIndex();
        byte[] key2 = prefix2.getBytes(StandardCharsets.UTF_8);
        RefCursorImpl i2 = new RefCursorImpl(this.refEnd, key2, true);
        i2.block = this.seek((byte)114, key2, this.refIndex, 0L, this.refEnd);
        return i2;
    }

    @Override
    public RefCursor byObjectId(AnyObjectId id) throws IOException {
        this.initObjIndex();
        ObjCursorImpl i2 = new ObjCursorImpl(this.refEnd, id);
        if (this.objIndex != null) {
            i2.initSeek();
        } else {
            i2.initScan();
        }
        return i2;
    }

    @Override
    public LogCursor allLogs() throws IOException {
        this.initLogIndex();
        if (this.logPosition > 0L) {
            this.src.adviseSequentialRead(this.logPosition, this.logEnd);
            LogCursorImpl i2 = new LogCursorImpl(this.logEnd, null);
            i2.block = this.readBlock(this.logPosition, this.logEnd);
            return i2;
        }
        return new EmptyLogCursor();
    }

    @Override
    public LogCursor seekLog(String refName, long updateIndex) throws IOException {
        this.initLogIndex();
        if (this.logPosition > 0L) {
            byte[] key2 = BlockWriter.LogEntry.key(refName, updateIndex);
            byte[] match2 = refName.getBytes(StandardCharsets.UTF_8);
            LogCursorImpl i2 = new LogCursorImpl(this.logEnd, match2);
            i2.block = this.seek((byte)103, key2, this.logIndex, this.logPosition, this.logEnd);
            return i2;
        }
        return new EmptyLogCursor();
    }

    private BlockReader seek(byte blockType, byte[] key2, BlockReader idx, long startPos, long endPos) throws IOException {
        if (idx != null) {
            long pos;
            BlockReader block2 = idx;
            do {
                if (block2.seekKey(key2) <= 0) continue;
                return null;
            } while ((block2 = this.readBlock(pos = block2.readPositionFromIndex(), endPos)).type() == 105);
            block2.seekKey(key2);
            return block2;
        }
        if (blockType == 103) {
            BlockReader block3 = this.readBlock(startPos, endPos);
            while (true) {
                if (block3 == null || block3.type() != 103) {
                    return null;
                }
                int result2 = block3.seekKey(key2);
                if (result2 <= 0) {
                    return block3;
                }
                long pos = block3.endPosition();
                if (pos >= endPos) {
                    return null;
                }
                block3 = this.readBlock(pos, endPos);
            }
        }
        return this.binarySearch(blockType, key2, startPos, endPos);
    }

    private BlockReader binarySearch(byte blockType, byte[] key2, long startPos, long endPos) throws IOException {
        if (this.blockSize == 0) {
            BlockReader b2 = this.readBlock(startPos, endPos);
            if (blockType != b2.type()) {
                return null;
            }
            b2.seekKey(key2);
            return b2;
        }
        int low = (int)(startPos / (long)this.blockSize);
        int end2 = this.blocksIn(startPos, endPos);
        BlockReader block2 = null;
        do {
            int mid;
            if (blockType != (block2 = this.readBlock((long)(mid = low + end2 >>> 1) * (long)this.blockSize, endPos)).type()) {
                return null;
            }
            int cmp = block2.seekKey(key2);
            if (cmp < 0) {
                end2 = mid;
                continue;
            }
            if (cmp == 0) break;
            low = mid + 1;
        } while (low < end2);
        return block2;
    }

    private void readFileHeader() throws IOException {
        this.readHeaderOrFooter(0L, 24);
    }

    private void readFileFooter() throws IOException {
        int ftrLen = 68;
        byte[] ftr = this.readHeaderOrFooter(this.src.size() - (long)ftrLen, ftrLen);
        CRC32 crc = new CRC32();
        crc.update(ftr, 0, ftrLen - 4);
        if (crc.getValue() != NB.decodeUInt32(ftr, ftrLen - 4)) {
            throw new IOException(JGitText.get().invalidReftableCRC);
        }
        this.refIndexPosition = NB.decodeInt64(ftr, 24);
        long p = NB.decodeInt64(ftr, 32);
        this.objPosition = p >>> 5;
        this.objIdLen = (int)(p & 0x1FL);
        this.objIndexPosition = NB.decodeInt64(ftr, 40);
        this.logPosition = NB.decodeInt64(ftr, 48);
        this.logIndexPosition = NB.decodeInt64(ftr, 56);
        this.refEnd = this.refIndexPosition > 0L ? this.refIndexPosition : (this.objPosition > 0L ? this.objPosition : (this.logPosition > 0L ? this.logPosition : this.src.size() - (long)ftrLen));
        if (this.objPosition > 0L) {
            this.objEnd = this.objIndexPosition > 0L ? this.objIndexPosition : (this.logPosition > 0L ? this.logPosition : this.src.size() - (long)ftrLen);
        }
        if (this.logPosition > 0L) {
            this.logEnd = this.logIndexPosition > 0L ? this.logIndexPosition : this.src.size() - (long)ftrLen;
        }
    }

    private byte[] readHeaderOrFooter(long pos, int len2) throws IOException {
        ByteBuffer buf = this.src.read(pos, len2);
        if (buf.position() != len2) {
            throw new IOException(JGitText.get().shortReadOfBlock);
        }
        byte[] tmp = new byte[len2];
        buf.flip();
        buf.get(tmp);
        if (!ReftableConstants.isFileHeaderMagic(tmp, 0, len2)) {
            throw new IOException(JGitText.get().invalidReftableFile);
        }
        int v = NB.decodeInt32(tmp, 4);
        int version2 = v >>> 24;
        if (1 != version2) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedReftableVersion, version2));
        }
        if (this.blockSize == -1) {
            this.blockSize = v & 0xFFFFFF;
        }
        this.minUpdateIndex = NB.decodeInt64(tmp, 8);
        this.maxUpdateIndex = NB.decodeInt64(tmp, 16);
        return tmp;
    }

    private void initRefIndex() throws IOException {
        if (this.refIndexPosition < 0L) {
            this.readFileFooter();
        }
        if (this.refIndex == null && this.refIndexPosition > 0L) {
            this.refIndex = this.readIndex(this.refIndexPosition);
        }
    }

    private void initObjIndex() throws IOException {
        if (this.objIndexPosition < 0L) {
            this.readFileFooter();
        }
        if (this.objIndex == null && this.objIndexPosition > 0L) {
            this.objIndex = this.readIndex(this.objIndexPosition);
        }
    }

    private void initLogIndex() throws IOException {
        if (this.logIndexPosition < 0L) {
            this.readFileFooter();
        }
        if (this.logIndex == null && this.logIndexPosition > 0L) {
            this.logIndex = this.readIndex(this.logIndexPosition);
        }
    }

    private BlockReader readIndex(long pos) throws IOException {
        int sz = this.readBlockLen(pos);
        BlockReader i2 = new BlockReader();
        i2.readBlock(this.src, pos, sz);
        i2.verifyIndex();
        return i2;
    }

    private int readBlockLen(long pos) throws IOException {
        byte[] buf;
        int sz = pos == 0L ? 28 : 4;
        ByteBuffer tmp = this.src.read(pos, sz);
        if (tmp.position() < sz) {
            throw new IOException(JGitText.get().invalidReftableFile);
        }
        if (tmp.hasArray() && tmp.arrayOffset() == 0) {
            buf = tmp.array();
        } else {
            buf = new byte[sz];
            tmp.flip();
            tmp.get(buf);
        }
        if (pos == 0L && buf[24] == 82) {
            return 24;
        }
        int p = pos == 0L ? 24 : 0;
        return BlockReader.decodeBlockLen(NB.decodeInt32(buf, p));
    }

    private BlockReader readBlock(long pos, long end2) throws IOException {
        BlockReader b2;
        if (this.indexCache != null && (b2 = this.indexCache.get(pos)) != null) {
            return b2;
        }
        int sz = this.blockSize;
        if (sz == 0) {
            sz = this.readBlockLen(pos);
        } else if (pos + (long)sz > end2) {
            sz = (int)(end2 - pos);
        }
        BlockReader b3 = new BlockReader();
        b3.readBlock(this.src, pos, sz);
        if (b3.type() == 105) {
            if (this.indexCache == null) {
                this.indexCache = new LongMap();
            }
            this.indexCache.put(pos, b3);
        }
        return b3;
    }

    private int blocksIn(long pos, long end2) {
        int blocks = (int)((end2 - pos) / (long)this.blockSize);
        return end2 % (long)this.blockSize == 0L ? blocks : blocks + 1;
    }

    public long size() throws IOException {
        return this.src.size();
    }

    @Override
    public void close() throws IOException {
        this.src.close();
    }

    private class LogCursorImpl
    extends LogCursor {
        private final long scanEnd;
        private final byte[] match;
        private String refName;
        private long updateIndex;
        private ReflogEntry entry;
        BlockReader block;

        LogCursorImpl(long scanEnd, byte[] match2) {
            this.scanEnd = scanEnd;
            this.match = match2;
        }

        @Override
        public boolean next() throws IOException {
            while (true) {
                if (this.block == null || this.block.type() != 103) {
                    return false;
                }
                if (!this.block.next()) {
                    long pos = this.block.endPosition();
                    if (pos >= this.scanEnd) {
                        return false;
                    }
                    this.block = ReftableReader.this.readBlock(pos, this.scanEnd);
                    continue;
                }
                this.block.parseKey();
                if (this.match != null && !this.block.match(this.match, false)) {
                    this.block.skipValue();
                    return false;
                }
                this.refName = this.block.name();
                this.updateIndex = this.block.readLogUpdateIndex();
                this.entry = this.block.readLogEntry();
                if (this.entry != null || ReftableReader.this.includeDeletes) break;
            }
            return true;
        }

        @Override
        public String getRefName() {
            return this.refName;
        }

        @Override
        public long getUpdateIndex() {
            return this.updateIndex;
        }

        @Override
        public ReflogEntry getReflogEntry() {
            return this.entry;
        }

        @Override
        public void close() {
        }
    }

    private class ObjCursorImpl
    extends RefCursor {
        private final long scanEnd;
        private final ObjectId match;
        private Ref ref;
        private int listIdx;
        private LongList blockPos;
        private BlockReader block;

        ObjCursorImpl(long scanEnd, AnyObjectId id) {
            this.scanEnd = scanEnd;
            this.match = id.copy();
        }

        void initSeek() throws IOException {
            long pos;
            byte[] rawId = new byte[20];
            this.match.copyRawTo(rawId, 0);
            byte[] key2 = Arrays.copyOf(rawId, ReftableReader.this.objIdLen);
            BlockReader b2 = ReftableReader.this.objIndex;
            do {
                if (b2.seekKey(key2) <= 0) continue;
                this.blockPos = EMPTY_LONG_LIST;
                return;
            } while ((b2 = ReftableReader.this.readBlock(pos = b2.readPositionFromIndex(), ReftableReader.this.objEnd)).type() == 105);
            b2.seekKey(key2);
            while (b2.next()) {
                b2.parseKey();
                if (b2.match(key2, false)) {
                    this.blockPos = b2.readBlockPositionList();
                    if (this.blockPos != null) break;
                    this.initScan();
                    return;
                }
                b2.skipValue();
            }
            if (this.blockPos == null) {
                this.blockPos = EMPTY_LONG_LIST;
            }
            if (this.blockPos.size() > 0) {
                pos = this.blockPos.get(this.listIdx++);
                this.block = ReftableReader.this.readBlock(pos, this.scanEnd);
            }
        }

        void initScan() throws IOException {
            this.block = ReftableReader.this.readBlock(0L, this.scanEnd);
        }

        @Override
        public boolean next() throws IOException {
            while (true) {
                if (this.block == null || this.block.type() != 114) {
                    return false;
                }
                if (!this.block.next()) {
                    long pos;
                    if (this.blockPos != null) {
                        if (this.listIdx >= this.blockPos.size()) {
                            return false;
                        }
                        pos = this.blockPos.get(this.listIdx++);
                    } else {
                        pos = this.block.endPosition();
                    }
                    if (pos >= this.scanEnd) {
                        return false;
                    }
                    this.block = ReftableReader.this.readBlock(pos, this.scanEnd);
                    continue;
                }
                this.block.parseKey();
                this.ref = this.block.readRef(ReftableReader.this.minUpdateIndex);
                ObjectId id = this.ref.getObjectId();
                if (id != null && this.match.equals(id) && (ReftableReader.this.includeDeletes || !this.wasDeleted())) break;
            }
            return true;
        }

        @Override
        public void seekPastPrefix(String prefixName) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Ref getRef() {
            return this.ref;
        }

        @Override
        public void close() {
        }
    }

    private class RefCursorImpl
    extends RefCursor {
        private final long scanEnd;
        private final byte[] match;
        private final boolean prefix;
        private Ref ref;
        BlockReader block;

        RefCursorImpl(long scanEnd, byte[] match2, boolean prefix2) {
            this.scanEnd = scanEnd;
            this.match = match2;
            this.prefix = prefix2;
        }

        @Override
        public boolean next() throws IOException {
            while (true) {
                if (this.block == null || this.block.type() != 114) {
                    return false;
                }
                if (!this.block.next()) {
                    long pos = this.block.endPosition();
                    if (pos >= this.scanEnd) {
                        return false;
                    }
                    this.block = ReftableReader.this.readBlock(pos, this.scanEnd);
                    continue;
                }
                this.block.parseKey();
                if (this.match != null && !this.block.match(this.match, this.prefix)) {
                    this.block.skipValue();
                    return false;
                }
                this.ref = this.block.readRef(ReftableReader.this.minUpdateIndex);
                if (ReftableReader.this.includeDeletes || !this.wasDeleted()) break;
            }
            return true;
        }

        @Override
        public void seekPastPrefix(String prefixName) throws IOException {
            ReftableReader.this.initRefIndex();
            byte[] key2 = prefixName.getBytes(StandardCharsets.UTF_8);
            ByteBuffer byteBuffer = ByteBuffer.allocate(key2.length + 1);
            byteBuffer.put(key2);
            byteBuffer.put((byte)-1);
            this.block = ReftableReader.this.seek((byte)114, byteBuffer.array(), ReftableReader.this.refIndex, 0L, ReftableReader.this.refEnd);
        }

        @Override
        public Ref getRef() {
            return this.ref;
        }

        @Override
        public void close() {
        }
    }
}

