/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.submodule;

import java.text.MessageFormat;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectChecker;

public class SubmoduleValidator {
    public static void assertValidSubmoduleName(String name) throws SubmoduleValidationException {
        if (name.contains("/../") || name.contains("\\..\\") || name.startsWith("../") || name.startsWith("..\\") || name.endsWith("/..") || name.endsWith("\\..")) {
            throw new SubmoduleValidationException(MessageFormat.format(JGitText.get().invalidNameContainsDotDot, name), ObjectChecker.ErrorType.GITMODULES_NAME);
        }
        if (name.startsWith("-")) {
            throw new SubmoduleValidationException(MessageFormat.format(JGitText.get().submoduleNameInvalid, name), ObjectChecker.ErrorType.GITMODULES_NAME);
        }
    }

    public static void assertValidSubmoduleUri(String uri2) throws SubmoduleValidationException {
        if (uri2.startsWith("-")) {
            throw new SubmoduleValidationException(MessageFormat.format(JGitText.get().submoduleUrlInvalid, uri2), ObjectChecker.ErrorType.GITMODULES_URL);
        }
    }

    public static void assertValidSubmodulePath(String path2) throws SubmoduleValidationException {
        if (path2.startsWith("-")) {
            throw new SubmoduleValidationException(MessageFormat.format(JGitText.get().submodulePathInvalid, path2), ObjectChecker.ErrorType.GITMODULES_PATH);
        }
    }

    public static void assertValidGitModulesFile(String gitModulesContents) throws SubmoduleValidationException {
        Config c2 = new Config();
        try {
            c2.fromText(gitModulesContents);
            for (String subsection : c2.getSubsections("submodule")) {
                String path2;
                SubmoduleValidator.assertValidSubmoduleName(subsection);
                String url2 = c2.getString("submodule", subsection, "url");
                if (url2 != null) {
                    SubmoduleValidator.assertValidSubmoduleUri(url2);
                }
                if ((path2 = c2.getString("submodule", subsection, "path")) == null) continue;
                SubmoduleValidator.assertValidSubmodulePath(path2);
            }
        }
        catch (ConfigInvalidException e2) {
            SubmoduleValidationException sve = new SubmoduleValidationException(JGitText.get().invalidGitModules, ObjectChecker.ErrorType.GITMODULES_PARSE);
            sve.initCause(e2);
            throw sve;
        }
    }

    public static class SubmoduleValidationException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final ObjectChecker.ErrorType fsckMessageId;

        SubmoduleValidationException(String message, ObjectChecker.ErrorType fsckMessageId) {
            super(message);
            this.fsckMessageId = fsckMessageId;
        }

        public ObjectChecker.ErrorType getFsckMessageId() {
            return this.fsckMessageId;
        }
    }
}

