/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public abstract class DelegatingSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory delegate;

    public DelegatingSSLSocketFactory(SSLSocketFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public SSLSocket createSocket() throws IOException {
        return this.prepare(this.delegate.createSocket());
    }

    @Override
    public SSLSocket createSocket(String host2, int port2) throws IOException {
        return this.prepare(this.delegate.createSocket(host2, port2));
    }

    @Override
    public SSLSocket createSocket(String host2, int port2, InetAddress localAddress2, int localPort2) throws IOException {
        return this.prepare(this.delegate.createSocket(host2, port2, localAddress2, localPort2));
    }

    @Override
    public SSLSocket createSocket(InetAddress host2, int port2) throws IOException {
        return this.prepare(this.delegate.createSocket(host2, port2));
    }

    @Override
    public SSLSocket createSocket(InetAddress host2, int port2, InetAddress localAddress2, int localPort2) throws IOException {
        return this.prepare(this.delegate.createSocket(host2, port2, localAddress2, localPort2));
    }

    @Override
    public SSLSocket createSocket(Socket socket, String host2, int port2, boolean autoClose) throws IOException {
        return this.prepare(this.delegate.createSocket(socket, host2, port2, autoClose));
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    private SSLSocket prepare(Socket socket) throws IOException {
        SSLSocket sslSocket = (SSLSocket)socket;
        this.configure(sslSocket);
        return sslSocket;
    }

    protected abstract void configure(SSLSocket var1) throws IOException;
}

