/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.ssh;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.transport.SshConfigStore;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public class OpenSshConfigFile
implements SshConfigStore {
    private final File home;
    private final File configFile;
    private final String localUserName;
    private Instant lastModified;
    private State state;

    public OpenSshConfigFile(@NonNull File home, @NonNull File config2, @NonNull String localUserName) {
        this.home = home;
        this.configFile = config2;
        this.localUserName = localUserName;
        this.state = new State();
    }

    @Override
    @NonNull
    public HostEntry lookup(@NonNull String hostName, int port2, String userName) {
        return this.lookup(hostName, port2, userName, false);
    }

    @Override
    @NonNull
    public HostEntry lookupDefault(@NonNull String hostName, int port2, String userName) {
        return this.lookup(hostName, port2, userName, true);
    }

    private HostEntry lookup(@NonNull String hostName, int port2, String userName, boolean fillDefaults) {
        State cache2 = this.refresh();
        String cacheKey = this.toCacheKey(hostName, port2, userName);
        HostEntry h2 = cache2.hosts.get(cacheKey);
        if (h2 != null) {
            return h2;
        }
        HostEntry fullConfig = new HostEntry();
        Iterator<HostEntry> entries2 = cache2.entries.iterator();
        if (entries2.hasNext()) {
            fullConfig.merge(entries2.next());
            entries2.forEachRemaining(entry -> {
                if (entry.matches(hostName)) {
                    fullConfig.merge((HostEntry)entry);
                }
            });
        }
        fullConfig.substitute(hostName, port2, userName, this.localUserName, this.home, fillDefaults);
        cache2.hosts.put(cacheKey, fullConfig);
        return fullConfig;
    }

    @NonNull
    private String toCacheKey(@NonNull String hostName, int port2, String userName) {
        Object key2 = hostName;
        if (port2 > 0) {
            key2 = (String)key2 + ":" + Integer.toString(port2);
        }
        if (userName != null && !userName.isEmpty()) {
            key2 = userName + "@" + (String)key2;
        }
        return key2;
    }

    private synchronized State refresh() {
        Instant mtime = FS.DETECTED.lastModifiedInstant(this.configFile);
        if (!mtime.equals(this.lastModified)) {
            State newState = new State();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader br = Files.newBufferedReader(this.configFile.toPath(), StandardCharsets.UTF_8);){
                    newState.entries = this.parse(br);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
            this.lastModified = mtime;
            this.state = newState;
        }
        return this.state;
    }

    private List<HostEntry> parse(BufferedReader reader2) throws IOException {
        String line;
        HostEntry defaults;
        ArrayList<HostEntry> entries2 = new ArrayList<HostEntry>();
        HostEntry current = defaults = new HostEntry();
        entries2.add(defaults);
        block4: while ((line = reader2.readLine()) != null) {
            String argValue;
            String[] parts;
            String keyword;
            if ((line = line.strip()).isEmpty() || (keyword = (parts = line.split("[ \t]*[= \t]", 2))[0].strip()).isEmpty()) continue;
            switch (keyword.charAt(0)) {
                case '#': {
                    continue block4;
                }
                case '\"': {
                    List<String> dequoted = OpenSshConfigFile.parseList(keyword);
                    keyword = dequoted.isEmpty() ? "" : dequoted.get(0);
                    break;
                }
                default: {
                    int i2 = keyword.indexOf(35);
                    if (i2 < 0) break;
                    keyword = keyword.substring(0, i2);
                }
            }
            if (keyword.isEmpty()) continue;
            String string = argValue = parts.length > 1 ? parts[1].strip() : "";
            if (StringUtils.equalsIgnoreCase("Host", keyword)) {
                current = new HostEntry(OpenSshConfigFile.parseList(argValue));
                entries2.add(current);
                continue;
            }
            if (HostEntry.isListKey(keyword)) {
                List<String> args2 = this.validate(keyword, OpenSshConfigFile.parseList(argValue));
                current.setValue(keyword, args2);
                continue;
            }
            if (argValue.isEmpty()) continue;
            List<String> args3 = OpenSshConfigFile.parseList(argValue);
            String arg = args3.isEmpty() ? "" : args3.get(0);
            argValue = this.validate(keyword, arg);
            current.setValue(keyword, argValue);
        }
        return entries2;
    }

    private static List<String> parseList(String argument) {
        ArrayList<String> result2 = new ArrayList<String>(4);
        int start2 = 0;
        int length = argument.length();
        while (start2 < length) {
            char ch = argument.charAt(start2);
            if (Character.isWhitespace(ch)) {
                ++start2;
                continue;
            }
            if (ch == '#') break;
            start2 = OpenSshConfigFile.parseToken(argument, start2, length, result2);
        }
        return result2;
    }

    private static int parseToken(String argument, int from2, int to, List<String> result2) {
        StringBuilder b2 = new StringBuilder();
        int i2 = from2;
        char quote = '\u0000';
        boolean escaped = false;
        block5: while (i2 < to) {
            char ch = argument.charAt(i2);
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (quote == '\u0000') {
                        if (escaped) {
                            b2.append(ch);
                        } else {
                            quote = ch;
                        }
                    } else if (!escaped && quote == ch) {
                        quote = '\u0000';
                    } else {
                        b2.append(ch);
                    }
                    escaped = false;
                    break;
                }
                case '\\': {
                    if (escaped) {
                        b2.append(ch);
                    }
                    escaped = !escaped;
                    break;
                }
                case ' ': {
                    if (quote == '\u0000') {
                        if (!escaped) break block5;
                        b2.append(ch);
                        escaped = false;
                        break;
                    }
                    if (escaped) {
                        b2.append('\\');
                    }
                    b2.append(ch);
                    escaped = false;
                    break;
                }
                default: {
                    if (escaped) {
                        b2.append('\\');
                    }
                    if (quote == '\u0000' && Character.isWhitespace(ch)) break block5;
                    b2.append(ch);
                    escaped = false;
                }
            }
            ++i2;
        }
        if (b2.length() > 0) {
            result2.add(b2.toString());
        }
        return i2;
    }

    protected String validate(String key2, String value2) {
        if ("PreferredAuthentications".equalsIgnoreCase(key2)) {
            return OpenSshConfigFile.stripWhitespace(value2);
        }
        return value2;
    }

    protected List<String> validate(String key2, List<String> value2) {
        return value2;
    }

    public static boolean patternMatch(Iterable<String> patterns2, String name) {
        boolean doesMatch = false;
        for (String pattern2 : patterns2) {
            if (pattern2.startsWith("!")) {
                if (!OpenSshConfigFile.patternMatches(pattern2.substring(1), name)) continue;
                return false;
            }
            if (doesMatch || !OpenSshConfigFile.patternMatches(pattern2, name)) continue;
            doesMatch = true;
        }
        return doesMatch;
    }

    private static boolean patternMatches(String pattern2, String name) {
        if (pattern2.indexOf(42) >= 0 || pattern2.indexOf(63) >= 0) {
            FileNameMatcher fn;
            try {
                fn = new FileNameMatcher(pattern2, null);
            }
            catch (InvalidPatternException e2) {
                return false;
            }
            fn.append(name);
            return fn.isMatch();
        }
        return pattern2.equals(name);
    }

    private static String stripWhitespace(String value2) {
        StringBuilder b2 = new StringBuilder();
        int length = value2.length();
        int i2 = 0;
        while (i2 < length) {
            char ch = value2.charAt(i2);
            if (!Character.isWhitespace(ch)) {
                b2.append(ch);
            }
            ++i2;
        }
        return b2.toString();
    }

    private static File toFile(String path2, File home) {
        if (path2.startsWith("~/") || path2.startsWith("~" + File.separator)) {
            return new File(home, path2.substring(2));
        }
        File ret = new File(path2);
        if (ret.isAbsolute()) {
            return ret;
        }
        return new File(home, path2);
    }

    public static int positive(String value2) {
        if (value2 != null) {
            try {
                return Integer.parseUnsignedInt(value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static boolean flag(String value2) {
        if (value2 == null) {
            return false;
        }
        return "yes".equals(value2) || "on".equals(value2) || "true".equals(value2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int timeSpec(String value2) {
        if (value2 == null) {
            return -1;
        }
        try {
            int length = value2.length();
            int i2 = 0;
            int seconds = 0;
            boolean valueSeen = false;
            while (i2 < length) {
                char ch = value2.charAt(i2);
                if (Character.isWhitespace(ch)) {
                    ++i2;
                    continue;
                }
                if (ch == '+') {
                    // empty if block
                }
                int val = 0;
                int j2 = ++i2;
                while (j2 < length) {
                    if ((ch = value2.charAt(j2++)) >= '0' && ch <= '9') {
                        val = Math.addExact(Math.multiplyExact(val, 10), ch - 48);
                        continue;
                    }
                    --j2;
                    break;
                }
                if (i2 == j2) {
                    return -1;
                }
                i2 = j2;
                int multiplier = 1;
                if (i2 < length) {
                    ch = value2.charAt(i2++);
                    switch (ch) {
                        case 'S': 
                        case 's': {
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            multiplier = 60;
                            break;
                        }
                        case 'H': 
                        case 'h': {
                            multiplier = 3600;
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            multiplier = 86400;
                            break;
                        }
                        case 'W': 
                        case 'w': {
                            multiplier = 604800;
                            break;
                        }
                        default: {
                            if (!Character.isWhitespace(ch)) return -1;
                            break;
                        }
                    }
                }
                seconds = Math.addExact(seconds, Math.multiplyExact(val, multiplier));
                valueSeen = true;
            }
            if (!valueSeen) return -1;
            int n = seconds;
            return n;
        }
        catch (ArithmeticException e2) {
            return -1;
        }
    }

    public String getLocalUserName() {
        return this.localUserName;
    }

    public String toString() {
        return "OpenSshConfig [home=" + String.valueOf(this.home) + ", configFile=" + String.valueOf(this.configFile) + ", lastModified=" + String.valueOf(this.lastModified) + ", state=" + String.valueOf(this.state) + "]";
    }

    public static class HostEntry
    implements SshConfigStore.HostConfig {
        private static final Set<String> MULTI_KEYS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        private static final Set<String> LIST_KEYS;
        private static final Map<String, String> ALIASES;
        private Map<String, String> options;
        private Map<String, List<String>> multiOptions;
        private Map<String, List<String>> listOptions;
        private final List<String> patterns;

        static {
            MULTI_KEYS.add("CertificateFile");
            MULTI_KEYS.add("IdentityFile");
            MULTI_KEYS.add("LocalForward");
            MULTI_KEYS.add("RemoteForward");
            MULTI_KEYS.add("SendEnv");
            LIST_KEYS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            LIST_KEYS.add("CanonicalDomains");
            LIST_KEYS.add("GlobalKnownHostsFile");
            LIST_KEYS.add("SendEnv");
            LIST_KEYS.add("UserKnownHostsFile");
            LIST_KEYS.add("AddKeysToAgent");
            ALIASES = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            ALIASES.put("PubkeyAcceptedKeyTypes", "PubkeyAcceptedAlgorithms");
        }

        public HostEntry() {
            this.patterns = Collections.emptyList();
        }

        public HostEntry(List<String> patterns2) {
            this.patterns = patterns2;
        }

        boolean matches(String hostName) {
            return OpenSshConfigFile.patternMatch(this.patterns, hostName);
        }

        private static String toKey(String key2) {
            String k2 = ALIASES.get(key2);
            return k2 != null ? k2 : key2;
        }

        @Override
        public String getValue(String key2) {
            String result2;
            String k2 = HostEntry.toKey(key2);
            String string = result2 = this.options != null ? this.options.get(k2) : null;
            if (result2 == null) {
                List<String> values2;
                List<String> list = values2 = this.listOptions != null ? this.listOptions.get(k2) : null;
                if (values2 == null) {
                    List<String> list2 = values2 = this.multiOptions != null ? this.multiOptions.get(k2) : null;
                }
                if (values2 != null && !values2.isEmpty()) {
                    result2 = values2.get(0);
                }
            }
            return result2;
        }

        @Override
        public List<String> getValues(String key2) {
            List<String> values2;
            String k2 = HostEntry.toKey(key2);
            List<String> list = values2 = this.listOptions != null ? this.listOptions.get(k2) : null;
            if (values2 == null) {
                List<String> list2 = values2 = this.multiOptions != null ? this.multiOptions.get(k2) : null;
            }
            if (values2 == null || values2.isEmpty()) {
                return new ArrayList<String>();
            }
            return new ArrayList<String>(values2);
        }

        public void setValue(String key2, String value2) {
            String k2 = HostEntry.toKey(key2);
            if (value2 == null) {
                if (this.multiOptions != null) {
                    this.multiOptions.remove(k2);
                }
                if (this.listOptions != null) {
                    this.listOptions.remove(k2);
                }
                if (this.options != null) {
                    this.options.remove(k2);
                }
                return;
            }
            if (MULTI_KEYS.contains(k2)) {
                List<String> values2;
                if (this.multiOptions == null) {
                    this.multiOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                if ((values2 = this.multiOptions.get(k2)) == null) {
                    values2 = new ArrayList<String>(4);
                    this.multiOptions.put(k2, values2);
                }
                values2.add(value2);
            } else {
                if (this.options == null) {
                    this.options = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                }
                if (!this.options.containsKey(k2)) {
                    this.options.put(k2, value2);
                }
            }
        }

        public void setValue(String key2, List<String> values2) {
            if (values2.isEmpty()) {
                return;
            }
            String k2 = HostEntry.toKey(key2);
            if (MULTI_KEYS.contains(k2)) {
                List<String> items2;
                if (this.multiOptions == null) {
                    this.multiOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                if ((items2 = this.multiOptions.get(k2)) == null) {
                    items2 = new ArrayList<String>(values2);
                    this.multiOptions.put(k2, items2);
                } else {
                    items2.addAll(values2);
                }
            } else {
                if (this.listOptions == null) {
                    this.listOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                if (!this.listOptions.containsKey(k2)) {
                    this.listOptions.put(k2, values2);
                }
            }
        }

        public static boolean isListKey(String key2) {
            return LIST_KEYS.contains(HostEntry.toKey(key2));
        }

        void merge(HostEntry entry) {
            if (entry == null) {
                return;
            }
            if (entry.options != null) {
                if (this.options == null) {
                    this.options = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                }
                for (Map.Entry<String, Object> entry2 : entry.options.entrySet()) {
                    if (this.options.containsKey(entry2.getKey())) continue;
                    this.options.put(entry2.getKey(), (String)entry2.getValue());
                }
            }
            if (entry.listOptions != null) {
                if (this.listOptions == null) {
                    this.listOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                for (Map.Entry<String, Object> entry3 : entry.listOptions.entrySet()) {
                    if (this.listOptions.containsKey(entry3.getKey())) continue;
                    this.listOptions.put(entry3.getKey(), (List)entry3.getValue());
                }
            }
            if (entry.multiOptions != null) {
                if (this.multiOptions == null) {
                    this.multiOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                for (Map.Entry<String, Object> entry4 : entry.multiOptions.entrySet()) {
                    List<String> values2 = this.multiOptions.get(entry4.getKey());
                    if (values2 == null) {
                        values2 = new ArrayList<String>((Collection)entry4.getValue());
                        this.multiOptions.put(entry4.getKey(), values2);
                        continue;
                    }
                    values2.addAll((Collection)entry4.getValue());
                }
            }
        }

        private List<String> substitute(List<String> values2, String allowed, Replacer r, boolean withEnv) {
            ArrayList<String> result2 = new ArrayList<String>(values2.size());
            for (String value2 : values2) {
                result2.add(r.substitute(value2, allowed, withEnv));
            }
            return result2;
        }

        private List<String> replaceTilde(List<String> values2, File home) {
            ArrayList<String> result2 = new ArrayList<String>(values2.size());
            for (String value2 : values2) {
                result2.add(OpenSshConfigFile.toFile(value2, home).getPath());
            }
            return result2;
        }

        void substitute(String originalHostName, int port2, String userName, String localUserName, File home, boolean fillDefaults) {
            List<String> values2;
            String u;
            int p;
            int n = p = port2 > 0 ? port2 : OpenSshConfigFile.positive(this.getValue("Port"));
            if (p <= 0) {
                p = 22;
            }
            String string = u = !StringUtils.isEmptyOrNull(userName) ? userName : this.getValue("User");
            if (u == null || u.isEmpty()) {
                u = localUserName;
            }
            Replacer r = new Replacer(originalHostName, p, u, localUserName, home);
            if (this.options != null) {
                String hostName = this.options.get("HostName");
                if (hostName == null || hostName.isEmpty()) {
                    this.options.put("HostName", originalHostName);
                } else {
                    hostName = r.substitute(hostName, "h", false);
                    this.options.put("HostName", hostName);
                    r.update('h', hostName);
                }
            } else if (fillDefaults) {
                this.setValue("HostName", originalHostName);
            }
            if (this.multiOptions != null) {
                values2 = this.multiOptions.get("IdentityFile");
                if (values2 != null) {
                    values2 = this.substitute(values2, "CdhLlnpru", r, true);
                    values2 = this.replaceTilde(values2, home);
                    this.multiOptions.put("IdentityFile", values2);
                }
                if ((values2 = this.multiOptions.get("CertificateFile")) != null) {
                    values2 = this.substitute(values2, "CdhLlnpru", r, true);
                    values2 = this.replaceTilde(values2, home);
                    this.multiOptions.put("CertificateFile", values2);
                }
            }
            if (this.listOptions != null && (values2 = this.listOptions.get("UserKnownHostsFile")) != null) {
                values2 = this.substitute(values2, "CdhLlnpru", r, true);
                values2 = this.replaceTilde(values2, home);
                this.listOptions.put("UserKnownHostsFile", values2);
            }
            if (this.options != null) {
                String value2 = this.options.get("IdentityAgent");
                if (value2 != null && !"none".equals(value2) && !"SSH_AUTH_SOCK".equals(value2)) {
                    value2 = r.substitute(value2, "CdhLlnpru", true);
                    value2 = OpenSshConfigFile.toFile(value2, home).getPath();
                    this.options.put("IdentityAgent", value2);
                }
                if ((value2 = this.options.get("ControlPath")) != null) {
                    value2 = r.substitute(value2, "CdhLlnpru", true);
                    value2 = OpenSshConfigFile.toFile(value2, home).getPath();
                    this.options.put("ControlPath", value2);
                }
                if ((value2 = this.options.get("LocalCommand")) != null) {
                    value2 = r.substitute(value2, "CdhLlnprTu", false);
                    this.options.put("LocalCommand", value2);
                }
                if ((value2 = this.options.get("RemoteCommand")) != null) {
                    value2 = r.substitute(value2, "CdhLlnpru", false);
                    this.options.put("RemoteCommand", value2);
                }
                if ((value2 = this.options.get("ProxyCommand")) != null) {
                    value2 = r.substitute(value2, "hnpr", false);
                    this.options.put("ProxyCommand", value2);
                }
            }
            if (fillDefaults) {
                String s2 = this.options.get("User");
                if (StringUtils.isEmptyOrNull(s2)) {
                    this.options.put("User", u);
                }
                if (OpenSshConfigFile.positive(this.options.get("Port")) <= 0) {
                    this.options.put("Port", Integer.toString(p));
                }
                if (OpenSshConfigFile.positive(this.options.get("ConnectionAttempts")) <= 0) {
                    this.options.put("ConnectionAttempts", "1");
                }
            }
        }

        @Override
        @NonNull
        public Map<String, String> getOptions() {
            if (this.options == null) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(this.options);
        }

        @Override
        @NonNull
        public Map<String, List<String>> getMultiValuedOptions() {
            if (this.listOptions == null && this.multiOptions == null) {
                return Collections.emptyMap();
            }
            TreeMap<String, List<String>> allValues = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            if (this.multiOptions != null) {
                allValues.putAll(this.multiOptions);
            }
            if (this.listOptions != null) {
                allValues.putAll(this.listOptions);
            }
            return Collections.unmodifiableMap(allValues);
        }

        public String toString() {
            return "HostEntry [options=" + String.valueOf(this.options) + ", multiOptions=" + String.valueOf(this.multiOptions) + ", listOptions=" + String.valueOf(this.listOptions) + "]";
        }
    }

    private static class Replacer {
        public static final String DEFAULT_TOKENS = "CdhLlnpru";
        private final Map<Character, String> replacements = new HashMap<Character, String>();

        public Replacer(String host2, int port2, String user, String localUserName, File home) {
            this.replacements.put(Character.valueOf('%'), "%");
            this.replacements.put(Character.valueOf('d'), home.getPath());
            this.replacements.put(Character.valueOf('h'), host2);
            String localhost = SystemReader.getInstance().getHostname();
            this.replacements.put(Character.valueOf('l'), localhost);
            int period = localhost.indexOf(46);
            if (period > 0) {
                localhost = localhost.substring(0, period);
            }
            this.replacements.put(Character.valueOf('L'), localhost);
            this.replacements.put(Character.valueOf('n'), host2);
            this.replacements.put(Character.valueOf('p'), Integer.toString(port2));
            this.replacements.put(Character.valueOf('r'), user == null ? "" : user);
            this.replacements.put(Character.valueOf('u'), localUserName);
            this.replacements.put(Character.valueOf('C'), this.substitute("%l%h%p%r", "hlpr", false));
            this.replacements.put(Character.valueOf('T'), "NONE");
        }

        public void update(char key2, String value2) {
            this.replacements.put(Character.valueOf(key2), value2);
            if ("lhpr".indexOf(key2) >= 0) {
                this.replacements.put(Character.valueOf('C'), this.substitute("%l%h%p%r", "hlpr", false));
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public String substitute(String input, String allowed, boolean withEnv) {
            if (input == null || input.length() <= 1 || input.indexOf(37) < 0 && (!withEnv || input.indexOf("${") < 0)) {
                return input;
            }
            StringBuilder builder = new StringBuilder();
            int start2 = 0;
            int length = input.length();
            block4: while (start2 < length) {
                char ch = input.charAt(start2);
                switch (ch) {
                    case '%': {
                        if (start2 + 1 >= length) break;
                        String replacement = null;
                        ch = input.charAt(start2 + 1);
                        if (ch == '%' || allowed.indexOf(ch) >= 0) {
                            replacement = this.replacements.get(Character.valueOf(ch));
                        }
                        if (replacement == null) {
                            builder.append('%').append(ch);
                        } else {
                            builder.append(replacement);
                        }
                        start2 += 2;
                        continue block4;
                    }
                    case '$': {
                        int close2;
                        if (!withEnv || start2 + 2 >= length) break;
                        ch = input.charAt(start2 + 1);
                        if (ch == '{' && (close2 = input.indexOf(125, start2 + 2)) > start2 + 2) {
                            String variable = SystemReader.getInstance().getenv(input.substring(start2 + 2, close2));
                            if (!StringUtils.isEmptyOrNull(variable)) {
                                builder.append(variable);
                            }
                            start2 = close2 + 1;
                            continue block4;
                        }
                        ch = '$';
                    }
                }
                builder.append(ch);
                ++start2;
            }
            return builder.toString();
        }
    }

    private static class State {
        List<HostEntry> entries = new ArrayList<HostEntry>();
        Map<String, HostEntry> hosts = new HashMap<String, HostEntry>();

        private State() {
        }

        public String toString() {
            return "State [entries=" + String.valueOf(this.entries) + ", hosts=" + String.valueOf(this.hosts) + "]";
        }
    }
}

