/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.security.KeyPair;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.client.auth.password.PasswordAuthenticationReporter;
import org.apache.sshd.client.auth.pubkey.PublicKeyAuthenticationReporter;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.eclipse.jgit.internal.transport.sshd.CachingKeyPairProvider;
import org.eclipse.jgit.internal.transport.sshd.GssApiWithMicAuthenticationReporter;
import org.eclipse.jgit.internal.transport.sshd.SshdText;

public class AuthenticationLogger {
    private final List<String> messages = new ArrayList<String>();
    private final PublicKeyAuthenticationReporter pubkeyLogger = new PublicKeyAuthenticationReporter(){
        private boolean hasAttempts;

        @Override
        public void signalAuthenticationAttempt(ClientSession session2, String service, KeyPair identity, String signature) throws Exception {
            this.hasAttempts = true;
            String message = identity.getPrivate() == null ? MessageFormat.format(SshdText.get().authPubkeyAttemptAgent, "publickey", KeyUtils.getKeyType(identity), CachingKeyPairProvider.getKeyId(session2, identity), signature) : MessageFormat.format(SshdText.get().authPubkeyAttempt, "publickey", KeyUtils.getKeyType(identity), CachingKeyPairProvider.getKeyId(session2, identity), signature);
            AuthenticationLogger.this.messages.add(message);
        }

        @Override
        public void signalAuthenticationExhausted(ClientSession session2, String service) throws Exception {
            String message = this.hasAttempts ? MessageFormat.format(SshdText.get().authPubkeyExhausted, "publickey") : MessageFormat.format(SshdText.get().authPubkeyNoKeys, "publickey");
            AuthenticationLogger.this.messages.add(message);
            this.hasAttempts = false;
        }

        @Override
        public void signalAuthenticationFailure(ClientSession session2, String service, KeyPair identity, boolean partial, List<String> serverMethods) throws Exception {
            String message = partial ? MessageFormat.format(SshdText.get().authPubkeyPartialSuccess, "publickey", KeyUtils.getKeyType(identity), CachingKeyPairProvider.getKeyId(session2, identity), serverMethods) : MessageFormat.format(SshdText.get().authPubkeyFailure, "publickey", KeyUtils.getKeyType(identity), CachingKeyPairProvider.getKeyId(session2, identity));
            AuthenticationLogger.this.messages.add(message);
        }
    };
    private final PasswordAuthenticationReporter passwordLogger = new PasswordAuthenticationReporter(){
        private int attempts;

        @Override
        public void signalAuthenticationAttempt(ClientSession session2, String service, String oldPassword, boolean modified, String newPassword) throws Exception {
            ++this.attempts;
            String message = modified ? MessageFormat.format(SshdText.get().authPasswordChangeAttempt, "password", this.attempts) : MessageFormat.format(SshdText.get().authPasswordAttempt, "password", this.attempts);
            AuthenticationLogger.this.messages.add(message);
        }

        @Override
        public void signalAuthenticationExhausted(ClientSession session2, String service) throws Exception {
            String message = this.attempts > 0 ? MessageFormat.format(SshdText.get().authPasswordExhausted, "password") : MessageFormat.format(SshdText.get().authPasswordNotTried, "password");
            AuthenticationLogger.this.messages.add(message);
            this.attempts = 0;
        }

        @Override
        public void signalAuthenticationFailure(ClientSession session2, String service, String password, boolean partial, List<String> serverMethods) throws Exception {
            String message = partial ? MessageFormat.format(SshdText.get().authPasswordPartialSuccess, "password", serverMethods) : MessageFormat.format(SshdText.get().authPasswordFailure, "password");
            AuthenticationLogger.this.messages.add(message);
        }
    };
    private final GssApiWithMicAuthenticationReporter gssLogger = new GssApiWithMicAuthenticationReporter(){
        private boolean hasAttempts;

        @Override
        public void signalAuthenticationAttempt(ClientSession session2, String service, String mechanism) {
            this.hasAttempts = true;
            String message = MessageFormat.format(SshdText.get().authGssApiAttempt, "gssapi-with-mic", mechanism);
            AuthenticationLogger.this.messages.add(message);
        }

        @Override
        public void signalAuthenticationExhausted(ClientSession session2, String service) {
            String message = this.hasAttempts ? MessageFormat.format(SshdText.get().authGssApiExhausted, "gssapi-with-mic") : MessageFormat.format(SshdText.get().authGssApiNotTried, "gssapi-with-mic");
            AuthenticationLogger.this.messages.add(message);
            this.hasAttempts = false;
        }

        @Override
        public void signalAuthenticationFailure(ClientSession session2, String service, String mechanism, boolean partial, List<String> serverMethods) {
            String message = partial ? MessageFormat.format(SshdText.get().authGssApiPartialSuccess, "gssapi-with-mic", mechanism, serverMethods) : MessageFormat.format(SshdText.get().authGssApiFailure, "gssapi-with-mic", mechanism);
            AuthenticationLogger.this.messages.add(message);
        }
    };

    public AuthenticationLogger(ClientSession session2) {
        session2.setPublicKeyAuthenticationReporter(this.pubkeyLogger);
        session2.setPasswordAuthenticationReporter(this.passwordLogger);
        session2.setAttribute(GssApiWithMicAuthenticationReporter.GSS_AUTHENTICATION_REPORTER, this.gssLogger);
    }

    public List<String> getLog() {
        return Collections.unmodifiableList(this.messages);
    }

    public void clear() {
        this.messages.clear();
    }
}

