/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import javax.security.auth.DestroyFailedException;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.eclipse.jgit.internal.transport.sshd.JGitSshClient;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.sshd.KeyCache;

public class CachingKeyPairProvider
extends FileKeyPairProvider
implements Iterable<KeyPair> {
    public static final AttributeRepository.AttributeKey<Map<String, Path>> KEY_PATHS_BY_FINGERPRINT = new AttributeRepository.AttributeKey();
    private final KeyCache cache;

    public CachingKeyPairProvider(List<Path> paths, KeyCache cache2) {
        super(paths);
        this.cache = cache2;
    }

    @Override
    public Iterator<KeyPair> iterator() {
        return this.iterator(null);
    }

    private Iterator<KeyPair> iterator(SessionContext session2) {
        Collection<? extends Path> resources2 = this.getPaths();
        if (resources2.isEmpty()) {
            return Collections.emptyListIterator();
        }
        return new CancellingKeyPairIterator(session2, resources2);
    }

    @Override
    public Iterable<KeyPair> loadKeys(SessionContext session2) {
        return () -> this.iterator(session2);
    }

    static String getKeyId(ClientSession session2, KeyPair identity) {
        Path path2;
        String fingerprint = KeyUtils.getFingerPrint(identity.getPublic());
        Map<String, Path> registered = session2.getAttribute(KEY_PATHS_BY_FINGERPRINT);
        if (registered != null && (path2 = registered.get(fingerprint)) != null) {
            Path home = session2.resolveAttribute(JGitSshClient.HOME_DIRECTORY);
            if (home != null && path2.startsWith(home)) {
                try {
                    path2 = home.relativize(path2);
                    String pathString = path2.toString();
                    if (!pathString.isEmpty()) {
                        return "~" + File.separator + pathString;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return path2.toString();
        }
        return fingerprint;
    }

    private KeyPair loadKey(SessionContext session2, Path path2) throws IOException, GeneralSecurityException {
        if (!Files.exists(path2, new LinkOption[0])) {
            this.log.warn(MessageFormat.format(SshdText.get().identityFileNotFound, path2));
            return null;
        }
        IoResource<Path> resource2 = this.getIoResource(session2, path2);
        if (this.cache == null) {
            return this.loadKey(session2, resource2, path2, this.getPasswordFinder());
        }
        Throwable[] t2 = new Throwable[1];
        KeyPair key2 = this.cache.get(path2, p -> {
            try {
                return this.loadKey(session2, resource2, (Path)p, this.getPasswordFinder());
            }
            catch (IOException | GeneralSecurityException e2) {
                throwableArray[0] = e2;
                return null;
            }
        });
        if (t2[0] != null) {
            if (t2[0] instanceof CancellationException) {
                throw (CancellationException)t2[0];
            }
            throw new IOException(MessageFormat.format(SshdText.get().keyLoadFailed, resource2), t2[0]);
        }
        return key2;
    }

    private KeyPair loadKey(SessionContext session2, NamedResource resource2, Path path2, FilePasswordProvider passwordProvider) throws IOException, GeneralSecurityException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream stream = Files.newInputStream(path2, new OpenOption[0]);){
            Iterable<KeyPair> ids = SecurityUtils.loadKeyPairIdentities(session2, resource2, stream, passwordProvider);
            if (ids == null) {
                throw new InvalidKeyException(MessageFormat.format(SshdText.get().identityFileNoKey, path2));
            }
            Iterator<KeyPair> keys2 = ids.iterator();
            if (!keys2.hasNext()) {
                throw new InvalidKeyException(MessageFormat.format(SshdText.get().identityFileUnsupportedFormat, path2));
            }
            KeyPair result2 = keys2.next();
            PublicKey pk = result2.getPublic();
            if (pk != null) {
                Map<String, Path> registered = session2.getAttribute(KEY_PATHS_BY_FINGERPRINT);
                if (registered == null) {
                    registered = new HashMap<String, Path>();
                    session2.setAttribute(KEY_PATHS_BY_FINGERPRINT, registered);
                }
                registered.put(KeyUtils.getFingerPrint(pk), path2);
            }
            if (keys2.hasNext()) {
                this.log.warn(MessageFormat.format(SshdText.get().identityFileMultipleKeys, path2));
                keys2.forEachRemaining(k2 -> {
                    PrivateKey priv = k2.getPrivate();
                    if (priv != null) {
                        try {
                            priv.destroy();
                        }
                        catch (DestroyFailedException destroyFailedException) {
                            // empty catch block
                        }
                    }
                });
            }
            return result2;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private class CancellingKeyPairIterator
    implements Iterator<KeyPair> {
        private final SessionContext context;
        private final Iterator<Path> paths;
        private KeyPair nextItem;
        private boolean nextSet;

        public CancellingKeyPairIterator(SessionContext session2, Collection<? extends Path> resources2) {
            ArrayList<? extends Path> copy2 = new ArrayList<Path>(resources2.size());
            copy2.addAll(resources2);
            this.paths = copy2.iterator();
            this.context = session2;
        }

        @Override
        public boolean hasNext() {
            if (this.nextSet) {
                return this.nextItem != null;
            }
            this.nextSet = true;
            while (this.nextItem == null && this.paths.hasNext()) {
                try {
                    this.nextItem = CachingKeyPairProvider.this.loadKey(this.context, this.paths.next());
                }
                catch (CancellationException cancelled) {
                    throw cancelled;
                }
                catch (Exception other) {
                    CachingKeyPairProvider.this.log.warn(other.getMessage(), other);
                }
            }
            return this.nextItem != null;
        }

        @Override
        public KeyPair next() {
            if (!this.nextSet && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            KeyPair result2 = this.nextItem;
            this.nextItem = null;
            this.nextSet = false;
            if (result2 == null) {
                throw new NoSuchElementException();
            }
            return result2;
        }
    }
}

