/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.eclipse.jgit.internal.transport.sshd.GssApiMechanisms;
import org.eclipse.jgit.internal.transport.sshd.GssApiWithMicAuthenticationReporter;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GssApiWithMicAuthentication
extends AbstractUserAuth {
    private static final byte SSH_MSG_USERAUTH_GSSAPI_RESPONSE = 60;
    private static final byte SSH_MSG_USERAUTH_GSSAPI_TOKEN = 61;
    private Collection<Oid> mechanisms;
    private Iterator<Oid> nextMechanism;
    private Oid currentMechanism;
    private ProtocolState state;
    private GSSContext context;

    public GssApiWithMicAuthentication() {
        super("gssapi-with-mic");
    }

    @Override
    protected boolean sendAuthDataRequest(ClientSession session2, String service) throws Exception {
        if (this.mechanisms == null) {
            this.mechanisms = GssApiMechanisms.getSupportedMechanisms();
            this.nextMechanism = this.mechanisms.iterator();
        }
        if (this.context != null) {
            this.close(false);
        }
        GssApiWithMicAuthenticationReporter reporter = session2.getAttribute(GssApiWithMicAuthenticationReporter.GSS_AUTHENTICATION_REPORTER);
        if (!this.nextMechanism.hasNext()) {
            reporter.signalAuthenticationExhausted(session2, service);
            return false;
        }
        this.state = ProtocolState.STARTED;
        this.currentMechanism = this.nextMechanism.next();
        while (GssApiMechanisms.SPNEGO.equals(this.currentMechanism)) {
            if (!this.nextMechanism.hasNext()) {
                reporter.signalAuthenticationExhausted(session2, service);
                return false;
            }
            this.currentMechanism = this.nextMechanism.next();
        }
        try {
            String hostName = this.getHostName(session2);
            this.context = GssApiMechanisms.createContext(this.currentMechanism, hostName);
            this.context.requestMutualAuth(true);
            this.context.requestConf(true);
            this.context.requestInteg(true);
            this.context.requestCredDeleg(true);
            this.context.requestAnonymity(false);
        }
        catch (NullPointerException | GSSException e2) {
            this.close(true);
            if (this.log.isDebugEnabled()) {
                this.log.debug(MessageFormat.format(SshdText.get().gssapiInitFailure, this.currentMechanism.toString()));
            }
            this.currentMechanism = null;
            this.state = ProtocolState.FAILED;
            return false;
        }
        if (reporter != null) {
            reporter.signalAuthenticationAttempt(session2, service, this.currentMechanism.toString());
        }
        Buffer buffer = session2.createBuffer((byte)50);
        buffer.putString(session2.getUsername());
        buffer.putString(service);
        buffer.putString(this.getName());
        buffer.putInt(1L);
        buffer.putBytes(this.currentMechanism.getDER());
        session2.writePacket(buffer);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean processAuthDataRequest(ClientSession session2, String service, Buffer in) throws Exception {
        int command2 = in.getUByte();
        if (this.context == null) {
            return false;
        }
        try {
            switch (command2) {
                case 60: {
                    if (this.state != ProtocolState.STARTED) {
                        return this.unexpectedMessage(command2);
                    }
                    Oid mechanism = new Oid(in.getBytes());
                    if (!this.currentMechanism.equals(mechanism)) {
                        return false;
                    }
                    this.replyToken(session2, service, new byte[0]);
                    return true;
                }
                case 61: {
                    if (!this.context.isEstablished() && this.state == ProtocolState.TOKENS) {
                        this.replyToken(session2, service, in.getBytes());
                        return true;
                    }
                    return this.unexpectedMessage(command2);
                }
            }
            return this.unexpectedMessage(command2);
        }
        catch (GSSException e2) {
            this.log.warn(MessageFormat.format(SshdText.get().gssapiFailure, this.currentMechanism.toString()), e2);
            this.state = ProtocolState.FAILED;
            return false;
        }
    }

    @Override
    public void destroy() {
        try {
            this.close(false);
        }
        finally {
            super.destroy();
        }
    }

    private void close(boolean silent) {
        block3: {
            try {
                if (this.context != null) {
                    this.context.dispose();
                    this.context = null;
                }
            }
            catch (GSSException e2) {
                if (silent) break block3;
                this.log.warn(SshdText.get().gssapiFailure, e2);
            }
        }
    }

    private void sendToken(ClientSession session2, byte[] receivedToken) throws IOException, GSSException {
        this.state = ProtocolState.TOKENS;
        byte[] token2 = this.context.initSecContext(receivedToken, 0, receivedToken.length);
        if (token2 != null) {
            Buffer buffer = session2.createBuffer((byte)61);
            buffer.putBytes(token2);
            session2.writePacket(buffer);
        }
    }

    private void sendMic(ClientSession session2, String service) throws IOException, GSSException {
        this.state = ProtocolState.MIC_SENT;
        ByteArrayBuffer micBuffer = new ByteArrayBuffer();
        micBuffer.putBytes(session2.getSessionId());
        ((Buffer)micBuffer).putByte((byte)50);
        micBuffer.putString(session2.getUsername());
        micBuffer.putString(service);
        micBuffer.putString(this.getName());
        byte[] micBytes = micBuffer.getCompactData();
        byte[] mic = this.context.getMIC(micBytes, 0, micBytes.length, new MessageProp(0, true));
        Buffer buffer = session2.createBuffer((byte)66);
        buffer.putBytes(mic);
        session2.writePacket(buffer);
    }

    private void replyToken(ClientSession session2, String service, byte[] bytes) throws IOException, GSSException {
        this.sendToken(session2, bytes);
        if (this.context.isEstablished()) {
            this.sendMic(session2, service);
        }
    }

    private String getHostName(ClientSession session2) {
        InetAddress address;
        SocketAddress remote = session2.getConnectAddress();
        if (remote instanceof InetSocketAddress && (address = GssApiMechanisms.resolve((InetSocketAddress)remote)) != null) {
            return address.getCanonicalHostName();
        }
        if (session2 instanceof JGitClientSession) {
            String hostName = ((JGitClientSession)session2).getHostConfigEntry().getHostName();
            try {
                hostName = InetAddress.getByName(hostName).getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return hostName;
        }
        throw new IllegalStateException("Wrong session class :" + session2.getClass().getName());
    }

    private boolean unexpectedMessage(int command2) {
        this.log.warn(MessageFormat.format(SshdText.get().gssapiUnexpectedMessage, this.getName(), Integer.toString(command2)));
        return false;
    }

    @Override
    public void signalAuthMethodSuccess(ClientSession session2, String service, Buffer buffer) throws Exception {
        GssApiWithMicAuthenticationReporter reporter = session2.getAttribute(GssApiWithMicAuthenticationReporter.GSS_AUTHENTICATION_REPORTER);
        if (reporter != null) {
            reporter.signalAuthenticationSuccess(session2, service, this.currentMechanism.toString());
        }
    }

    @Override
    public void signalAuthMethodFailure(ClientSession session2, String service, boolean partial, List<String> serverMethods, Buffer buffer) throws Exception {
        GssApiWithMicAuthenticationReporter reporter = session2.getAttribute(GssApiWithMicAuthenticationReporter.GSS_AUTHENTICATION_REPORTER);
        if (reporter != null) {
            reporter.signalAuthenticationFailure(session2, service, this.currentMechanism.toString(), partial, serverMethods);
        }
    }

    private static enum ProtocolState {
        STARTED,
        TOKENS,
        MIC_SENT,
        FAILED;

    }
}

