/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.cipher.CipherFactory;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.core.CoreModuleProperties;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.internal.transport.sshd.JGitSshClient;
import org.eclipse.jgit.internal.transport.sshd.ServerKeyLookup;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.internal.transport.sshd.proxy.StatefulProxyConnector;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.util.StringUtils;

public class JGitClientSession
extends ClientSessionImpl {
    public static final AttributeRepository.AttributeKey<Supplier<KeyPasswordProvider>> KEY_PASSWORD_PROVIDER_FACTORY = new AttributeRepository.AttributeKey();
    private static final int DEFAULT_MAX_IDENTIFICATION_SIZE = 65536;
    private static final Set<? extends CipherFactory> FORBIDDEN_CIPHERS = EnumSet.of(BuiltinCiphers.none);
    private HostConfigEntry hostConfig;
    private CredentialsProvider credentialsProvider;
    private boolean isInitialKex = true;
    private List<NamedFactory<Cipher>> ciphers;
    private volatile StatefulProxyConnector proxyHandler;

    public JGitClientSession(ClientFactoryManager manager, IoSession session2) throws Exception {
        super(manager, session2);
    }

    public HostConfigEntry getHostConfigEntry() {
        return this.hostConfig;
    }

    public void setHostConfigEntry(HostConfigEntry hostConfig) {
        this.hostConfig = hostConfig;
    }

    public void setCredentialsProvider(CredentialsProvider provider2) {
        this.credentialsProvider = provider2;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setProxyHandler(StatefulProxyConnector handler2) {
        this.proxyHandler = handler2;
    }

    @Override
    protected IoWriteFuture sendIdentification(String ident, List<String> extraLines) throws Exception {
        StatefulProxyConnector proxy = this.proxyHandler;
        if (proxy != null) {
            proxy.runWhenDone(() -> {
                JGitClientSession.super.sendIdentification(ident, extraLines);
                return null;
            });
            return null;
        }
        return super.sendIdentification(ident, extraLines);
    }

    @Override
    protected byte[] sendKexInit() throws Exception {
        StatefulProxyConnector proxy = this.proxyHandler;
        if (proxy != null) {
            proxy.runWhenDone(() -> {
                JGitClientSession.super.sendKexInit();
                return null;
            });
            return null;
        }
        return super.sendKexInit();
    }

    @Override
    public void messageReceived(Readable buffer) throws Exception {
        StatefulProxyConnector proxy = this.proxyHandler;
        if (proxy != null) {
            proxy.messageReceived(this.getIoSession(), buffer);
        } else {
            super.messageReceived(buffer);
        }
    }

    Set<String> getAllAvailableSignatureAlgorithms() {
        HashSet<String> allAvailable = new HashSet<String>();
        BuiltinSignatures.VALUES.forEach(s2 -> {
            boolean bl = allAvailable.add(s2.getName());
        });
        BuiltinSignatures.getRegisteredExtensions().forEach(s2 -> {
            boolean bl = allAvailable.add(s2.getName());
        });
        return allAvailable;
    }

    private void setNewFactories(Collection<String> defaultFactories, Collection<String> finalFactories) {
        LinkedHashSet<String> resultSet = new LinkedHashSet<String>(defaultFactories);
        resultSet.addAll(finalFactories);
        this.setSignatureFactoriesNames(resultSet);
    }

    @Override
    protected String resolveAvailableSignaturesProposal(FactoryManager manager) {
        ServerKeyVerifier verifier;
        List<String> defaultSignatures = this.getSignatureFactoriesNames();
        HostConfigEntry config2 = this.resolveAttribute(JGitSshClient.HOST_CONFIG_ENTRY);
        String algorithms = config2.getProperty("HostKeyAlgorithms");
        if (!StringUtils.isEmptyOrNull(algorithms)) {
            List<String> result2 = this.modifyAlgorithmList(defaultSignatures, this.getAllAvailableSignatureAlgorithms(), algorithms, "HostKeyAlgorithms");
            if (!result2.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("HostKeyAlgorithms " + String.valueOf(result2));
                }
                this.setNewFactories(defaultSignatures, result2);
                return String.join((CharSequence)",", result2);
            }
            this.log.warn(MessageFormat.format(SshdText.get().configNoKnownAlgorithms, "HostKeyAlgorithms", algorithms));
        }
        if ((verifier = this.getServerKeyVerifier()) instanceof ServerKeyLookup) {
            SocketAddress remoteAddress2 = this.resolvePeerAddress(this.resolveAttribute(JGitSshClient.ORIGINAL_REMOTE_ADDRESS));
            List<PublicKey> allKnownKeys = ((ServerKeyLookup)((Object)verifier)).lookup(this, remoteAddress2);
            LinkedHashSet<String> reordered = new LinkedHashSet<String>();
            for (PublicKey key2 : allKnownKeys) {
                String keyType;
                if (key2 == null || (keyType = KeyUtils.getKeyType(key2)) == null) continue;
                if ("ssh-rsa".equals(keyType)) {
                    reordered.add("rsa-sha2-512");
                    reordered.add("rsa-sha2-256");
                }
                reordered.add(keyType);
            }
            reordered.addAll(defaultSignatures);
            if (this.log.isDebugEnabled()) {
                this.log.debug("HostKeyAlgorithms " + String.valueOf(reordered));
            }
            if (reordered.size() > defaultSignatures.size()) {
                this.setNewFactories(defaultSignatures, reordered);
            }
            return String.join((CharSequence)",", reordered);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("HostKeyAlgorithms " + String.valueOf(defaultSignatures));
        }
        return String.join((CharSequence)",", defaultSignatures);
    }

    private List<String> determineKexProposal() {
        List<KeyExchangeFactory> kexFactories = this.getKeyExchangeFactories();
        List<String> defaultKexMethods = NamedResource.getNameList(kexFactories);
        HostConfigEntry config2 = this.resolveAttribute(JGitSshClient.HOST_CONFIG_ENTRY);
        String algorithms = config2.getProperty("KexAlgorithms");
        if (!StringUtils.isEmptyOrNull(algorithms)) {
            HashSet<String> allAvailable = new HashSet<String>();
            BuiltinDHFactories.VALUES.forEach(s2 -> {
                boolean bl = allAvailable.add(s2.getName());
            });
            BuiltinDHFactories.getRegisteredExtensions().forEach(s2 -> {
                boolean bl = allAvailable.add(s2.getName());
            });
            List<String> result2 = this.modifyAlgorithmList(defaultKexMethods, allAvailable, algorithms, "KexAlgorithms");
            if (!result2.isEmpty()) {
                HashSet<String> configuredKexMethods = new HashSet<String>(defaultKexMethods);
                ArrayList<KeyExchangeFactory> newKexFactories = new ArrayList<KeyExchangeFactory>();
                result2.forEach(name -> {
                    if (!configuredKexMethods.contains(name)) {
                        DHFactory factory2 = BuiltinDHFactories.resolveFactory(name);
                        if (factory2 == null) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("determineKexProposal({}) unknown KEX algorithm {} ignored", (Object)this, name);
                            }
                        } else {
                            newKexFactories.add(ClientBuilder.DH2KEX.apply(factory2));
                        }
                    }
                });
                if (!newKexFactories.isEmpty()) {
                    newKexFactories.addAll(kexFactories);
                    this.setKeyExchangeFactories(newKexFactories);
                }
                return result2;
            }
            this.log.warn(MessageFormat.format(SshdText.get().configNoKnownAlgorithms, "KexAlgorithms", algorithms));
        }
        return defaultKexMethods;
    }

    @Override
    protected String resolveSessionKexProposal(String hostKeyTypes) throws IOException {
        Object kexMethods = String.join((CharSequence)",", this.determineKexProposal());
        if (this.isInitialKex) {
            KexExtensionHandler extHandler = this.getKexExtensionHandler();
            if (extHandler != null && extHandler.isKexExtensionsAvailable(this, KexExtensionHandler.AvailabilityPhase.PROPOSAL)) {
                kexMethods = ((String)kexMethods).isEmpty() ? "ext-info-c" : (String)kexMethods + ",ext-info-c";
            }
            this.isInitialKex = false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("KexAlgorithms " + (String)kexMethods);
        }
        return kexMethods;
    }

    @Override
    public List<NamedFactory<Cipher>> getCipherFactories() {
        if (this.ciphers == null) {
            List<NamedFactory<Cipher>> defaultCiphers = super.getCipherFactories();
            HostConfigEntry config2 = this.resolveAttribute(JGitSshClient.HOST_CONFIG_ENTRY);
            String algorithms = config2.getProperty("Ciphers");
            if (!StringUtils.isEmptyOrNull(algorithms)) {
                List defaultCipherNames = defaultCiphers.stream().map(NamedResource::getName).collect(Collectors.toCollection(ArrayList::new));
                HashSet<String> allKnownCiphers = new HashSet<String>();
                BuiltinCiphers.VALUES.stream().filter(c2 -> !FORBIDDEN_CIPHERS.contains(c2)).filter(OptionalFeature::isSupported).forEach(c2 -> {
                    boolean bl = allKnownCiphers.add(c2.getName());
                });
                BuiltinCiphers.getRegisteredExtensions().stream().filter(OptionalFeature::isSupported).forEach(c2 -> {
                    boolean bl = allKnownCiphers.add(c2.getName());
                });
                List<String> sessionCipherNames = this.modifyAlgorithmList(defaultCipherNames, allKnownCiphers, algorithms, "Ciphers");
                if (sessionCipherNames.isEmpty()) {
                    this.log.warn(MessageFormat.format(SshdText.get().configNoKnownAlgorithms, "Ciphers", algorithms));
                    this.ciphers = defaultCiphers;
                } else {
                    ArrayList<NamedFactory<Cipher>> sessionCiphers = new ArrayList<NamedFactory<Cipher>>(sessionCipherNames.size());
                    sessionCipherNames.forEach(name -> {
                        boolean bl = sessionCiphers.add(BuiltinCiphers.resolveFactory(name));
                    });
                    this.ciphers = sessionCiphers;
                }
            } else {
                this.ciphers = defaultCiphers;
            }
        }
        return this.ciphers;
    }

    public List<String> modifyAlgorithmList(List<String> defaultList, Set<String> allAvailable, String fromConfig, String overrideKey) {
        LinkedHashSet<String> defaults = new LinkedHashSet<String>();
        defaults.addAll(defaultList);
        switch (fromConfig.charAt(0)) {
            case '+': {
                List<String> newSignatures = this.filteredList(allAvailable, overrideKey, fromConfig.substring(1));
                defaults.addAll(newSignatures);
                return new ArrayList<String>(defaults);
            }
            case '-': {
                this.removeFromList(defaults, overrideKey, fromConfig.substring(1));
                return new ArrayList<String>(defaults);
            }
            case '^': {
                List<String> allSignatures = this.filteredList(allAvailable, overrideKey, fromConfig.substring(1));
                HashSet<String> atFront = new HashSet<String>(allSignatures);
                for (String sig : defaults) {
                    if (atFront.contains(sig)) continue;
                    allSignatures.add(sig);
                }
                return allSignatures;
            }
        }
        return this.filteredList(allAvailable, overrideKey, fromConfig);
    }

    private void removeFromList(Set<String> current, String key2, String patterns2) {
        String[] stringArray = patterns2.split("\\s*,\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String toRemove = stringArray[n2];
            if (toRemove.indexOf(42) < 0 && toRemove.indexOf(63) < 0) {
                current.remove(toRemove);
            } else {
                try {
                    FileNameMatcher matcher = new FileNameMatcher(toRemove, null);
                    Iterator<String> i2 = current.iterator();
                    while (i2.hasNext()) {
                        matcher.reset();
                        matcher.append(i2.next());
                        if (!matcher.isMatch()) continue;
                        i2.remove();
                    }
                }
                catch (InvalidPatternException e2) {
                    this.log.warn(MessageFormat.format(SshdText.get().configInvalidPattern, key2, toRemove));
                }
            }
            ++n2;
        }
    }

    private List<String> filteredList(Set<String> known2, String key2, String values2) {
        ArrayList<String> newNames = new ArrayList<String>();
        String[] stringArray = values2.split("\\s*,\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String newValue = stringArray[n2];
            if (known2.contains(newValue)) {
                newNames.add(newValue);
            } else {
                this.log.warn(MessageFormat.format(SshdText.get().configUnknownAlgorithm, this, newValue, key2, values2));
            }
            ++n2;
        }
        return newNames;
    }

    @Override
    protected List<String> doReadIdentification(Buffer buffer, boolean server2) throws StreamCorruptedException {
        int maxIdentSize;
        if (server2) {
            throw new IllegalStateException("doReadIdentification of client called with server=true");
        }
        Integer maxIdentLength = CoreModuleProperties.MAX_IDENTIFICATION_SIZE.get(this).orElse(null);
        if (maxIdentLength == null || maxIdentLength < 65536) {
            maxIdentSize = 65536;
            CoreModuleProperties.MAX_IDENTIFICATION_SIZE.set(this, maxIdentSize);
        } else {
            maxIdentSize = maxIdentLength;
        }
        int current = buffer.rpos();
        int end2 = current + buffer.available();
        if (current >= end2) {
            return null;
        }
        byte[] raw = buffer.array();
        ArrayList<String> ident = new ArrayList<String>();
        int start2 = current;
        boolean hasNul = false;
        int i2 = current;
        while (i2 < end2) {
            switch (raw[i2]) {
                case 0: {
                    hasNul = true;
                    break;
                }
                case 10: {
                    int eol = 1;
                    if (i2 > start2 && raw[i2 - 1] == 13) {
                        ++eol;
                    }
                    String line = new String(raw, start2, i2 + 1 - eol - start2, StandardCharsets.UTF_8);
                    start2 = i2 + 1;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(MessageFormat.format("doReadIdentification({0}) line: ", this) + JGitClientSession.escapeControls(line));
                    }
                    ident.add(line);
                    if (line.startsWith("SSH-")) {
                        if (hasNul) {
                            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().serverIdWithNul, JGitClientSession.escapeControls(line)));
                        }
                        if (line.length() + eol > 255) {
                            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().serverIdTooLong, JGitClientSession.escapeControls(line)));
                        }
                        buffer.rpos(start2);
                        return ident;
                    }
                    hasNul = false;
                    break;
                }
            }
            if (i2 - current + 1 >= maxIdentSize) {
                String msg = MessageFormat.format(SshdText.get().serverIdNotReceived, Integer.toString(maxIdentSize));
                if (this.log.isDebugEnabled()) {
                    this.log.debug(msg);
                    this.log.debug(buffer.toHex());
                }
                throw new StreamCorruptedException(msg);
            }
            ++i2;
        }
        return null;
    }

    private static String escapeControls(String s2) {
        StringBuilder b2 = new StringBuilder();
        int l = s2.length();
        int i2 = 0;
        while (i2 < l) {
            char ch = s2.charAt(i2);
            if (Character.isISOControl(ch)) {
                b2.append(ch <= '\u000f' ? "\\u000" : "\\u00").append(Integer.toHexString(ch));
            } else {
                b2.append(ch);
            }
            ++i2;
        }
        return b2.toString();
    }

    @Override
    public <T> T getAttribute(AttributeRepository.AttributeKey<T> key2) {
        Object obj;
        IoSession ioSession;
        T value2 = super.getAttribute(key2);
        if (value2 == null && (ioSession = this.getIoSession()) != null && (obj = ioSession.getAttribute(AttributeRepository.class)) instanceof AttributeRepository) {
            AttributeRepository sessionAttributes = (AttributeRepository)obj;
            value2 = sessionAttributes.resolveAttribute(key2);
        }
        return value2;
    }

    @Override
    public PropertyResolver getParentPropertyResolver() {
        Object obj;
        IoSession ioSession = this.getIoSession();
        if (ioSession != null && (obj = ioSession.getAttribute(AttributeRepository.class)) instanceof PropertyResolver) {
            return (PropertyResolver)obj;
        }
        return super.getParentPropertyResolver();
    }

    public static class ChainingAttributes
    implements AttributeRepository {
        private final AttributeRepository delegate;
        private final AttributeRepository parent;

        public ChainingAttributes(AttributeRepository self, AttributeRepository parent) {
            this.delegate = self;
            this.parent = parent;
        }

        @Override
        public int getAttributesCount() {
            return this.delegate.getAttributesCount();
        }

        @Override
        public <T> T getAttribute(AttributeRepository.AttributeKey<T> key2) {
            return this.delegate.getAttribute(Objects.requireNonNull(key2));
        }

        @Override
        public Collection<AttributeRepository.AttributeKey<?>> attributeKeys() {
            return this.delegate.attributeKeys();
        }

        @Override
        public <T> T resolveAttribute(AttributeRepository.AttributeKey<T> key2) {
            T value2 = this.getAttribute(Objects.requireNonNull(key2));
            if (value2 == null) {
                return this.parent.getAttribute(key2);
            }
            return value2;
        }
    }

    public static class SessionAttributes
    extends ChainingAttributes
    implements PropertyResolver {
        public static final AttributeRepository.AttributeKey<Map<String, Object>> PROPERTIES = new AttributeRepository.AttributeKey();
        private final PropertyResolver parentProperties;

        public SessionAttributes(AttributeRepository self, AttributeRepository parent, PropertyResolver parentProperties) {
            super(self, parent);
            this.parentProperties = parentProperties;
        }

        @Override
        public PropertyResolver getParentPropertyResolver() {
            return this.parentProperties;
        }

        @Override
        public Map<String, Object> getProperties() {
            Map<String, Object> props = this.getAttribute(PROPERTIES);
            return props == null ? Collections.emptyMap() : props;
        }
    }
}

