/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentKeyConstraint;
import org.apache.sshd.client.auth.pubkey.KeyAgentIdentity;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKey;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyIterator;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.u2f.SecurityKeyPublicKey;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationCanceledException;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.internal.transport.sshd.pkcs11.Pkcs11Provider;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;

public class JGitPublicKeyAuthentication
extends UserAuthPublicKey {
    private static final String LOG_FORMAT = "{}";
    private SshAgent agent;
    private HostConfigEntry hostConfig;
    private boolean addKeysToAgent;
    private boolean askBeforeAdding;
    private String skProvider;
    private SshAgentKeyConstraint[] constraints;

    JGitPublicKeyAuthentication(List<NamedFactory<Signature>> factories) {
        super(factories);
    }

    @Override
    public void init(ClientSession rawSession, String service) throws Exception {
        List<NamedFactory<Signature>> localFactories;
        if (!(rawSession instanceof JGitClientSession)) {
            throw new IllegalStateException("Wrong session type: " + rawSession.getClass().getCanonicalName());
        }
        JGitClientSession session2 = (JGitClientSession)rawSession;
        this.hostConfig = session2.getHostConfigEntry();
        String pubkeyAlgos = this.hostConfig.getProperty("PubkeyAcceptedAlgorithms");
        if (!StringUtils.isEmptyOrNull(pubkeyAlgos)) {
            List<String> signatures = session2.getSignatureFactoriesNames();
            if (!(signatures = session2.modifyAlgorithmList(signatures, session2.getAllAvailableSignatureAlgorithms(), pubkeyAlgos, "PubkeyAcceptedAlgorithms")).isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("PubkeyAcceptedAlgorithms " + String.valueOf(signatures));
                }
                this.setSignatureFactoriesNames(signatures);
                super.init(session2, service);
                return;
            }
            this.log.warn(LOG_FORMAT, (Object)MessageFormat.format(SshdText.get().configNoKnownAlgorithms, "PubkeyAcceptedAlgorithms", pubkeyAlgos));
        }
        if ((localFactories = this.getSignatureFactories()) == null || localFactories.isEmpty()) {
            this.setSignatureFactoriesNames(session2.getSignatureFactoriesNames());
        }
        super.init(session2, service);
    }

    @Override
    protected Iterator<PublicKeyIdentity> createPublicKeyIterator(ClientSession session2, SignatureFactoriesManager manager) throws Exception {
        this.agent = this.getAgent(session2);
        if (this.agent != null) {
            this.parseAddKeys(this.hostConfig);
            if (this.addKeysToAgent) {
                this.skProvider = this.hostConfig.getProperty("SecurityKeyProvider");
            }
        }
        return new KeyIterator(session2, manager);
    }

    @Override
    protected PublicKeyIdentity resolveAttemptedPublicKeyIdentity(ClientSession session2, String service) throws Exception {
        KeyPair key2;
        PublicKeyIdentity id = super.resolveAttemptedPublicKeyIdentity(session2, service);
        if (this.addKeysToAgent && id != null && !(id instanceof KeyAgentIdentity) && (key2 = id.getKeyIdentity()) != null && key2.getPublic() != null && key2.getPrivate() != null) {
            PublicKey pk = key2.getPublic();
            String fingerprint = KeyUtils.getFingerPrint(pk);
            String keyType = KeyUtils.getKeyType(key2);
            try {
                if (this.agentHasKey(pk)) {
                    return id;
                }
                if (this.askBeforeAdding && session2 instanceof JGitClientSession) {
                    boolean result2;
                    CredentialsProvider provider2 = ((JGitClientSession)session2).getCredentialsProvider();
                    CredentialItem.YesNoType question = new CredentialItem.YesNoType(MessageFormat.format(SshdText.get().pubkeyAuthAddKeyToAgentQuestion, keyType, fingerprint));
                    boolean bl = result2 = provider2 != null && provider2.supports(question) && provider2.get(this.getUri(), question);
                    if (!result2 || !question.getValue()) {
                        return id;
                    }
                }
                SshAgentKeyConstraint[] rules = this.constraints;
                if (pk instanceof SecurityKeyPublicKey && !StringUtils.isEmptyOrNull(this.skProvider)) {
                    rules = Arrays.copyOf(rules, rules.length + 1);
                    rules[rules.length - 1] = new SshAgentKeyConstraint.FidoProviderExtension(this.skProvider);
                }
                this.agent.addIdentity(key2, null, rules);
            }
            catch (IOException e2) {
                this.log.error(LOG_FORMAT, (Object)MessageFormat.format(SshdText.get().pubkeyAuthAddKeyToAgentError, keyType, fingerprint), (Object)e2);
            }
        }
        return id;
    }

    private boolean agentHasKey(PublicKey pk) throws IOException {
        Iterable<? extends Map.Entry<PublicKey, String>> ids = this.agent.getIdentities();
        if (ids == null) {
            return false;
        }
        Iterator<? extends Map.Entry<PublicKey, String>> iter = ids.iterator();
        while (iter.hasNext()) {
            if (!KeyUtils.compareKeys(iter.next().getKey(), pk)) continue;
            return true;
        }
        return false;
    }

    private URIish getUri() {
        Object uri2 = "ssh://";
        String userName = this.hostConfig.getUsername();
        if (!StringUtils.isEmptyOrNull(userName)) {
            uri2 = (String)uri2 + userName + "@";
        }
        uri2 = (String)uri2 + this.hostConfig.getHost();
        int port2 = this.hostConfig.getPort();
        if (port2 > 0 && port2 != 22) {
            uri2 = (String)uri2 + ":" + port2;
        }
        try {
            return new URIish((String)uri2);
        }
        catch (URISyntaxException e2) {
            this.log.error(e2.getLocalizedMessage(), e2);
            return new URIish();
        }
    }

    private SshAgent getAgent(ClientSession session2) throws Exception {
        FactoryManager manager = Objects.requireNonNull(session2.getFactoryManager(), "No session factory manager");
        SshAgentFactory factory2 = manager.getAgentFactory();
        if (factory2 == null) {
            return null;
        }
        return factory2.createClient(session2, manager);
    }

    private void parseAddKeys(HostConfigEntry config2) {
        String value2 = config2.getProperty("AddKeysToAgent");
        if (StringUtils.isEmptyOrNull(value2)) {
            this.addKeysToAgent = false;
            return;
        }
        String[] values2 = value2.split(",");
        ArrayList<SshAgentKeyConstraint> rules = new ArrayList<SshAgentKeyConstraint>(2);
        switch (values2[0]) {
            case "yes": {
                this.addKeysToAgent = true;
                break;
            }
            case "no": {
                this.addKeysToAgent = false;
                break;
            }
            case "ask": {
                this.addKeysToAgent = true;
                this.askBeforeAdding = true;
                break;
            }
            case "confirm": {
                int seconds;
                this.addKeysToAgent = true;
                rules.add(SshAgentKeyConstraint.CONFIRM);
                if (values2.length <= 1 || (seconds = OpenSshConfigFile.timeSpec(values2[1])) <= 0) break;
                rules.add(new SshAgentKeyConstraint.LifeTime(seconds));
                break;
            }
            default: {
                int seconds = OpenSshConfigFile.timeSpec(values2[0]);
                if (seconds <= 0) break;
                this.addKeysToAgent = true;
                rules.add(new SshAgentKeyConstraint.LifeTime(seconds));
            }
        }
        this.constraints = rules.toArray(new SshAgentKeyConstraint[0]);
    }

    @Override
    protected void releaseKeys() throws IOException {
        block6: {
            this.addKeysToAgent = false;
            this.askBeforeAdding = false;
            this.skProvider = null;
            this.constraints = null;
            try {
                if (this.agent == null) break block6;
                try {
                    this.agent.close();
                }
                finally {
                    this.agent = null;
                }
            }
            finally {
                super.releaseKeys();
            }
        }
    }

    private class KeyIterator
    extends UserAuthPublicKeyIterator {
        private static final String PUB_KEY_SUFFIX = ".pub";

        public KeyIterator(ClientSession session2, SignatureFactoriesManager manager) throws Exception {
            super(session2, manager);
        }

        private List<PublicKey> getExplicitKeys(Collection<String> explicitFiles) {
            if (explicitFiles == null) {
                return null;
            }
            return explicitFiles.stream().map(s2 -> {
                PublicKey publicKey = this.readPublicKey((String)s2, false);
                if (publicKey == null && !s2.endsWith(PUB_KEY_SUFFIX)) {
                    publicKey = this.readPublicKey(s2 + PUB_KEY_SUFFIX, true);
                }
                return publicKey;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }

        private PublicKey readPublicKey(String keyFile, boolean isDerived) {
            try {
                Path p = Paths.get(keyFile, new String[0]);
                if (Files.isRegularFile(p, LinkOption.NOFOLLOW_LINKS)) {
                    return KeyUtils.loadPublicKey(p);
                }
                if (!isDerived) {
                    JGitPublicKeyAuthentication.this.log.warn(JGitPublicKeyAuthentication.LOG_FORMAT, (Object)MessageFormat.format(SshdText.get().cannotReadPublicKey, keyFile));
                }
            }
            catch (StreamCorruptedException | GeneralSecurityException e2) {
                if (isDerived) {
                    JGitPublicKeyAuthentication.this.log.warn(JGitPublicKeyAuthentication.LOG_FORMAT, (Object)MessageFormat.format(SshdText.get().cannotReadPublicKey, keyFile), (Object)e2);
                }
            }
            catch (IOException | InvalidPathException e3) {
                JGitPublicKeyAuthentication.this.log.warn(JGitPublicKeyAuthentication.LOG_FORMAT, (Object)MessageFormat.format(SshdText.get().cannotReadPublicKey, keyFile), (Object)e3);
            }
            return null;
        }

        @Override
        protected Iterable<KeyAgentIdentity> initializeAgentIdentities(ClientSession session2) throws IOException {
            Iterable<KeyAgentIdentity> allAgentKeys = this.getAgentIdentities();
            if (allAgentKeys == null) {
                return null;
            }
            final Collection<PublicKey> identityFiles = this.identitiesOnly();
            if (GenericUtils.isEmpty(identityFiles)) {
                return allAgentKeys;
            }
            return () -> new Iterator<KeyAgentIdentity>(allAgentKeys){
                private final Iterator<KeyAgentIdentity> identities;
                private KeyAgentIdentity next;
                {
                    this.identities = iterable.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this.next == null && this.identities.hasNext()) {
                        KeyAgentIdentity val = this.identities.next();
                        PublicKey pk = val.getKeyIdentity().getPublic();
                        if (identityFiles.stream().anyMatch(k2 -> KeyUtils.compareKeys(k2, pk))) {
                            this.next = val;
                            return true;
                        }
                        if (!JGitPublicKeyAuthentication.this.log.isTraceEnabled()) continue;
                        JGitPublicKeyAuthentication.this.log.trace("Ignoring SSH agent or PKCS11 {} key not in explicit IdentityFile in SSH config: {}", (Object)KeyUtils.getKeyType(pk), (Object)KeyUtils.getFingerPrint(pk));
                    }
                    return this.next != null;
                }

                @Override
                public KeyAgentIdentity next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    KeyAgentIdentity result2 = this.next;
                    this.next = null;
                    return result2;
                }
            };
        }

        private Collection<PublicKey> identitiesOnly() {
            if (JGitPublicKeyAuthentication.this.hostConfig != null && JGitPublicKeyAuthentication.this.hostConfig.isIdentitiesOnly()) {
                return this.getExplicitKeys(JGitPublicKeyAuthentication.this.hostConfig.getIdentities());
            }
            return Collections.emptyList();
        }

        private Iterable<KeyAgentIdentity> getAgentIdentities() throws IOException {
            Iterable<KeyAgentIdentity> pkcs11Keys = this.getPkcs11Keys();
            if (JGitPublicKeyAuthentication.this.agent == null) {
                return pkcs11Keys;
            }
            Iterable<? extends Map.Entry<PublicKey, String>> agentKeys = JGitPublicKeyAuthentication.this.agent.getIdentities();
            if (GenericUtils.isEmpty(agentKeys)) {
                return pkcs11Keys;
            }
            Iterable<KeyAgentIdentity> fromAgent = () -> new Iterator<KeyAgentIdentity>(agentKeys){
                private final Iterator<? extends Map.Entry<PublicKey, String>> iter;
                {
                    this.iter = iterable.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public KeyAgentIdentity next() {
                    Map.Entry<PublicKey, String> next2 = this.iter.next();
                    return new KeyAgentIdentity(((KeyIterator)KeyIterator.this).JGitPublicKeyAuthentication.this.agent, next2.getKey(), next2.getValue());
                }
            };
            if (GenericUtils.isEmpty(pkcs11Keys)) {
                return fromAgent;
            }
            return () -> new Iterator<KeyAgentIdentity>(pkcs11Keys, fromAgent){
                private final Iterator<Iterator<KeyAgentIdentity>> keyIter;
                private Iterator<KeyAgentIdentity> currentKeys;
                private Boolean hasElement;
                {
                    this.keyIter = List.of(iterable.iterator(), iterable2.iterator()).iterator();
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public boolean hasNext() {
                    if (this.hasElement == null) ** GOTO lbl9
                    return this.hasElement;
lbl-1000:
                    // 1 sources

                    {
                        if (this.keyIter.hasNext()) {
                            this.currentKeys = this.keyIter.next();
                            continue;
                        }
                        this.currentKeys = null;
                        this.hasElement = Boolean.FALSE;
                        return false;
lbl9:
                        // 2 sources

                        ** while (this.currentKeys == null || !this.currentKeys.hasNext())
                    }
lbl10:
                    // 1 sources

                    this.hasElement = Boolean.TRUE;
                    return true;
                }

                @Override
                public KeyAgentIdentity next() {
                    KeyAgentIdentity result2;
                    if (this.hasElement == null && !this.hasNext() || !this.hasElement.booleanValue()) {
                        throw new NoSuchElementException();
                    }
                    this.hasElement = null;
                    try {
                        result2 = this.currentKeys.next();
                    }
                    catch (NoSuchElementException e2) {
                        result2 = null;
                    }
                    return result2;
                }
            };
        }

        private Iterable<KeyAgentIdentity> getPkcs11Keys() throws IOException {
            Iterable<KeyAgentIdentity> pkcs11Identities;
            String value2;
            block9: {
                Path library;
                value2 = JGitPublicKeyAuthentication.this.hostConfig.getProperty("PKCS11Provider");
                if (StringUtils.isEmptyOrNull(value2) || "none".equals(value2)) {
                    return null;
                }
                if (value2.startsWith("~/") || value2.startsWith("~" + File.separator)) {
                    value2 = new File(FS.DETECTED.userHome(), value2.substring(2)).toString();
                }
                if (!(library = Paths.get(value2, new String[0])).isAbsolute()) {
                    throw new IOException(MessageFormat.format(SshdText.get().pkcs11NotAbsolute, JGitPublicKeyAuthentication.this.hostConfig.getHost(), JGitPublicKeyAuthentication.this.hostConfig.getHostName(), "PKCS11Provider", value2));
                }
                if (!Files.isRegularFile(library, new LinkOption[0])) {
                    throw new IOException(MessageFormat.format(SshdText.get().pkcs11NonExisting, JGitPublicKeyAuthentication.this.hostConfig.getHost(), JGitPublicKeyAuthentication.this.hostConfig.getHostName(), "PKCS11Provider", value2));
                }
                int slotListIndex = OpenSshConfigFile.positive(JGitPublicKeyAuthentication.this.hostConfig.getProperty("PKCS11SlotListIndex"));
                Pkcs11Provider provider2 = Pkcs11Provider.getProvider(library, slotListIndex);
                if (provider2 == null) {
                    throw new UnsupportedOperationException();
                }
                pkcs11Identities = provider2.getKeys(this.getSession());
                if (!GenericUtils.isEmpty(pkcs11Identities)) break block9;
                JGitPublicKeyAuthentication.this.log.warn(JGitPublicKeyAuthentication.LOG_FORMAT, (Object)MessageFormat.format(SshdText.get().pkcs11NoKeys, JGitPublicKeyAuthentication.this.hostConfig.getHost(), JGitPublicKeyAuthentication.this.hostConfig.getHostName(), "PKCS11Provider", value2));
                return null;
            }
            try {
                return pkcs11Identities;
            }
            catch (UnsupportedOperationException e2) {
                throw new UnsupportedOperationException(MessageFormat.format(SshdText.get().pkcs11Unsupported, JGitPublicKeyAuthentication.this.hostConfig.getHost(), JGitPublicKeyAuthentication.this.hostConfig.getHostName(), "PKCS11Provider", value2), e2);
            }
            catch (Exception e3) {
                this.checkCancellation(e3);
                throw new IOException(MessageFormat.format(SshdText.get().pkcs11FailedInstantiation, JGitPublicKeyAuthentication.this.hostConfig.getHost(), JGitPublicKeyAuthentication.this.hostConfig.getHostName(), "PKCS11Provider", value2), e3);
            }
        }

        private void checkCancellation(Throwable e2) {
            Throwable t2 = e2;
            while (t2 != null) {
                if (t2 instanceof AuthenticationCanceledException) {
                    throw (AuthenticationCanceledException)t2;
                }
                t2 = t2.getCause();
            }
        }
    }
}

