/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.KnownHostHashValue;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.JGitHostConfigEntry;
import org.eclipse.jgit.internal.transport.sshd.ServerKeyLookup;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.sshd.ServerKeyDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGitServerKeyVerifier
implements ServerKeyVerifier,
ServerKeyLookup {
    private static final Logger LOG = LoggerFactory.getLogger(JGitServerKeyVerifier.class);
    @NonNull
    private final ServerKeyDatabase database;

    public JGitServerKeyVerifier(@NonNull ServerKeyDatabase database) {
        this.database = database;
    }

    @Override
    public List<PublicKey> lookup(ClientSession session2, SocketAddress remoteAddress2) {
        if (!(session2 instanceof JGitClientSession)) {
            LOG.warn("Internal error: wrong session kind: " + session2.getClass().getName());
            return Collections.emptyList();
        }
        if (!(remoteAddress2 instanceof InetSocketAddress)) {
            return Collections.emptyList();
        }
        SessionConfig config2 = new SessionConfig((JGitClientSession)session2);
        SshdSocketAddress connectAddress = SshdSocketAddress.toSshdSocketAddress(session2.getConnectAddress());
        String connect2 = KnownHostHashValue.createHostPattern(connectAddress.getHostName(), connectAddress.getPort());
        return this.database.lookup(connect2, (InetSocketAddress)remoteAddress2, config2);
    }

    @Override
    public boolean verifyServerKey(ClientSession session2, SocketAddress remoteAddress2, PublicKey serverKey) {
        if (!(session2 instanceof JGitClientSession)) {
            LOG.warn("Internal error: wrong session kind: " + session2.getClass().getName());
            return false;
        }
        if (!(remoteAddress2 instanceof InetSocketAddress)) {
            return false;
        }
        SessionConfig config2 = new SessionConfig((JGitClientSession)session2);
        SshdSocketAddress connectAddress = SshdSocketAddress.toSshdSocketAddress(session2.getConnectAddress());
        String connect2 = KnownHostHashValue.createHostPattern(connectAddress.getHostName(), connectAddress.getPort());
        CredentialsProvider provider2 = ((JGitClientSession)session2).getCredentialsProvider();
        return this.database.accept(connect2, (InetSocketAddress)remoteAddress2, serverKey, config2, provider2);
    }

    private static class SessionConfig
    implements ServerKeyDatabase.Configuration {
        private final JGitClientSession session;

        public SessionConfig(JGitClientSession session2) {
            this.session = session2;
        }

        private List<String> get(String key2) {
            HostConfigEntry entry = this.session.getHostConfigEntry();
            if (entry instanceof JGitHostConfigEntry) {
                return ((JGitHostConfigEntry)entry).getMultiValuedOptions().get(key2);
            }
            return Collections.emptyList();
        }

        @Override
        public List<String> getUserKnownHostsFiles() {
            return this.get("UserKnownHostsFile");
        }

        @Override
        public List<String> getGlobalKnownHostsFiles() {
            return this.get("GlobalKnownHostsFile");
        }

        @Override
        public ServerKeyDatabase.Configuration.StrictHostKeyChecking getStrictHostKeyChecking() {
            HostConfigEntry entry = this.session.getHostConfigEntry();
            String value2 = entry.getProperty("StrictHostKeyChecking", "ask");
            switch (value2.toLowerCase(Locale.ROOT)) {
                case "on": 
                case "yes": {
                    return ServerKeyDatabase.Configuration.StrictHostKeyChecking.REQUIRE_MATCH;
                }
                case "no": 
                case "off": {
                    return ServerKeyDatabase.Configuration.StrictHostKeyChecking.ACCEPT_ANY;
                }
                case "accept-new": {
                    return ServerKeyDatabase.Configuration.StrictHostKeyChecking.ACCEPT_NEW;
                }
            }
            return ServerKeyDatabase.Configuration.StrictHostKeyChecking.ASK;
        }

        @Override
        public boolean getHashKnownHosts() {
            HostConfigEntry entry = this.session.getHostConfigEntry();
            return OpenSshConfigFile.flag(entry.getProperty("HashKnownHosts"));
        }

        @Override
        public String getUsername() {
            return this.session.getUsername();
        }
    }
}

