/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.DefaultConnectFuture;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.client.session.SessionFactory;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.keyprovider.AbstractResourceKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.sshd.CachingKeyPairProvider;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.internal.transport.sshd.proxy.HttpClientConnector;
import org.eclipse.jgit.internal.transport.sshd.proxy.Socks5ClientConnector;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.sshd.KeyCache;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.transport.sshd.ProxyData;
import org.eclipse.jgit.transport.sshd.ProxyDataFactory;
import org.eclipse.jgit.util.StringUtils;

public class JGitSshClient
extends SshClient {
    static final AttributeRepository.AttributeKey<HostConfigEntry> HOST_CONFIG_ENTRY = new AttributeRepository.AttributeKey();
    static final AttributeRepository.AttributeKey<InetSocketAddress> ORIGINAL_REMOTE_ADDRESS = new AttributeRepository.AttributeKey();
    public static final AttributeRepository.AttributeKey<String> PREFERRED_AUTHENTICATIONS = new AttributeRepository.AttributeKey();
    public static final AttributeRepository.AttributeKey<Path> HOME_DIRECTORY = new AttributeRepository.AttributeKey();
    public static final AttributeRepository.AttributeKey<SshdSocketAddress> LOCAL_FORWARD_ADDRESS = new AttributeRepository.AttributeKey();
    private KeyCache keyCache;
    private CredentialsProvider credentialsProvider;
    private Supplier<KeyPasswordProvider> keyPasswordProviderFactory;
    private ProxyDataFactory proxyDatabase;

    @Override
    protected SessionFactory createSessionFactory() {
        return new JGitSessionFactory(this);
    }

    @Override
    public ConnectFuture connect(HostConfigEntry hostConfig, AttributeRepository context, SocketAddress localAddress2) throws IOException {
        ProxyData proxy;
        InetSocketAddress originalAddress;
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started.");
        }
        Objects.requireNonNull(hostConfig, "No host configuration");
        String originalHost = ValidateUtils.checkNotNullAndNotEmpty(hostConfig.getHostName(), "No target host");
        int originalPort = hostConfig.getPort();
        ValidateUtils.checkTrue(originalPort > 0, "Invalid port: %d", originalPort);
        InetSocketAddress targetAddress = originalAddress = new InetSocketAddress(originalHost, originalPort);
        String userName = hostConfig.getUsername();
        String id = userName + "@" + String.valueOf(originalAddress);
        AttributeRepository attributes2 = this.chain(context, this);
        SshdSocketAddress localForward = attributes2.resolveAttribute(LOCAL_FORWARD_ADDRESS);
        if (localForward != null) {
            targetAddress = new InetSocketAddress(localForward.getHostName(), localForward.getPort());
            id = id + "/" + targetAddress.toString();
        }
        DefaultConnectFuture connectFuture = new DefaultConnectFuture(id, null);
        SshFutureListener<IoConnectFuture> listener = this.createConnectCompletionListener(connectFuture, userName, originalAddress, hostConfig);
        attributes2 = this.sessionAttributes(attributes2, hostConfig, originalAddress);
        if (localForward == null && (proxy = this.getProxyData(targetAddress)) != null) {
            targetAddress = this.configureProxy(proxy, targetAddress);
            proxy.clearPassword();
        }
        this.connector.connect(targetAddress, attributes2, localAddress2).addListener(listener);
        return connectFuture;
    }

    private AttributeRepository chain(AttributeRepository self, AttributeRepository parent) {
        if (self == null) {
            return Objects.requireNonNull(parent);
        }
        if (parent == null || parent == self) {
            return self;
        }
        return new JGitClientSession.ChainingAttributes(self, parent);
    }

    private AttributeRepository sessionAttributes(AttributeRepository parent, HostConfigEntry hostConfig, InetSocketAddress originalAddress) {
        HashMap<AttributeRepository.AttributeKey<Map<String, Object>>, Object> data2 = new HashMap<AttributeRepository.AttributeKey<Map<String, Object>>, Object>();
        data2.put(HOST_CONFIG_ENTRY, hostConfig);
        data2.put(ORIGINAL_REMOTE_ADDRESS, originalAddress);
        data2.put(TARGET_SERVER, new SshdSocketAddress(originalAddress));
        String preferredAuths = hostConfig.getProperty("PreferredAuthentications", this.resolveAttribute(PREFERRED_AUTHENTICATIONS));
        if (!StringUtils.isEmptyOrNull(preferredAuths)) {
            data2.put(JGitClientSession.SessionAttributes.PROPERTIES, Collections.singletonMap(CoreModuleProperties.PREFERRED_AUTHS.getName(), preferredAuths));
        }
        return new JGitClientSession.SessionAttributes(AttributeRepository.ofAttributesMap(data2), parent, this);
    }

    private ProxyData getProxyData(InetSocketAddress remoteAddress2) {
        ProxyDataFactory factory2 = this.getProxyDatabase();
        return factory2 == null ? null : factory2.get(remoteAddress2);
    }

    private InetSocketAddress configureProxy(ProxyData proxyData, InetSocketAddress remoteAddress2) {
        Proxy proxy = proxyData.getProxy();
        if (proxy.type() == Proxy.Type.DIRECT || !(proxy.address() instanceof InetSocketAddress)) {
            return remoteAddress2;
        }
        InetSocketAddress address = (InetSocketAddress)proxy.address();
        if (address.isUnresolved()) {
            address = new InetSocketAddress(address.getHostName(), address.getPort());
        }
        switch (proxy.type()) {
            case HTTP: {
                this.setClientProxyConnector(new HttpClientConnector(address, remoteAddress2, proxyData.getUser(), proxyData.getPassword()));
                return address;
            }
            case SOCKS: {
                this.setClientProxyConnector(new Socks5ClientConnector(address, remoteAddress2, proxyData.getUser(), proxyData.getPassword()));
                return address;
            }
        }
        this.log.warn(MessageFormat.format(SshdText.get().unknownProxyProtocol, proxy.type().name()));
        return remoteAddress2;
    }

    private SshFutureListener<IoConnectFuture> createConnectCompletionListener(final ConnectFuture connectFuture, final String username, final InetSocketAddress address, final HostConfigEntry hostConfig) {
        return new SshFutureListener<IoConnectFuture>(){

            @Override
            public void operationComplete(IoConnectFuture future) {
                if (future.isCanceled()) {
                    connectFuture.cancel();
                    return;
                }
                Throwable t2 = future.getException();
                if (t2 != null) {
                    connectFuture.setException(t2);
                    return;
                }
                IoSession ioSession = future.getSession();
                try {
                    JGitClientSession session2 = JGitSshClient.this.createSession(ioSession, username, address, hostConfig);
                    connectFuture.setSession(session2);
                }
                catch (RuntimeException e2) {
                    connectFuture.setException(e2);
                    ioSession.close(true);
                }
            }

            public String toString() {
                return "JGitSshClient$ConnectCompletionListener[" + username + "@" + String.valueOf(address) + "]";
            }
        };
    }

    private JGitClientSession createSession(IoSession ioSession, String username, InetSocketAddress address, HostConfigEntry hostConfig) {
        AbstractSession rawSession = AbstractSession.getSession(ioSession);
        if (!(rawSession instanceof JGitClientSession)) {
            throw new IllegalStateException("Wrong session type: " + rawSession.getClass().getCanonicalName());
        }
        JGitClientSession session2 = (JGitClientSession)rawSession;
        session2.setUsername(username);
        session2.setConnectAddress(address);
        session2.setHostConfigEntry(hostConfig);
        if (session2.getCredentialsProvider() == null) {
            session2.setCredentialsProvider(this.getCredentialsProvider());
        }
        int numberOfPasswordPrompts = this.getNumberOfPasswordPrompts(hostConfig);
        CoreModuleProperties.PASSWORD_PROMPTS.set(session2, numberOfPasswordPrompts);
        session2.setAttribute(JGitClientSession.KEY_PASSWORD_PROVIDER_FACTORY, this.getKeyPasswordProviderFactory());
        List<Path> identities = hostConfig.getIdentities().stream().map(s2 -> {
            try {
                return Paths.get(s2, new String[0]);
            }
            catch (InvalidPathException e2) {
                this.log.warn(MessageFormat.format(SshdText.get().configInvalidPath, "IdentityFile", s2), e2);
                return null;
            }
        }).filter(p -> p != null && Files.exists(p, new LinkOption[0])).collect(Collectors.toList());
        CachingKeyPairProvider ourConfiguredKeysProvider = new CachingKeyPairProvider(identities, this.keyCache);
        FilePasswordProvider passwordProvider = this.getFilePasswordProvider();
        ourConfiguredKeysProvider.setPasswordFinder(passwordProvider);
        if (hostConfig.isIdentitiesOnly()) {
            session2.setKeyIdentityProvider(ourConfiguredKeysProvider);
        } else {
            KeyIdentityProvider defaultKeysProvider = this.getKeyIdentityProvider();
            if (defaultKeysProvider instanceof AbstractResourceKeyPairProvider) {
                ((AbstractResourceKeyPairProvider)defaultKeysProvider).setPasswordFinder(passwordProvider);
            }
            CombinedKeyIdentityProvider combinedProvider = new CombinedKeyIdentityProvider(ourConfiguredKeysProvider, defaultKeysProvider);
            session2.setKeyIdentityProvider(combinedProvider);
        }
        return session2;
    }

    private int getNumberOfPasswordPrompts(HostConfigEntry hostConfig) {
        String prompts = hostConfig.getProperty("NumberOfPasswordPrompts");
        if (prompts != null) {
            int value2 = OpenSshConfigFile.positive(prompts = prompts.trim());
            if (value2 > 0) {
                return value2;
            }
            this.log.warn(MessageFormat.format(SshdText.get().configInvalidPositive, "NumberOfPasswordPrompts", prompts));
        }
        return CoreModuleProperties.PASSWORD_PROMPTS.getRequiredDefault();
    }

    public void setKeyCache(KeyCache cache2) {
        this.keyCache = cache2;
    }

    public void setProxyDatabase(ProxyDataFactory factory2) {
        this.proxyDatabase = factory2;
    }

    protected ProxyDataFactory getProxyDatabase() {
        return this.proxyDatabase;
    }

    public void setCredentialsProvider(CredentialsProvider provider2) {
        this.credentialsProvider = provider2;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setKeyPasswordProviderFactory(Supplier<KeyPasswordProvider> factory2) {
        this.keyPasswordProviderFactory = factory2;
    }

    public Supplier<KeyPasswordProvider> getKeyPasswordProviderFactory() {
        return this.keyPasswordProviderFactory;
    }

    private static class CombinedKeyIdentityProvider
    implements KeyIdentityProvider {
        private final List<KeyIdentityProvider> providers;

        public CombinedKeyIdentityProvider(KeyIdentityProvider ... providers) {
            this(Arrays.stream(providers).filter(Objects::nonNull).collect(Collectors.toList()));
        }

        public CombinedKeyIdentityProvider(List<KeyIdentityProvider> providers) {
            this.providers = providers;
        }

        @Override
        public Iterable<KeyPair> loadKeys(final SessionContext context) {
            return () -> new Iterator<KeyPair>(){
                private Iterator<KeyIdentityProvider> factories;
                private Iterator<KeyPair> current;
                private Boolean hasElement;
                {
                    this.factories = combinedKeyIdentityProvider.providers.iterator();
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public boolean hasNext() {
                    if (this.hasElement == null) ** GOTO lbl12
                    return this.hasElement;
lbl-1000:
                    // 1 sources

                    {
                        if (this.factories.hasNext()) {
                            try {
                                this.current = this.factories.next().loadKeys(context).iterator();
                            }
                            catch (IOException | GeneralSecurityException e) {
                                throw new RuntimeException(e);
                            }
                        } else {
                            this.current = null;
                            this.hasElement = Boolean.FALSE;
                            return false;
                        }
lbl12:
                        // 2 sources

                        ** while (this.current == null || !this.current.hasNext())
                    }
lbl13:
                    // 1 sources

                    this.hasElement = Boolean.TRUE;
                    return true;
                }

                @Override
                public KeyPair next() {
                    KeyPair result2;
                    if (this.hasElement == null && !this.hasNext() || !this.hasElement.booleanValue()) {
                        throw new NoSuchElementException();
                    }
                    this.hasElement = null;
                    try {
                        result2 = this.current.next();
                    }
                    catch (NoSuchElementException e2) {
                        result2 = null;
                    }
                    return result2;
                }
            };
        }
    }

    private static class JGitSessionFactory
    extends SessionFactory {
        public JGitSessionFactory(JGitSshClient client2) {
            super(client2);
        }

        @Override
        protected ClientSessionImpl doCreateSession(IoSession ioSession) throws Exception {
            return new JGitClientSession(this.getClient(), ioSession);
        }
    }
}

