/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.TreeMap;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.sshd.JGitHostConfigEntry;
import org.eclipse.jgit.transport.SshConfigStore;
import org.eclipse.jgit.transport.SshSessionFactory;

public class JGitSshConfig
implements HostConfigEntryResolver {
    private final SshConfigStore configFile;

    public JGitSshConfig(SshConfigStore store2) {
        this.configFile = store2;
    }

    @Override
    public HostConfigEntry resolveEffectiveHost(String host2, int port2, SocketAddress localAddress2, String username, String proxyJump, AttributeRepository attributes2) throws IOException {
        String user;
        SshConfigStore.HostConfig entry = this.configFile == null ? SshConfigStore.EMPTY_CONFIG : this.configFile.lookup(host2, port2, username);
        JGitHostConfigEntry config2 = new JGitHostConfigEntry();
        TreeMap<String, String> allOptions = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        allOptions.putAll(entry.getOptions());
        entry.getMultiValuedOptions().entrySet().stream().forEach(e2 -> {
            String string = allOptions.put((String)e2.getKey(), String.join((CharSequence)",", (Iterable)e2.getValue()));
        });
        config2.setProperties(allOptions);
        config2.setMultiValuedOptions(entry.getMultiValuedOptions());
        String hostName = entry.getValue("HostName");
        if (hostName == null || hostName.isEmpty()) {
            hostName = host2;
        }
        config2.setHostName(hostName);
        config2.setProperty("HostName", hostName);
        config2.setHost(SshdSocketAddress.isIPv6Address(hostName) ? "" : hostName);
        String string = user = username != null && !username.isEmpty() ? username : entry.getValue("User");
        if (user == null || user.isEmpty()) {
            user = SshSessionFactory.getLocalUserName();
        }
        config2.setUsername(user);
        config2.setProperty("User", user);
        int p = port2 >= 0 ? port2 : OpenSshConfigFile.positive(entry.getValue("Port"));
        config2.setPort(p >= 0 ? p : 22);
        config2.setProperty("Port", Integer.toString(config2.getPort()));
        config2.setIdentities(entry.getValues("IdentityFile"));
        config2.setIdentitiesOnly(OpenSshConfigFile.flag(entry.getValue("IdentitiesOnly")));
        return config2;
    }
}

