/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationCanceledException;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class JGitUserInteraction
implements UserInteraction {
    private final CredentialsProvider provider;
    private final Map<Session, SessionListener> ongoing = new ConcurrentHashMap<Session, SessionListener>();

    public JGitUserInteraction(CredentialsProvider provider2) {
        this.provider = provider2;
    }

    @Override
    public boolean isInteractionAllowed(ClientSession session2) {
        return this.provider != null && this.provider.isInteractive();
    }

    @Override
    public String[] interactive(ClientSession session2, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
        boolean hidden;
        ArrayList<CredentialItem> items2 = new ArrayList<CredentialItem>();
        int numberOfHiddenInputs = 0;
        int i3 = 0;
        while (i3 < prompt.length) {
            boolean bl = hidden = i3 < echo.length && !echo[i3];
            if (hidden) {
                ++numberOfHiddenInputs;
            }
            ++i3;
        }
        if (name != null && !name.isEmpty()) {
            items2.add(new CredentialItem.InformationalMessage(name));
        }
        if (instruction != null && !instruction.isEmpty()) {
            items2.add(new CredentialItem.InformationalMessage(instruction));
        }
        i3 = 0;
        while (i3 < prompt.length) {
            boolean bl = hidden = i3 < echo.length && !echo[i3];
            if (hidden && numberOfHiddenInputs == 1) {
                items2.add(new CredentialItem.Password());
            } else {
                items2.add(new CredentialItem.StringType(prompt[i3], hidden));
            }
            ++i3;
        }
        if (items2.isEmpty()) {
            return prompt;
        }
        URIish uri2 = JGitUserInteraction.toURI(session2.getUsername(), (InetSocketAddress)session2.getConnectAddress());
        if (numberOfHiddenInputs > 0) {
            SessionListener listener = this.ongoing.get(session2);
            if (listener != null) {
                this.provider.reset(uri2);
            } else {
                listener = new SessionAuthMarker(this.ongoing);
                this.ongoing.put(session2, listener);
                session2.addSessionListener(listener);
            }
        }
        if (this.provider.get(uri2, items2)) {
            return (String[])items2.stream().map(i2 -> {
                if (i2 instanceof CredentialItem.Password) {
                    return new String(((CredentialItem.Password)i2).getValue());
                }
                if (i2 instanceof CredentialItem.StringType) {
                    return ((CredentialItem.StringType)i2).getValue();
                }
                return null;
            }).filter(s2 -> s2 != null).toArray(String[]::new);
        }
        throw new AuthenticationCanceledException();
    }

    @Override
    public String resolveAuthPasswordAttempt(ClientSession session2) throws Exception {
        String[] results2 = this.interactive(session2, null, null, "", new String[]{SshdText.get().passwordPrompt}, new boolean[1]);
        return results2 == null || results2.length == 0 ? null : results2[0];
    }

    @Override
    public String getUpdatedPassword(ClientSession session2, String prompt, String lang) {
        return null;
    }

    public static URIish toURI(String userName, InetSocketAddress remote) {
        String host2 = remote.getHostString();
        int port2 = remote.getPort();
        return new URIish().setScheme("ssh").setHost(host2).setPort(port2).setUser(userName);
    }

    private static class SessionAuthMarker
    implements SessionListener {
        private final Map<Session, SessionListener> registered;

        public SessionAuthMarker(Map<Session, SessionListener> registered) {
            this.registered = registered;
        }

        @Override
        public void sessionEvent(Session session2, SessionListener.Event event) {
            if (event == SessionListener.Event.Authenticated) {
                session2.removeSessionListener(this);
                this.registered.remove(session2, this);
            }
        }

        @Override
        public void sessionClosed(Session session2) {
            session2.removeSessionListener(this);
            this.registered.remove(session2, this);
        }
    }
}

