/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sshd.client.config.hosts.HostPatternValue;
import org.apache.sshd.client.config.hosts.HostPatternsHolder;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.config.hosts.KnownHostHashValue;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnownHostEntryReader {
    private static final Logger LOG = LoggerFactory.getLogger(KnownHostEntryReader.class);

    private KnownHostEntryReader() {
    }

    public static List<KnownHostEntry> readFromFile(Path path2) throws IOException {
        ArrayList<KnownHostEntry> result2 = new ArrayList<KnownHostEntry>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader r = Files.newBufferedReader(path2, StandardCharsets.UTF_8);){
            r.lines().forEachOrdered(l -> {
                if (l == null) {
                    return;
                }
                String line = KnownHostEntryReader.clean(l);
                if (line.isEmpty()) {
                    return;
                }
                try {
                    KnownHostEntry entry = KnownHostEntryReader.parseHostEntry(line);
                    if (entry != null) {
                        result2.add(entry);
                    } else {
                        LOG.warn(MessageFormat.format(SshdText.get().knownHostsInvalidLine, path2, line));
                    }
                }
                catch (RuntimeException e2) {
                    LOG.warn(MessageFormat.format(SshdText.get().knownHostsInvalidLine, path2, line), e2);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result2;
    }

    private static String clean(String line) {
        int i2 = line.indexOf(35);
        return i2 < 0 ? line.trim() : line.substring(0, i2).trim();
    }

    static KnownHostEntry parseHostEntry(String line) {
        KnownHostEntry entry = new KnownHostEntry();
        entry.setConfigLine(line);
        String tmp = line;
        int i2 = 0;
        if (tmp.charAt(0) == '@') {
            i2 = tmp.indexOf(32, 1);
            if (i2 < 0) {
                return null;
            }
            entry.setMarker(tmp.substring(1, i2));
            tmp = tmp.substring(i2 + 1).trim();
        }
        if ((i2 = tmp.indexOf(32)) < 0) {
            return null;
        }
        if (tmp.charAt(0) == '|') {
            KnownHostHashValue hash = KnownHostHashValue.parse(tmp.substring(0, i2));
            if (hash == null) {
                return null;
            }
            entry.setHashedEntry(hash);
            entry.setPatterns(null);
        } else {
            Collection<HostPatternValue> patterns2 = KnownHostEntryReader.parsePatterns(tmp.substring(0, i2));
            if (patterns2 == null || patterns2.isEmpty()) {
                return null;
            }
            entry.setHashedEntry(null);
            entry.setPatterns(patterns2);
        }
        tmp = tmp.substring(i2 + 1).trim();
        AuthorizedKeyEntry key2 = PublicKeyEntry.parsePublicKeyEntry(new AuthorizedKeyEntry(), tmp);
        if (key2 == null) {
            return null;
        }
        entry.setKeyEntry(key2);
        return entry;
    }

    private static Collection<HostPatternValue> parsePatterns(String text) {
        if (text.isEmpty()) {
            return null;
        }
        List items2 = Arrays.stream(text.split(",")).filter(item -> item != null && !item.isEmpty()).map(item -> {
            if ('[' == item.charAt(0)) {
                return item;
            }
            int firstColon = item.indexOf(58);
            if (firstColon < 0) {
                return item;
            }
            int secondColon = item.indexOf(58, firstColon + 1);
            if (secondColon > 0) {
                return item;
            }
            return "[" + item.substring(0, firstColon) + "]" + item.substring(firstColon);
        }).collect(Collectors.toList());
        return items2.isEmpty() ? null : HostPatternsHolder.parsePatterns(items2);
    }
}

