/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.sshd.client.config.hosts.KnownHostDigest;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.config.hosts.KnownHostHashValue;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.config.keys.UnsupportedSshPublicKey;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.transport.sshd.JGitUserInteraction;
import org.eclipse.jgit.internal.transport.sshd.KnownHostEntryReader;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.ServerKeyDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSshServerKeyDatabase
implements ServerKeyDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSshServerKeyDatabase.class);
    private static final String MARKER_REVOKED = "revoked";
    private static final String MARKER_CA = "cert-authority";
    private final boolean askAboutNewFile;
    private final Map<Path, HostKeyFile> knownHostsFiles = new ConcurrentHashMap<Path, HostKeyFile>();
    private final List<HostKeyFile> defaultFiles = new ArrayList<HostKeyFile>();
    private Random prng;

    public OpenSshServerKeyDatabase(boolean askAboutNewFile, List<Path> defaultFiles) {
        if (defaultFiles != null) {
            for (Path file2 : defaultFiles) {
                HostKeyFile newFile = new HostKeyFile(file2);
                this.knownHostsFiles.put(file2, newFile);
                this.defaultFiles.add(newFile);
            }
        }
        this.askAboutNewFile = askAboutNewFile;
    }

    private List<HostKeyFile> getFilesToUse(@NonNull ServerKeyDatabase.Configuration config2) {
        List<HostKeyFile> filesToUse = this.defaultFiles;
        List<HostKeyFile> userFiles = this.addUserHostKeyFiles(config2.getUserKnownHostsFiles());
        if (!userFiles.isEmpty()) {
            filesToUse = userFiles;
        }
        return filesToUse;
    }

    @Override
    public List<PublicKey> lookup(@NonNull String connectAddress, @NonNull InetSocketAddress remoteAddress2, @NonNull ServerKeyDatabase.Configuration config2) {
        List<HostKeyFile> filesToUse = this.getFilesToUse(config2);
        ArrayList<PublicKey> result2 = new ArrayList<PublicKey>();
        Collection<SshdSocketAddress> candidates = this.getCandidates(connectAddress, remoteAddress2);
        for (HostKeyFile file2 : filesToUse) {
            Iterator iterator2 = file2.get().iterator();
            block1: while (iterator2.hasNext()) {
                KnownHostsServerKeyVerifier.HostEntryPair current = (KnownHostsServerKeyVerifier.HostEntryPair)iterator2.next();
                KnownHostEntry entry = current.getHostEntry();
                if (current.getServerKey() instanceof UnsupportedSshPublicKey || OpenSshServerKeyDatabase.isRevoked(entry) || OpenSshServerKeyDatabase.isCertificateAuthority(entry)) continue;
                for (SshdSocketAddress host2 : candidates) {
                    if (!entry.isHostMatch(host2.getHostName(), host2.getPort())) continue;
                    result2.add(current.getServerKey());
                    continue block1;
                }
            }
        }
        return result2;
    }

    @Override
    public boolean accept(@NonNull String connectAddress, @NonNull InetSocketAddress remoteAddress2, @NonNull PublicKey serverKey, @NonNull ServerKeyDatabase.Configuration config2, CredentialsProvider provider2) {
        List<HostKeyFile> filesToUse = this.getFilesToUse(config2);
        AskUser ask = new AskUser(config2, provider2);
        KnownHostsServerKeyVerifier.HostEntryPair[] modified = new KnownHostsServerKeyVerifier.HostEntryPair[1];
        Path path2 = null;
        Collection<SshdSocketAddress> candidates = this.getCandidates(connectAddress, remoteAddress2);
        for (HostKeyFile file2 : filesToUse) {
            KnownHostsServerKeyVerifier.HostEntryPair lastModified = modified[0];
            try {
                if (this.find(candidates, serverKey, (List<KnownHostsServerKeyVerifier.HostEntryPair>)file2.get(), modified)) {
                    return true;
                }
            }
            catch (RevokedKeyException e2) {
                ask.revokedKey(remoteAddress2, serverKey, file2.getPath());
                return false;
            }
            if (modified[0] == lastModified) continue;
            path2 = file2.getPath();
        }
        if (serverKey instanceof OpenSshCertificate) {
            return false;
        }
        if (modified[0] != null) {
            AskUser.ModifiedKeyHandling toDo = ask.acceptModifiedServerKey(remoteAddress2, modified[0].getServerKey(), serverKey, path2);
            if (toDo == AskUser.ModifiedKeyHandling.ALLOW_AND_STORE) {
                if (modified[0].getServerKey() instanceof UnsupportedSshPublicKey) {
                    this.addKeyToFile(filesToUse.get(0), candidates, serverKey, ask, config2);
                } else {
                    try {
                        this.updateModifiedServerKey(serverKey, modified[0], path2);
                        this.knownHostsFiles.get(path2).resetReloadAttributes();
                    }
                    catch (IOException e3) {
                        LOG.warn(MessageFormat.format(SshdText.get().knownHostsCouldNotUpdate, path2));
                    }
                }
            }
            return toDo != AskUser.ModifiedKeyHandling.DENY;
        }
        if (ask.acceptUnknownKey(remoteAddress2, serverKey)) {
            if (!filesToUse.isEmpty()) {
                this.addKeyToFile(filesToUse.get(0), candidates, serverKey, ask, config2);
            }
            return true;
        }
        return false;
    }

    private static boolean isRevoked(KnownHostEntry entry) {
        return MARKER_REVOKED.equals(entry.getMarker());
    }

    private static boolean isCertificateAuthority(KnownHostEntry entry) {
        return MARKER_CA.equals(entry.getMarker());
    }

    private boolean find(Collection<SshdSocketAddress> candidates, PublicKey serverKey, List<KnownHostsServerKeyVerifier.HostEntryPair> entries2, KnownHostsServerKeyVerifier.HostEntryPair[] modified) throws RevokedKeyException {
        PublicKey keyToCheck = serverKey;
        boolean isCert = false;
        String keyType = KeyUtils.getKeyType(keyToCheck);
        String modifiedKeyType = null;
        if (modified[0] != null) {
            modifiedKeyType = modified[0].getHostEntry().getKeyEntry().getKeyType();
        }
        if (serverKey instanceof OpenSshCertificate) {
            keyToCheck = ((OpenSshCertificate)serverKey).getCaPubKey();
            isCert = true;
        }
        for (KnownHostsServerKeyVerifier.HostEntryPair current : entries2) {
            String thisKeyType;
            KnownHostEntry entry = current.getHostEntry();
            if (!candidates.stream().anyMatch(host2 -> entry.isHostMatch(host2.getHostName(), host2.getPort()))) continue;
            boolean revoked = OpenSshServerKeyDatabase.isRevoked(entry);
            boolean haveCert = OpenSshServerKeyDatabase.isCertificateAuthority(entry);
            if (KeyUtils.compareKeys(keyToCheck, current.getServerKey())) {
                if (revoked) {
                    throw new RevokedKeyException();
                }
                if (haveCert == isCert) {
                    modified[0] = null;
                    return true;
                }
            }
            if (haveCert != isCert || haveCert || revoked) continue;
            if (modifiedKeyType == null) {
                modified[0] = current;
                modifiedKeyType = entry.getKeyEntry().getKeyType();
                continue;
            }
            if (keyType.equals(modifiedKeyType) || !OpenSshServerKeyDatabase.isBetterMatch(keyType, thisKeyType = entry.getKeyEntry().getKeyType(), modifiedKeyType)) continue;
            modified[0] = current;
            modifiedKeyType = keyType;
        }
        return false;
    }

    private static boolean isBetterMatch(String keyType, String thisType, String modifiedType) {
        if (keyType.equals(thisType)) {
            return true;
        }
        if (!keyType.startsWith("ecdsa") || !thisType.startsWith("ecdsa")) {
            return false;
        }
        return !modifiedType.startsWith("ecdsa");
    }

    private List<HostKeyFile> addUserHostKeyFiles(List<String> fileNames) {
        if (fileNames == null || fileNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HostKeyFile> userFiles = new ArrayList<HostKeyFile>();
        for (String name : fileNames) {
            try {
                Path path2 = Paths.get(name, new String[0]);
                HostKeyFile file2 = this.knownHostsFiles.computeIfAbsent(path2, p -> new HostKeyFile(path2));
                userFiles.add(file2);
            }
            catch (InvalidPathException e2) {
                LOG.warn(MessageFormat.format(SshdText.get().knownHostsInvalidPath, name));
            }
        }
        return userFiles;
    }

    private void addKeyToFile(HostKeyFile file2, Collection<SshdSocketAddress> candidates, PublicKey serverKey, AskUser ask, ServerKeyDatabase.Configuration config2) {
        Path path2 = file2.getPath();
        try {
            if (Files.exists(path2, new LinkOption[0]) || !this.askAboutNewFile || ask.createNewFile(path2)) {
                this.updateKnownHostsFile(candidates, serverKey, path2, config2);
                file2.resetReloadAttributes();
            }
        }
        catch (Exception e2) {
            LOG.warn(MessageFormat.format(SshdText.get().knownHostsCouldNotUpdate, path2), e2);
        }
    }

    private void updateKnownHostsFile(Collection<SshdSocketAddress> candidates, PublicKey serverKey, Path path2, ServerKeyDatabase.Configuration config2) throws Exception {
        String newEntry = this.createHostKeyLine(candidates, serverKey, config2);
        if (newEntry == null) {
            return;
        }
        LockFile lock = new LockFile(path2.toFile());
        if (lock.lockForAppend()) {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(lock.getOutputStream(), StandardCharsets.UTF_8));){
                    writer.newLine();
                    writer.write(newEntry);
                    writer.newLine();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                lock.commit();
            }
            catch (IOException e2) {
                lock.unlock();
                throw e2;
            }
        }
        LOG.warn(MessageFormat.format(SshdText.get().knownHostsFileLockedUpdate, path2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateModifiedServerKey(PublicKey serverKey, KnownHostsServerKeyVerifier.HostEntryPair entry, Path path2) throws IOException {
        KnownHostEntry hostEntry = entry.getHostEntry();
        String oldLine = hostEntry.getConfigLine();
        if (oldLine == null) {
            return;
        }
        String newLine = this.updateHostKeyLine(oldLine, serverKey);
        if (newLine == null) return;
        if (newLine.isEmpty()) {
            return;
        }
        if (oldLine.isEmpty()) return;
        if (newLine.equals(oldLine)) {
            return;
        }
        LockFile lock = new LockFile(path2.toFile());
        if (!lock.lock()) {
            LOG.warn(MessageFormat.format(SshdText.get().knownHostsFileLockedUpdate, path2));
            return;
        }
        try {
            block22: {
                Throwable throwable = null;
                Object var9_11 = null;
                try {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(lock.getOutputStream(), StandardCharsets.UTF_8));
                    try {
                        try (BufferedReader reader2 = Files.newBufferedReader(path2, StandardCharsets.UTF_8);){
                            String line;
                            boolean done = false;
                            while ((line = reader2.readLine()) != null) {
                                String toWrite = line;
                                if (!done) {
                                    String toTest;
                                    int pos = line.indexOf(35);
                                    String string = toTest = pos < 0 ? line : line.substring(0, pos);
                                    if (toTest.trim().equals(oldLine)) {
                                        toWrite = newLine;
                                        done = true;
                                    }
                                }
                                writer.write(toWrite);
                                writer.newLine();
                            }
                        }
                        if (writer == null) break block22;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (writer == null) throw throwable;
                        writer.close();
                        throw throwable;
                    }
                    writer.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            lock.commit();
            return;
        }
        catch (IOException e2) {
            lock.unlock();
            throw e2;
        }
    }

    private int parsePort(String s2) {
        try {
            return Integer.parseInt(s2);
        }
        catch (NumberFormatException e2) {
            return -1;
        }
    }

    private SshdSocketAddress toSshdSocketAddress(@NonNull String address) {
        String host2 = null;
        int port2 = 22;
        if ('[' == address.charAt(0)) {
            int end2 = address.indexOf(93);
            if (end2 <= 1) {
                return null;
            }
            host2 = address.substring(1, end2);
            if (end2 < address.length() - 1 && ':' == address.charAt(end2 + 1)) {
                port2 = this.parsePort(address.substring(end2 + 2));
            }
        } else {
            int i2 = address.lastIndexOf(58);
            if (i2 > 0) {
                port2 = this.parsePort(address.substring(i2 + 1));
                host2 = address.substring(0, i2);
            } else {
                host2 = address;
            }
        }
        if (port2 < 0 || port2 > 65535) {
            return null;
        }
        return new SshdSocketAddress(host2, port2);
    }

    private Collection<SshdSocketAddress> getCandidates(@NonNull String connectAddress, @NonNull InetSocketAddress remoteAddress2) {
        SshdSocketAddress ip;
        TreeSet<SocketAddress> candidates = new TreeSet<SocketAddress>(SshdSocketAddress.BY_HOST_AND_PORT);
        candidates.add(SshdSocketAddress.toSshdSocketAddress(remoteAddress2));
        SshdSocketAddress address = this.toSshdSocketAddress(connectAddress);
        if (address != null) {
            candidates.add(address);
        }
        ArrayList<SshdSocketAddress> result2 = new ArrayList<SshdSocketAddress>();
        result2.addAll(candidates);
        if (!remoteAddress2.isUnresolved() && candidates.add(ip = new SshdSocketAddress(remoteAddress2.getAddress().getHostAddress(), remoteAddress2.getPort()))) {
            result2.add(ip);
        }
        return result2;
    }

    private String createHostKeyLine(Collection<SshdSocketAddress> patterns2, PublicKey key2, ServerKeyDatabase.Configuration config2) throws Exception {
        StringBuilder result2 = new StringBuilder();
        HashSet<CallSite> knownNames = new HashSet<CallSite>();
        if (config2.getHashKnownHosts()) {
            KnownHostDigest digester = KnownHostDigest.SHA1;
            Mac mac = (Mac)digester.create();
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            byte[] salt = new byte[mac.getDefaultBlockSize()];
            if (!patterns2.isEmpty()) {
                SshdSocketAddress address = patterns2.iterator().next();
                this.prng.nextBytes(salt);
                KnownHostHashValue.append(result2, digester, salt, KnownHostHashValue.calculateHashValue(address.getHostName(), address.getPort(), mac, salt));
            }
        } else {
            for (SshdSocketAddress address : patterns2) {
                String tgt = address.getHostName() + ":" + address.getPort();
                if (!knownNames.add((CallSite)((Object)tgt))) continue;
                if (result2.length() > 0) {
                    result2.append(',');
                }
                KnownHostHashValue.appendHostPattern(result2, address.getHostName(), address.getPort());
            }
        }
        result2.append(' ');
        PublicKeyEntry.appendPublicKeyEntry(result2, key2);
        return result2.toString();
    }

    private String updateHostKeyLine(String line, PublicKey newKey) throws IOException {
        int pos = line.indexOf(32);
        if (pos > 0 && line.charAt(0) == '@') {
            pos = line.indexOf(32, pos + 1);
        }
        if (pos < 0) {
            return null;
        }
        StringBuilder result2 = new StringBuilder(line.substring(0, pos + 1));
        PublicKeyEntry.appendPublicKeyEntry(result2, newKey);
        return result2.toString();
    }

    private static class AskUser {
        @NonNull
        private final ServerKeyDatabase.Configuration config;
        private final CredentialsProvider provider;

        public AskUser(@NonNull ServerKeyDatabase.Configuration config2, CredentialsProvider provider2) {
            this.config = config2;
            this.provider = provider2;
        }

        private static boolean askUser(CredentialsProvider provider2, URIish uri2, String prompt, String ... messages) {
            ArrayList<CredentialItem> items2 = new ArrayList<CredentialItem>(messages.length + 1);
            String[] stringArray = messages;
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                String message = stringArray[n2];
                items2.add(new CredentialItem.InformationalMessage(message));
                ++n2;
            }
            if (prompt != null) {
                CredentialItem.YesNoType answer = new CredentialItem.YesNoType(prompt);
                items2.add(answer);
                return provider2.get(uri2, items2) && answer.getValue();
            }
            return provider2.get(uri2, items2);
        }

        private Check checkMode(SocketAddress remoteAddress2, boolean changed) {
            if (!(remoteAddress2 instanceof InetSocketAddress)) {
                return Check.DENY;
            }
            switch (this.config.getStrictHostKeyChecking()) {
                case REQUIRE_MATCH: {
                    return Check.DENY;
                }
                case ACCEPT_ANY: {
                    return Check.ALLOW;
                }
                case ACCEPT_NEW: {
                    return changed ? Check.DENY : Check.ALLOW;
                }
            }
            return this.provider == null ? Check.DENY : Check.ASK;
        }

        public void revokedKey(SocketAddress remoteAddress2, PublicKey serverKey, Path path2) {
            if (this.provider == null) {
                return;
            }
            InetSocketAddress remote = (InetSocketAddress)remoteAddress2;
            boolean isCert = serverKey instanceof OpenSshCertificate;
            PublicKey keyToReport = isCert ? ((OpenSshCertificate)serverKey).getCaPubKey() : serverKey;
            URIish uri2 = JGitUserInteraction.toURI(this.config.getUsername(), remote);
            String sha256 = KeyUtils.getFingerPrint((Factory<? extends Digest>)BuiltinDigests.sha256, keyToReport);
            String md5 = KeyUtils.getFingerPrint((Factory<? extends Digest>)BuiltinDigests.md5, keyToReport);
            String keyAlgorithm = keyToReport.getAlgorithm();
            String msg = isCert ? SshdText.get().knownHostsRevokedCertificateMsg : SshdText.get().knownHostsRevokedKeyMsg;
            AskUser.askUser(this.provider, uri2, null, MessageFormat.format(msg, remote.getHostString(), path2), MessageFormat.format(SshdText.get().knownHostsKeyFingerprints, keyAlgorithm), md5, sha256);
        }

        public boolean acceptUnknownKey(SocketAddress remoteAddress2, PublicKey serverKey) {
            Check check2 = this.checkMode(remoteAddress2, false);
            if (check2 != Check.ASK) {
                return check2 == Check.ALLOW;
            }
            InetSocketAddress remote = (InetSocketAddress)remoteAddress2;
            String sha256 = KeyUtils.getFingerPrint((Factory<? extends Digest>)BuiltinDigests.sha256, serverKey);
            String md5 = KeyUtils.getFingerPrint((Factory<? extends Digest>)BuiltinDigests.md5, serverKey);
            String keyAlgorithm = serverKey.getAlgorithm();
            String remoteHost2 = remote.getHostString();
            URIish uri2 = JGitUserInteraction.toURI(this.config.getUsername(), remote);
            String prompt = SshdText.get().knownHostsUnknownKeyPrompt;
            return AskUser.askUser(this.provider, uri2, prompt, MessageFormat.format(SshdText.get().knownHostsUnknownKeyMsg, remoteHost2), MessageFormat.format(SshdText.get().knownHostsKeyFingerprints, keyAlgorithm), md5, sha256);
        }

        public ModifiedKeyHandling acceptModifiedServerKey(InetSocketAddress remoteAddress2, PublicKey expected, PublicKey actual, Path path2) {
            Check check2 = this.checkMode(remoteAddress2, true);
            if (check2 == Check.ALLOW) {
                return ModifiedKeyHandling.ALLOW;
            }
            String keyAlgorithm = actual.getAlgorithm();
            String remoteHost2 = remoteAddress2.getHostString();
            URIish uri2 = JGitUserInteraction.toURI(this.config.getUsername(), remoteAddress2);
            ArrayList<String> messages = new ArrayList<String>();
            String warning = MessageFormat.format(SshdText.get().knownHostsModifiedKeyWarning, keyAlgorithm, expected.getAlgorithm(), remoteHost2, KeyUtils.getFingerPrint((Factory<? extends Digest>)BuiltinDigests.md5, expected), KeyUtils.getFingerPrint((Factory<? extends Digest>)BuiltinDigests.sha256, expected), KeyUtils.getFingerPrint((Factory<? extends Digest>)BuiltinDigests.md5, actual), KeyUtils.getFingerPrint((Factory<? extends Digest>)BuiltinDigests.sha256, actual));
            messages.addAll(Arrays.asList(warning.split("\n")));
            if (check2 == Check.DENY) {
                if (this.provider != null) {
                    messages.add(MessageFormat.format(SshdText.get().knownHostsModifiedKeyDenyMsg, path2));
                    AskUser.askUser(this.provider, uri2, null, messages.toArray(new String[0]));
                }
                return ModifiedKeyHandling.DENY;
            }
            ArrayList<CredentialItem> items2 = new ArrayList<CredentialItem>(messages.size() + 2);
            for (String message : messages) {
                items2.add(new CredentialItem.InformationalMessage(message));
            }
            CredentialItem.YesNoType proceed = new CredentialItem.YesNoType(SshdText.get().knownHostsModifiedKeyAcceptPrompt);
            CredentialItem.YesNoType store2 = new CredentialItem.YesNoType(SshdText.get().knownHostsModifiedKeyStorePrompt);
            items2.add(proceed);
            items2.add(store2);
            if (this.provider.get(uri2, items2) && proceed.getValue()) {
                return store2.getValue() ? ModifiedKeyHandling.ALLOW_AND_STORE : ModifiedKeyHandling.ALLOW;
            }
            return ModifiedKeyHandling.DENY;
        }

        public boolean createNewFile(Path path2) {
            if (this.provider == null) {
                return false;
            }
            URIish uri2 = new URIish().setPath(path2.toString());
            return AskUser.askUser(this.provider, uri2, MessageFormat.format(SshdText.get().knownHostsUserAskCreationPrompt, path2), MessageFormat.format(SshdText.get().knownHostsUserAskCreationMsg, path2));
        }

        private static enum Check {
            ASK,
            DENY,
            ALLOW;

        }

        public static enum ModifiedKeyHandling {
            DENY,
            ALLOW,
            ALLOW_AND_STORE;

        }
    }

    private static class HostKeyFile
    extends ModifiableFileWatcher
    implements Supplier<List<KnownHostsServerKeyVerifier.HostEntryPair>> {
        private List<KnownHostsServerKeyVerifier.HostEntryPair> entries = Collections.emptyList();

        public HostKeyFile(Path path2) {
            super(path2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<KnownHostsServerKeyVerifier.HostEntryPair> get() {
            Path path2 = this.getPath();
            HostKeyFile hostKeyFile = this;
            synchronized (hostKeyFile) {
                try {
                    if (this.checkReloadRequired()) {
                        this.entries = this.reload(this.getPath());
                    }
                }
                catch (IOException e2) {
                    LOG.warn(MessageFormat.format(SshdText.get().knownHostsFileReadFailed, path2));
                }
                return Collections.unmodifiableList(this.entries);
            }
        }

        private List<KnownHostsServerKeyVerifier.HostEntryPair> reload(Path path2) throws IOException {
            try {
                List<KnownHostEntry> rawEntries = KnownHostEntryReader.readFromFile(path2);
                this.updateReloadAttributes();
                if (rawEntries == null || rawEntries.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<KnownHostsServerKeyVerifier.HostEntryPair> newEntries = new ArrayList<KnownHostsServerKeyVerifier.HostEntryPair>();
                for (KnownHostEntry entry : rawEntries) {
                    AuthorizedKeyEntry keyPart = entry.getKeyEntry();
                    if (keyPart == null) continue;
                    try {
                        PublicKey serverKey = keyPart.resolvePublicKey(null, PublicKeyEntryResolver.UNSUPPORTED);
                        if (serverKey == null) {
                            LOG.warn(MessageFormat.format(SshdText.get().knownHostsUnknownKeyType, path2, entry.getConfigLine()));
                            continue;
                        }
                        newEntries.add(new KnownHostsServerKeyVerifier.HostEntryPair(entry, serverKey));
                    }
                    catch (GeneralSecurityException e2) {
                        LOG.warn(MessageFormat.format(SshdText.get().knownHostsInvalidLine, path2, entry.getConfigLine()));
                    }
                }
                return newEntries;
            }
            catch (FileNotFoundException | NoSuchFileException e3) {
                this.resetReloadAttributes();
                return Collections.emptyList();
            }
        }
    }

    private static class RevokedKeyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private RevokedKeyException() {
        }
    }
}

