/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.core.CoreModuleProperties;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;

public class PasswordProviderWrapper
implements FilePasswordProvider {
    private static final AttributeRepository.AttributeKey<PerSessionState> STATE = new AttributeRepository.AttributeKey();
    private final Supplier<KeyPasswordProvider> factory;
    private PerSessionState noSessionState;

    public PasswordProviderWrapper(@NonNull Supplier<KeyPasswordProvider> factory2) {
        this.factory = factory2;
    }

    private PerSessionState getState(SessionContext context) {
        PerSessionState state;
        PerSessionState perSessionState = state = context != null ? context.getAttribute(STATE) : this.noSessionState;
        if (state == null) {
            state = new PerSessionState();
            state.delegate = this.factory.get();
            state.delegate.setAttempts(CoreModuleProperties.PASSWORD_PROMPTS.getRequiredDefault());
            if (context != null) {
                context.setAttribute(STATE, state);
            } else {
                this.noSessionState = state;
            }
        }
        return state;
    }

    @Override
    public String getPassword(SessionContext session2, NamedResource resource2, int attemptIndex) throws IOException {
        String key2 = resource2.getName();
        PerSessionState state = this.getState(session2);
        int attempt = state.counts.computeIfAbsent(key2, k2 -> new AtomicInteger()).get();
        char[] passphrase = state.delegate.getPassphrase(this.toUri(key2), attempt);
        if (passphrase == null) {
            return null;
        }
        try {
            String string = new String(passphrase);
            return string;
        }
        finally {
            Arrays.fill(passphrase, '\u0000');
        }
    }

    @Override
    public FilePasswordProvider.ResourceDecodeResult handleDecodeAttemptResult(SessionContext session2, NamedResource resource2, int retryIndex, String password, Exception err) throws IOException, GeneralSecurityException {
        String key2 = resource2.getName();
        PerSessionState state = this.getState(session2);
        AtomicInteger count2 = state.counts.get(key2);
        int numberOfAttempts = count2 == null ? 0 : count2.incrementAndGet();
        FilePasswordProvider.ResourceDecodeResult result2 = null;
        try {
            result2 = state.delegate.keyLoaded(this.toUri(key2), numberOfAttempts, err) ? FilePasswordProvider.ResourceDecodeResult.RETRY : FilePasswordProvider.ResourceDecodeResult.TERMINATE;
        }
        finally {
            if (result2 != FilePasswordProvider.ResourceDecodeResult.RETRY) {
                state.counts.remove(key2);
            }
        }
        return result2;
    }

    private URIish toUri(String resourceKey) {
        try {
            return new URIish(resourceKey);
        }
        catch (URISyntaxException e2) {
            return new URIish().setPath(resourceKey);
        }
    }

    private static class PerSessionState {
        Map<String, AtomicInteger> counts = new ConcurrentHashMap<String, AtomicInteger>();
        KeyPasswordProvider delegate;

        private PerSessionState() {
        }
    }
}

