/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.agent;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.agent.SshAgentClient;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;

public class JGitSshAgentFactory
implements SshAgentFactory {
    @NonNull
    private final ConnectorFactory factory;
    private final File homeDir;

    public JGitSshAgentFactory(@NonNull ConnectorFactory factory2, File homeDir) {
        this.factory = factory2;
        this.homeDir = homeDir;
    }

    @Override
    public List<ChannelFactory> getChannelForwardingFactories(FactoryManager manager) {
        return Collections.emptyList();
    }

    @Override
    public SshAgent createClient(Session session2, FactoryManager manager) throws IOException {
        String identityAgent = null;
        if (session2 instanceof JGitClientSession) {
            HostConfigEntry hostConfig = ((JGitClientSession)session2).getHostConfigEntry();
            identityAgent = hostConfig.getProperty("IdentityAgent", null);
        }
        if ("none".equals(identityAgent)) {
            return null;
        }
        return new SshAgentClient(this.factory.create(identityAgent, this.homeDir));
    }

    @Override
    public SshAgentServer createServer(ConnectionService service) throws IOException {
        return null;
    }
}

