/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.pkcs11;

import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.FailedLoginException;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentKeyConstraint;
import org.apache.sshd.client.auth.pubkey.KeyAgentIdentity;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.sshd.pkcs11.SecurityCallback;
import org.eclipse.jgit.transport.URIish;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pkcs11Provider {
    private static final Logger LOG = LoggerFactory.getLogger(Pkcs11Provider.class);
    private static final SshAgent NULL_AGENT = new SshAgent(){

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public Iterable<? extends Map.Entry<PublicKey, String>> getIdentities() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<String, byte[]> sign(SessionContext session2, PublicKey key2, String algo, byte[] data2) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addIdentity(KeyPair key2, String comment, SshAgentKeyConstraint ... constraints) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeIdentity(PublicKey key2) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAllIdentities() throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    private static final Map<String, Pkcs11Provider> PROVIDERS = new ConcurrentHashMap<String, Pkcs11Provider>();
    private static final AtomicInteger COUNT = new AtomicInteger();
    private final Provider provider;
    private final SecurityCallback prompter;
    private final KeyStore.Builder builder;
    private KeyStore keys;

    public static Pkcs11Provider getProvider(@NonNull Path library, int slotListIndex) throws IOException {
        int slotIndex = slotListIndex < 0 ? 0 : slotListIndex;
        Path libPath = library.toAbsolutePath();
        String key2 = libPath.toString() + "/" + slotIndex;
        return PROVIDERS.computeIfAbsent(key2, sharedLib -> {
            Provider pkcs11 = Security.getProvider("SunPKCS11");
            if (pkcs11 == null) {
                throw new UnsupportedOperationException();
            }
            Object name = libPath.getFileName().toString().replaceAll("\\s", "");
            name = "JGit-" + slotIndex + "-" + (String)name;
            String property2 = "pkcs11-" + COUNT.incrementAndGet() + "-" + (String)name;
            System.setProperty(property2, libPath.toString());
            String config2 = "--name = " + (String)name + "\nlibrary = ${" + property2 + "}\nslotListIndex = " + slotIndex + "\n";
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: configuring provider with system property {}={} and config:{}{}", name, property2, libPath, System.lineSeparator(), config2);
            }
            pkcs11 = pkcs11.configure(config2);
            String path3 = "pkcs11:?module-path=" + String.valueOf(libPath);
            if (slotListIndex > 0) {
                path3 = path3 + "&slot-list-index=" + slotListIndex;
            }
            SecurityCallback callback2 = new SecurityCallback(new URIish().setPath(path3));
            return new Pkcs11Provider(pkcs11, callback2);
        });
    }

    private Pkcs11Provider(Provider pkcs11, SecurityCallback prompter) {
        this.provider = pkcs11;
        this.prompter = prompter;
        this.builder = KeyStore.Builder.newInstance("PKCS11", this.provider, new KeyStore.CallbackHandlerProtection(prompter));
    }

    private synchronized void load(SessionContext session2) throws GeneralSecurityException, IOException {
        if (this.keys == null) {
            int numberOfPrompts = this.prompter.init(session2);
            for (int attempt = 0; attempt < numberOfPrompts; ++attempt) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{}: Loading PKCS#11 KeyStore (attempt {})", (Object)this.getName(), (Object)Integer.toString(attempt));
                    }
                    this.keys = this.builder.getKeyStore();
                    this.prompter.passwordTried(null);
                    return;
                }
                catch (GeneralSecurityException e2) {
                    if (this.prompter.passwordTried(e2) && attempt < numberOfPrompts && this.isWrongPin(e2)) continue;
                    throw e2;
                }
            }
        }
    }

    synchronized byte[] sign(SessionContext session2, String algorithm, String alias, byte[] data2) throws GeneralSecurityException, IOException {
        int numberOfPrompts = this.prompter.init(session2);
        for (int attempt = 0; attempt < numberOfPrompts; ++attempt) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: Signing with PKCS#11 key {}, algorithm {} (attempt {})", this.getName(), alias, algorithm, Integer.toString(attempt));
                }
                Signature signer = Signature.getInstance(algorithm, this.provider);
                PrivateKey privKey = (PrivateKey)this.keys.getKey(alias, null);
                signer.initSign(privKey);
                signer.update(data2);
                byte[] signature = signer.sign();
                this.prompter.passwordTried(null);
                return signature;
            }
            catch (GeneralSecurityException e2) {
                if (this.prompter.passwordTried(e2) && attempt < numberOfPrompts && this.isWrongPin(e2)) continue;
                throw e2;
            }
        }
        return null;
    }

    private boolean isWrongPin(Throwable e2) {
        Throwable t2 = e2;
        while (t2 != null) {
            if (t2 instanceof FailedLoginException) {
                return true;
            }
            t2 = t2.getCause();
        }
        return false;
    }

    public String getName() {
        return this.provider.getName();
    }

    public Iterable<KeyAgentIdentity> getKeys(SessionContext session2) throws IOException, GeneralSecurityException {
        this.load(session2);
        ArrayList<KeyAgentIdentity> result2 = new ArrayList<KeyAgentIdentity>(2);
        Enumeration<String> aliases = this.keys.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate certificate = this.keys.getCertificate(alias);
            if (certificate == null) continue;
            PublicKey pubKey = certificate.getPublicKey();
            if (pubKey == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{}: certificate {} has no public key??", (Object)this.getName(), (Object)alias);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                if (certificate instanceof X509Certificate) {
                    Object msg;
                    X509Certificate x509 = (X509Certificate)certificate;
                    try {
                        x509.checkValidity();
                        msg = "Certificate is valid";
                    }
                    catch (CertificateExpiredException | CertificateNotYetValidException e2) {
                        msg = "Certificate is INVALID";
                    }
                    boolean[] usage = x509.getKeyUsage();
                    if (usage != null) {
                        msg = (String)msg + ", signing " + (usage[0] ? "allowed" : "NOT allowed");
                    }
                    LOG.debug("{}: Loaded X.509 certificate {}, key type {}. {}.", this.getName(), alias, pubKey.getAlgorithm(), msg);
                } else {
                    LOG.debug("{}: Loaded certificate {}, key type {}.", this.getName(), alias, pubKey.getAlgorithm());
                }
            }
            result2.add(new Pkcs11Identity(pubKey, alias));
        }
        return result2;
    }

    private class Pkcs11Identity
    extends KeyAgentIdentity {
        Pkcs11Identity(PublicKey key2, String alias) {
            super(NULL_AGENT, key2, alias);
        }

        @Override
        public Map.Entry<String, byte[]> sign(SessionContext session2, String algo, byte[] data2) throws Exception {
            BuiltinSignatures factory2 = BuiltinSignatures.fromFactoryName(algo);
            String javaSignatureName = ((org.apache.sshd.common.signature.Signature)factory2.create()).getAlgorithm();
            return new AbstractMap.SimpleImmutableEntry<String, byte[]>(algo, Pkcs11Provider.this.sign(session2, javaSignatureName, this.getComment(), data2));
        }
    }
}

