/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.pkcs11;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.core.CoreModuleProperties;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationCanceledException;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityCallback
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityCallback.class);
    private final URIish uri;
    private KeyPasswordProvider passwordProvider;
    private CredentialsProvider credentialsProvider;
    private int attempts = 0;

    public SecurityCallback(URIish uri2) {
        this.uri = uri2;
    }

    public int init(SessionContext session2) {
        int numberOfAttempts = CoreModuleProperties.PASSWORD_PROMPTS.getRequired(session2);
        Supplier<KeyPasswordProvider> factory2 = session2.getAttribute(JGitClientSession.KEY_PASSWORD_PROVIDER_FACTORY);
        if (factory2 == null) {
            this.passwordProvider = null;
        } else {
            this.passwordProvider = factory2.get();
            this.passwordProvider.setAttempts(numberOfAttempts);
        }
        this.attempts = 0;
        this.credentialsProvider = session2 instanceof JGitClientSession ? ((JGitClientSession)session2).getCredentialsProvider() : null;
        return numberOfAttempts;
    }

    public boolean passwordTried(Exception error2) throws IOException, GeneralSecurityException {
        if (this.attempts > 0 && this.passwordProvider != null) {
            return this.passwordProvider.keyLoaded(this.uri, this.attempts, error2);
        }
        return true;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks.length == 1 && callbacks[0] instanceof PasswordCallback && this.passwordProvider != null) {
            char[] password;
            PasswordCallback p = (PasswordCallback)callbacks[0];
            if ((password = this.passwordProvider.getPassphrase(this.uri, this.attempts++)) == null || password.length == 0) {
                throw new AuthenticationCanceledException();
            }
            p.setPassword(password);
            Arrays.fill(password, '\u0000');
        } else {
            this.handleGeneral(callbacks);
        }
    }

    private void handleGeneral(Callback[] callbacks) throws UnsupportedCallbackException {
        ArrayList<CredentialItem> items2 = new ArrayList<CredentialItem>();
        ArrayList<Runnable> updaters2 = new ArrayList<Runnable>();
        int i2 = 0;
        while (i2 < callbacks.length) {
            Callback c2 = callbacks[i2];
            if (c2 instanceof TextOutputCallback) {
                t = (TextOutputCallback)c2;
                String msg = this.getText(((TextOutputCallback)t).getMessageType(), ((TextOutputCallback)t).getMessage());
                if (this.credentialsProvider == null) {
                    LOG.warn("{}", (Object)MessageFormat.format(SshdText.get().pkcs11GeneralMessage, this.uri, msg));
                } else {
                    CredentialItem.InformationalMessage item = new CredentialItem.InformationalMessage(msg);
                    items2.add(item);
                }
            } else if (c2 instanceof TextInputCallback) {
                if (this.credentialsProvider == null) {
                    throw new UnsupportedOperationException("No CredentialsProvider " + String.valueOf(this.uri));
                }
                t = (TextInputCallback)c2;
                CredentialItem.StringType item = new CredentialItem.StringType(((TextInputCallback)t).getPrompt(), false);
                String defaultValue = ((TextInputCallback)t).getDefaultText();
                if (defaultValue != null) {
                    item.setValue(defaultValue);
                }
                items2.add(item);
                updaters2.add(() -> SecurityCallback.lambda$0((TextInputCallback)t, item));
            } else if (c2 instanceof PasswordCallback) {
                if (this.credentialsProvider == null) {
                    throw new UnsupportedOperationException("No CredentialsProvider " + String.valueOf(this.uri));
                }
                PasswordCallback p = (PasswordCallback)c2;
                CredentialItem.Password item = new CredentialItem.Password(p.getPrompt());
                items2.add(item);
                updaters2.add(() -> {
                    char[] password2 = item.getValue();
                    if (password2 == null || password2.length == 0) {
                        throw new AuthenticationCanceledException();
                    }
                    p.setPassword(password2);
                    item.clear();
                });
            } else if (c2 instanceof ConfirmationCallback) {
                if (this.credentialsProvider == null) {
                    throw new UnsupportedOperationException("No CredentialsProvider " + String.valueOf(this.uri));
                }
                ConfirmationCallback conf = (ConfirmationCallback)c2;
                int options2 = conf.getOptionType();
                int defaultOption = conf.getDefaultOption();
                CredentialItem.YesNoType item = new CredentialItem.YesNoType(this.getText(conf.getMessageType(), conf.getPrompt()));
                switch (options2) {
                    case 0: {
                        if (defaultOption == 0) {
                            item.setValue(true);
                        }
                        updaters2.add(() -> conf.setSelectedIndex(item.getValue() ? 0 : 1));
                        break;
                    }
                    case 2: {
                        if (defaultOption == 3) {
                            item.setValue(true);
                        }
                        updaters2.add(() -> conf.setSelectedIndex(item.getValue() ? 3 : 2));
                        break;
                    }
                    default: {
                        throw new UnsupportedCallbackException(c2);
                    }
                }
                items2.add(item);
            } else {
                if (c2 instanceof ChoiceCallback) {
                    throw new UnsupportedCallbackException(c2);
                }
                if (c2 instanceof LanguageCallback) {
                    ((LanguageCallback)c2).setLocale(Locale.getDefault());
                } else {
                    throw new UnsupportedCallbackException(c2);
                }
            }
            ++i2;
        }
        if (!items2.isEmpty()) {
            if (this.credentialsProvider.get(this.uri, items2)) {
                updaters2.forEach(Runnable::run);
            } else {
                throw new AuthenticationCanceledException();
            }
        }
    }

    private String getText(int messageType, String text) {
        if (messageType == 1) {
            return MessageFormat.format(SshdText.get().pkcs11Warning, text);
        }
        if (messageType == 2) {
            return MessageFormat.format(SshdText.get().pkcs11Error, text);
        }
        return text;
    }

    private static /* synthetic */ void lambda$0(TextInputCallback textInputCallback, CredentialItem.StringType stringType) {
        textInputCallback.setText(stringType.getValue());
    }
}

