/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.proxy;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.session.ClientSession;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.proxy.StatefulProxyConnector;

public abstract class AbstractClientProxyConnector
implements StatefulProxyConnector {
    private static final long DEFAULT_PROXY_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(30L);
    private final Object lock = new Object();
    private boolean done;
    private List<Callable<Void>> bufferedCommands = new ArrayList<Callable<Void>>();
    private AtomicReference<Runnable> unregister = new AtomicReference();
    private long remainingProxyProtocolTime = DEFAULT_PROXY_TIMEOUT_NANOS;
    private long lastProxyOperationTime = 0L;
    protected final InetSocketAddress remoteAddress;
    protected final InetSocketAddress proxyAddress;
    protected String proxyUser;
    protected char[] proxyPassword;

    public AbstractClientProxyConnector(@NonNull InetSocketAddress proxyAddress, @NonNull InetSocketAddress remoteAddress2, String proxyUser, char[] proxyPassword) {
        this.proxyAddress = proxyAddress;
        this.remoteAddress = remoteAddress2;
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword == null ? new char[]{} : proxyPassword;
    }

    protected void init(ClientSession session2) {
        long millis = session2.getLongProperty(StatefulProxyConnector.TIMEOUT_PROPERTY, 0L);
        long l = this.remainingProxyProtocolTime = millis > 0L ? TimeUnit.MILLISECONDS.toNanos(millis) : DEFAULT_PROXY_TIMEOUT_NANOS;
        if (!(session2 instanceof JGitClientSession)) {
            throw new IllegalStateException("Not a JGit session: " + session2.getClass().getName());
        }
        JGitClientSession s2 = (JGitClientSession)session2;
        this.unregister.set(() -> s2.setProxyHandler(null));
        s2.setProxyHandler(this);
    }

    protected long getTimeout() {
        long now;
        long last2 = this.lastProxyOperationTime;
        this.lastProxyOperationTime = now = System.nanoTime();
        long remaining = this.remainingProxyProtocolTime;
        if (last2 != 0L) {
            long elapsed = now - last2;
            this.remainingProxyProtocolTime = remaining -= elapsed;
        }
        return Math.max(remaining / 1000000L, 10L);
    }

    protected void adjustTimeout() {
        this.lastProxyOperationTime = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDone(boolean success) throws Exception {
        List<Callable<Void>> buffered;
        Runnable unset = this.unregister.getAndSet(null);
        if (unset != null) {
            unset.run();
        }
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            buffered = this.bufferedCommands;
            this.bufferedCommands = null;
        }
        if (success && buffered != null) {
            for (Callable<Void> starter : buffered) {
                starter.call();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWhenDone(Callable<Void> starter) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.done) {
                this.bufferedCommands.add(starter);
                return;
            }
        }
        starter.call();
    }

    protected void clearPassword() {
        Arrays.fill(this.proxyPassword, '\u0000');
        this.proxyPassword = new char[0];
    }
}

