/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.proxy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.internal.transport.sshd.proxy.AuthenticationChallenge;
import org.eclipse.jgit.internal.transport.sshd.proxy.StatusLine;
import org.eclipse.jgit.util.HttpSupport;

public final class HttpParser {
    private HttpParser() {
    }

    public static StatusLine parseStatusLine(String line) throws ParseException {
        int resultCode;
        int firstBlank = line.indexOf(32);
        if (firstBlank < 0) {
            throw new ParseException();
        }
        int secondBlank = line.indexOf(32, firstBlank + 1);
        if (secondBlank < 0) {
            secondBlank = line.length();
        }
        try {
            resultCode = Integer.parseUnsignedInt(line.substring(firstBlank + 1, secondBlank));
        }
        catch (NumberFormatException e2) {
            throw new ParseException(e2);
        }
        String reason = "";
        if (secondBlank < line.length()) {
            reason = line.substring(secondBlank + 1);
        }
        return new StatusLine(line.substring(0, firstBlank), resultCode, reason);
    }

    public static List<AuthenticationChallenge> getAuthenticationHeaders(List<String> reply, String authenticationHeader) {
        ArrayList<AuthenticationChallenge> challenges = new ArrayList<AuthenticationChallenge>();
        Iterator<String> lines = reply.iterator();
        lines.next();
        StringBuilder value2 = null;
        while (lines.hasNext()) {
            int firstColon;
            String line = lines.next();
            if (line.isEmpty()) break;
            if (Character.isWhitespace(line.charAt(0))) {
                if (value2 == null) continue;
                int i2 = HttpParser.skipWhiteSpace(line, 1);
                value2.append(' ').append(line, i2, line.length());
                continue;
            }
            if (value2 != null) {
                HttpParser.parseChallenges(challenges, value2.toString());
                value2 = null;
            }
            if ((firstColon = line.indexOf(58)) <= 0 || !authenticationHeader.equalsIgnoreCase(line.substring(0, firstColon + 1))) continue;
            value2 = new StringBuilder(line.substring(firstColon + 1));
        }
        if (value2 != null) {
            HttpParser.parseChallenges(challenges, value2.toString());
        }
        return challenges;
    }

    private static void parseChallenges(List<AuthenticationChallenge> challenges, String header) {
        int length = header.length();
        int i2 = 0;
        while (i2 < length) {
            int start2 = HttpParser.skipWhiteSpace(header, i2);
            int end2 = HttpSupport.scanToken(header, start2);
            if (end2 <= start2) break;
            AuthenticationChallenge challenge = new AuthenticationChallenge(header.substring(start2, end2));
            challenges.add(challenge);
            i2 = HttpParser.parseChallenge(challenge, header, end2);
        }
    }

    private static int parseChallenge(AuthenticationChallenge challenge, String header, int from2) {
        int length = header.length();
        boolean first2 = true;
        int start2 = from2;
        while (start2 <= length) {
            int end2 = HttpSupport.scanToken(header, start2 = HttpParser.skipWhiteSpace(header, start2));
            if (end2 == start2) {
                if (start2 < header.length() && header.charAt(start2) == ',') {
                    return start2 + 1;
                }
                return start2;
            }
            int next2 = HttpParser.skipWhiteSpace(header, end2);
            if (next2 >= length || header.charAt(next2) != '=') {
                if (first2) {
                    challenge.setToken(header.substring(start2, end2));
                    if (next2 < length && header.charAt(next2) == ',') {
                        ++next2;
                    }
                    return next2;
                }
                return start2;
            }
            int nextStart = HttpParser.skipWhiteSpace(header, next2 + 1);
            if (nextStart >= length) {
                if (next2 == end2) {
                    challenge.setToken(header.substring(start2, end2 + 1));
                } else {
                    challenge.addArgument(header.substring(start2, end2), null);
                }
                return nextStart;
            }
            if (nextStart == end2 + 1 && header.charAt(nextStart) == '=') {
                end2 = nextStart + 1;
                while (end2 < length && header.charAt(end2) == '=') {
                    ++end2;
                }
                challenge.setToken(header.substring(start2, end2));
                end2 = HttpParser.skipWhiteSpace(header, end2);
                if (end2 < length && header.charAt(end2) == ',') {
                    ++end2;
                }
                return end2;
            }
            if (header.charAt(nextStart) == ',') {
                if (next2 == end2) {
                    challenge.setToken(header.substring(start2, end2 + 1));
                    return nextStart + 1;
                }
                challenge.addArgument(header.substring(start2, end2), null);
                start2 = nextStart + 1;
            } else {
                if (header.charAt(nextStart) == '\"') {
                    int[] nextEnd = new int[]{nextStart + 1};
                    String value2 = HttpParser.scanQuotedString(header, nextStart + 1, nextEnd);
                    challenge.addArgument(header.substring(start2, end2), value2);
                    start2 = nextEnd[0];
                } else {
                    int nextEnd = HttpSupport.scanToken(header, nextStart);
                    challenge.addArgument(header.substring(start2, end2), header.substring(nextStart, nextEnd));
                    start2 = nextEnd;
                }
                start2 = HttpParser.skipWhiteSpace(header, start2);
                if (start2 < length && header.charAt(start2) == ',') {
                    ++start2;
                }
            }
            first2 = false;
        }
        return length;
    }

    private static int skipWhiteSpace(String header, int i2) {
        int length = header.length();
        while (i2 < length && Character.isWhitespace(header.charAt(i2))) {
            ++i2;
        }
        return i2;
    }

    private static String scanQuotedString(String header, int from2, int[] to) {
        StringBuilder result2 = new StringBuilder();
        int length = header.length();
        boolean quoted = false;
        int i2 = from2;
        while (i2 < length) {
            char c2 = header.charAt(i2++);
            if (quoted) {
                result2.append(c2);
                quoted = false;
                continue;
            }
            if (c2 == '\\') {
                quoted = true;
                continue;
            }
            if (c2 == '\"') break;
            result2.append(c2);
        }
        to[0] = i2;
        return result2.toString();
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = -1634090143702048640L;

        public ParseException() {
        }

        public ParseException(Throwable cause) {
            super(cause);
        }
    }
}

