/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;

public final class AbbrevConfig {
    private static final String VALUE_NO = "no";
    private static final String VALUE_AUTO = "auto";
    public static final int MIN_ABBREV = 4;
    public static final AbbrevConfig NO = new AbbrevConfig(40);
    private int abbrev;

    public static int capAbbrev(int len2) {
        return Math.min(Math.max(4, len2), 40);
    }

    public static AbbrevConfig parseFromConfig(Repository repo) throws InvalidConfigurationException {
        StoredConfig config2 = repo.getConfig();
        String value2 = config2.getString("core", null, "abbrev");
        if (value2 == null || value2.equalsIgnoreCase(VALUE_AUTO)) {
            return AbbrevConfig.auto(repo);
        }
        if (value2.equalsIgnoreCase(VALUE_NO)) {
            return NO;
        }
        try {
            int len2 = config2.getIntInRange("core", "abbrev", 4, 40, Integer.MIN_VALUE);
            if (len2 == Integer.MIN_VALUE) {
                len2 = 7;
            }
            return new AbbrevConfig(len2);
        }
        catch (IllegalArgumentException e2) {
            throw new InvalidConfigurationException(MessageFormat.format(JGitText.get().invalidCoreAbbrev, value2), e2);
        }
    }

    private static AbbrevConfig auto(Repository repo) {
        long count2 = repo.getObjectDatabase().getApproximateObjectCount();
        if (count2 == -1L) {
            return new AbbrevConfig(7);
        }
        int len2 = 63 - Long.numberOfLeadingZeros(count2) + 1;
        len2 = (len2 + 1) / 2;
        return new AbbrevConfig(Math.max(len2, 7));
    }

    private AbbrevConfig(int abbrev) {
        this.abbrev = AbbrevConfig.capAbbrev(abbrev);
    }

    public int get() {
        return this.abbrev;
    }

    public String toString() {
        return Integer.toString(this.abbrev);
    }
}

