/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.net.URISyntaxException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;

public class BranchConfig {
    public static final String LOCAL_REPOSITORY = ".";
    private final Config config;
    private final String branchName;

    public BranchConfig(Config config2, String branchName) {
        this.config = config2;
        this.branchName = branchName;
    }

    public String getTrackingBranch() {
        String remote = this.getRemoteOrDefault();
        String mergeRef = this.getMerge();
        if (remote == null || mergeRef == null) {
            return null;
        }
        if (this.isRemoteLocal()) {
            return mergeRef;
        }
        return this.findRemoteTrackingBranch(remote, mergeRef);
    }

    public String getRemoteTrackingBranch() {
        String remote = this.getRemoteOrDefault();
        String mergeRef = this.getMerge();
        if (remote == null || mergeRef == null) {
            return null;
        }
        return this.findRemoteTrackingBranch(remote, mergeRef);
    }

    public boolean isRemoteLocal() {
        return LOCAL_REPOSITORY.equals(this.getRemote());
    }

    public String getRemote() {
        return this.config.getString("branch", this.branchName, "remote");
    }

    public String getPushRemote() {
        return this.config.getString("branch", this.branchName, "pushRemote");
    }

    public String getMerge() {
        return this.config.getString("branch", this.branchName, "merge");
    }

    public boolean isRebase() {
        return this.getRebaseMode() != BranchRebaseMode.NONE;
    }

    public BranchRebaseMode getRebaseMode() {
        return this.config.getEnum("branch", this.branchName, "rebase", BranchRebaseMode.NONE);
    }

    private String findRemoteTrackingBranch(String remote, String mergeRef) {
        RemoteConfig remoteConfig;
        try {
            remoteConfig = new RemoteConfig(this.config, remote);
        }
        catch (URISyntaxException e2) {
            return null;
        }
        for (RefSpec refSpec : remoteConfig.getFetchRefSpecs()) {
            if (!refSpec.matchSource(mergeRef)) continue;
            RefSpec expanded = refSpec.expandFromSource(mergeRef);
            return expanded.getDestination();
        }
        return null;
    }

    private String getRemoteOrDefault() {
        String remote = this.getRemote();
        if (remote == null) {
            return "origin";
        }
        return remote;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum BranchRebaseMode implements Config.ConfigEnum
    {
        REBASE("true"),
        MERGES("merges"){

            @Override
            public boolean matchConfigValue(String s2) {
                return super.matchConfigValue(s2) || "preserve".equals(s2);
            }
        }
        ,
        INTERACTIVE("interactive"),
        NONE("false");

        private final String configValue;

        private BranchRebaseMode(String configValue) {
            this.configValue = configValue;
        }

        @Override
        public String toConfigValue() {
            return this.configValue;
        }

        @Override
        public boolean matchConfigValue(String s2) {
            return this.configValue.equals(s2);
        }
    }
}

