/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.ListenerList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ConfigLine;
import org.eclipse.jgit.lib.ConfigSnapshot;
import org.eclipse.jgit.lib.DefaultTypedConfigGetter;
import org.eclipse.jgit.lib.TypedConfigGetter;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;

public class Config {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int MAX_DEPTH = 10;
    private static final TypedConfigGetter DEFAULT_GETTER;
    private static TypedConfigGetter typedGetter;
    private final ListenerList listeners = new ListenerList();
    private final AtomicReference<ConfigSnapshot> state;
    private final Config baseConfig;
    private static final String MISSING_ENTRY;

    static {
        typedGetter = DEFAULT_GETTER = new DefaultTypedConfigGetter();
        MISSING_ENTRY = new String();
    }

    public Config() {
        this(null);
    }

    public Config(Config defaultConfig) {
        this.baseConfig = defaultConfig;
        this.state = new AtomicReference<ConfigSnapshot>(this.newState());
    }

    public Config getBaseConfig() {
        return this.baseConfig;
    }

    public static boolean isMissing(String value2) {
        return value2 == MISSING_ENTRY;
    }

    public static void setTypedConfigGetter(TypedConfigGetter getter) {
        typedGetter = getter == null ? DEFAULT_GETTER : getter;
    }

    static String escapeValue(String x) {
        if (x.isEmpty()) {
            return "";
        }
        boolean needQuote = x.charAt(0) == ' ' || x.charAt(x.length() - 1) == ' ';
        StringBuilder r = new StringBuilder(x.length());
        int k2 = 0;
        while (k2 < x.length()) {
            char c2 = x.charAt(k2);
            switch (c2) {
                case '\u0000': {
                    throw new IllegalArgumentException(JGitText.get().configValueContainsNullByte);
                }
                case '\n': {
                    r.append('\\').append('n');
                    break;
                }
                case '\t': {
                    r.append('\\').append('t');
                    break;
                }
                case '\b': {
                    r.append('\\').append('b');
                    break;
                }
                case '\\': {
                    r.append('\\').append('\\');
                    break;
                }
                case '\"': {
                    r.append('\\').append('\"');
                    break;
                }
                case '#': 
                case ';': {
                    needQuote = true;
                    r.append(c2);
                    break;
                }
                default: {
                    r.append(c2);
                }
            }
            ++k2;
        }
        return needQuote ? "\"" + r.toString() + "\"" : r.toString();
    }

    static String escapeSubsection(String x) {
        if (x.isEmpty()) {
            return "\"\"";
        }
        StringBuilder r = new StringBuilder(x.length() + 2).append('\"');
        int k2 = 0;
        while (k2 < x.length()) {
            char c2 = x.charAt(k2);
            switch (c2) {
                case '\u0000': {
                    throw new IllegalArgumentException(JGitText.get().configSubsectionContainsNullByte);
                }
                case '\n': {
                    throw new IllegalArgumentException(JGitText.get().configSubsectionContainsNewline);
                }
                case '\"': 
                case '\\': {
                    r.append('\\').append(c2);
                    break;
                }
                default: {
                    r.append(c2);
                }
            }
            ++k2;
        }
        return r.append('\"').toString();
    }

    public int getInt(String section, String name, int defaultValue) {
        return this.getInt(section, null, name, defaultValue);
    }

    @Nullable
    public Integer getInt(String section, String name) {
        return this.getInt(section, null, name);
    }

    public int getInt(String section, String subsection, String name, int defaultValue) {
        Integer v = typedGetter.getInt(this, section, subsection, name, (Integer)defaultValue);
        return v == null ? defaultValue : v;
    }

    @Nullable
    public Integer getInt(String section, String subsection, String name) {
        return typedGetter.getInt(this, section, subsection, name, null);
    }

    public int getIntInRange(String section, String name, int minValue, int maxValue, int defaultValue) {
        return this.getIntInRange(section, null, name, minValue, maxValue, defaultValue);
    }

    @Nullable
    public Integer getIntInRange(String section, String name, int minValue, int maxValue) {
        return this.getIntInRange(section, null, name, minValue, maxValue);
    }

    public int getIntInRange(String section, String subsection, String name, int minValue, int maxValue, int defaultValue) {
        Integer v = typedGetter.getIntInRange(this, section, subsection, name, minValue, maxValue, (Integer)defaultValue);
        return v == null ? defaultValue : v;
    }

    @Nullable
    public Integer getIntInRange(String section, String subsection, String name, int minValue, int maxValue) {
        return typedGetter.getIntInRange(this, section, subsection, name, minValue, maxValue, null);
    }

    public long getLong(String section, String name, long defaultValue) {
        return this.getLong(section, null, name, defaultValue);
    }

    @Nullable
    public Long getLong(String section, String name) {
        return this.getLong(section, null, name);
    }

    public long getLong(String section, String subsection, String name, long defaultValue) {
        Long v = typedGetter.getLong(this, section, subsection, name, (Long)defaultValue);
        return v == null ? defaultValue : v;
    }

    @Nullable
    public Long getLong(String section, String subsection, String name) {
        return typedGetter.getLong(this, section, subsection, name, null);
    }

    public boolean getBoolean(String section, String name, boolean defaultValue) {
        Boolean v = typedGetter.getBoolean(this, section, (String)null, name, (Boolean)defaultValue);
        return v == null ? defaultValue : v;
    }

    @Nullable
    public Boolean getBoolean(String section, String name) {
        return this.getBoolean(section, null, name);
    }

    public boolean getBoolean(String section, String subsection, String name, boolean defaultValue) {
        Boolean v = typedGetter.getBoolean(this, section, subsection, name, (Boolean)defaultValue);
        return v == null ? defaultValue : v;
    }

    @Nullable
    public Boolean getBoolean(String section, String subsection, String name) {
        return typedGetter.getBoolean(this, section, subsection, name, null);
    }

    public <T extends Enum<?>> T getEnum(String section, String subsection, String name, @NonNull T defaultValue) {
        Enum[] all = Config.allValuesOf(defaultValue);
        return (T)typedGetter.getEnum(this, all, section, subsection, name, defaultValue);
    }

    private static <T> T[] allValuesOf(T value2) {
        try {
            return (Object[])value2.getClass().getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception err) {
            String typeName2 = value2.getClass().getName();
            String msg = MessageFormat.format(JGitText.get().enumValuesNotAvailable, typeName2);
            throw new IllegalArgumentException(msg, err);
        }
    }

    @Nullable
    @Deprecated
    public <T extends Enum<?>> T getEnum(T[] all, String section, String subsection, String name, @Nullable T defaultValue) {
        return (T)typedGetter.getEnum(this, (Enum[])all, section, subsection, name, defaultValue);
    }

    @Nullable
    public <T extends Enum<?>> T getEnum(T[] all, String section, String subsection, String name) {
        return (T)typedGetter.getEnum(this, (Enum[])all, section, subsection, name, null);
    }

    @Nullable
    public String getString(String section, String subsection, String name) {
        return this.getRawString(section, subsection, name);
    }

    public String[] getStringList(String section, String subsection, String name) {
        String[] base = this.baseConfig != null ? this.baseConfig.getStringList(section, subsection, name) : EMPTY_STRING_ARRAY;
        String[] self = this.getRawStringList(section, subsection, name);
        if (self == null) {
            return base;
        }
        if (base.length == 0) {
            return self;
        }
        String[] res = new String[base.length + self.length];
        int n = base.length;
        System.arraycopy(base, 0, res, 0, n);
        System.arraycopy(self, 0, res, n, self.length);
        return res;
    }

    public long getTimeUnit(String section, String subsection, String name, long defaultValue, TimeUnit wantUnit) {
        Long v = typedGetter.getTimeUnit(this, section, subsection, name, (Long)defaultValue, wantUnit);
        return v == null ? defaultValue : v;
    }

    @Nullable
    public Long getTimeUnit(String section, String subsection, String name, TimeUnit wantUnit) {
        return typedGetter.getTimeUnit(this, section, subsection, name, null, wantUnit);
    }

    @Nullable
    public Path getPath(String section, String subsection, String name, @NonNull FS fs, File resolveAgainst, @Nullable Path defaultValue) {
        return typedGetter.getPath(this, section, subsection, name, fs, resolveAgainst, defaultValue);
    }

    public List<RefSpec> getRefSpecs(String section, String subsection, String name) {
        return typedGetter.getRefSpecs(this, section, subsection, name);
    }

    public Set<String> getSubsections(String section) {
        return this.getState().getSubsections(section);
    }

    public Set<String> getSections() {
        return this.getState().getSections();
    }

    public Set<String> getNames(String section) {
        return this.getNames(section, null);
    }

    public Set<String> getNames(String section, String subsection) {
        return this.getState().getNames(section, subsection);
    }

    public Set<String> getNames(String section, boolean recursive) {
        return this.getState().getNames(section, null, recursive);
    }

    public Set<String> getNames(String section, String subsection, boolean recursive) {
        return this.getState().getNames(section, subsection, recursive);
    }

    public <T> T get(SectionParser<T> parser) {
        ConfigSnapshot myState = this.getState();
        Object obj = myState.cache.get(parser);
        if (obj == null) {
            obj = parser.parse(this);
            myState.cache.put(parser, obj);
        }
        return (T)obj;
    }

    public void uncache(SectionParser<?> parser) {
        this.state.get().cache.remove(parser);
    }

    public ListenerHandle addChangeListener(ConfigChangedListener listener) {
        return this.listeners.addConfigChangedListener(listener);
    }

    protected boolean notifyUponTransientChanges() {
        return true;
    }

    protected void fireConfigChangedEvent() {
        this.listeners.dispatch(new ConfigChangedEvent());
    }

    private String getRawString(String section, String subsection, String name) {
        String[] lst = this.getRawStringList(section, subsection, name);
        if (lst != null) {
            return lst[lst.length - 1];
        }
        if (this.baseConfig != null) {
            return this.baseConfig.getRawString(section, subsection, name);
        }
        return null;
    }

    private String[] getRawStringList(String section, String subsection, String name) {
        return this.state.get().get(section, subsection, name);
    }

    private ConfigSnapshot getState() {
        ConfigSnapshot base;
        ConfigSnapshot upd;
        ConfigSnapshot cur;
        do {
            cur = this.state.get();
            base = this.getBaseState();
            if (cur.baseState != base) continue;
            return cur;
        } while (!this.state.compareAndSet(cur, upd = new ConfigSnapshot(cur.entryList, base)));
        return upd;
    }

    private ConfigSnapshot getBaseState() {
        return this.baseConfig != null ? this.baseConfig.getState() : null;
    }

    public void setInt(String section, String subsection, String name, int value2) {
        this.setLong(section, subsection, name, value2);
    }

    public void setLong(String section, String subsection, String name, long value2) {
        this.setString(section, subsection, name, StringUtils.formatWithSuffix(value2));
    }

    public void setBoolean(String section, String subsection, String name, boolean value2) {
        this.setString(section, subsection, name, value2 ? "true" : "false");
    }

    public <T extends Enum<?>> void setEnum(String section, String subsection, String name, T value2) {
        String n = value2 instanceof ConfigEnum ? ((ConfigEnum)((Object)value2)).toConfigValue() : value2.name().toLowerCase(Locale.ROOT).replace('_', ' ');
        this.setString(section, subsection, name, n);
    }

    public void setString(String section, String subsection, String name, String value2) {
        this.setStringList(section, subsection, name, Collections.singletonList(value2));
    }

    public void unset(String section, String subsection, String name) {
        this.setStringList(section, subsection, name, Collections.emptyList());
    }

    public void unsetSection(String section, String subsection) {
        this.removeSection(section, subsection);
    }

    public boolean removeSection(String section, String subsection) {
        ConfigSnapshot res;
        ConfigSnapshot src;
        AtomicBoolean changed = new AtomicBoolean();
        do {
            src = this.state.get();
            changed.set(false);
        } while (!this.state.compareAndSet(src, res = this.unsetSection(src, section, subsection, changed)));
        return changed.get();
    }

    private ConfigSnapshot unsetSection(ConfigSnapshot srcState, String section, String subsection, AtomicBoolean changed) {
        int max2 = srcState.entryList.size();
        ArrayList<ConfigLine> r = new ArrayList<ConfigLine>(max2);
        boolean lastWasMatch = false;
        for (ConfigLine e2 : srcState.entryList) {
            if (e2.includedFrom != null) {
                r.add(e2);
                continue;
            }
            if (lastWasMatch && e2.section == null && e2.subsection == null) continue;
            lastWasMatch = e2.match(section, subsection);
            if (lastWasMatch) {
                changed.set(true);
                continue;
            }
            r.add(e2);
        }
        return this.newState(r);
    }

    public void setStringList(String section, String subsection, String name, List<String> values2) {
        ConfigSnapshot res;
        ConfigSnapshot src;
        while (!this.state.compareAndSet(src = this.state.get(), res = this.replaceStringList(src, section, subsection, name, values2))) {
        }
        if (this.notifyUponTransientChanges()) {
            this.fireConfigChangedEvent();
        }
    }

    private ConfigSnapshot replaceStringList(ConfigSnapshot srcState, String section, String subsection, String name, List<String> values2) {
        ConfigLine e2;
        List<ConfigLine> entries2 = Config.copy(srcState, values2);
        int entryIndex = 0;
        int valueIndex = 0;
        int insertPosition = -1;
        while (entryIndex < entries2.size() && valueIndex < values2.size()) {
            e2 = entries2.get(entryIndex);
            if (e2.includedFrom == null && e2.match(section, subsection, name)) {
                entries2.set(entryIndex, e2.forValue(values2.get(valueIndex++)));
                insertPosition = entryIndex + 1;
            }
            ++entryIndex;
        }
        if (valueIndex == values2.size() && entryIndex < entries2.size()) {
            while (entryIndex < entries2.size()) {
                e2 = entries2.get(entryIndex++);
                if (e2.includedFrom != null || !e2.match(section, subsection, name)) continue;
                entries2.remove(--entryIndex);
            }
        }
        if (valueIndex < values2.size() && entryIndex == entries2.size()) {
            if (insertPosition < 0) {
                insertPosition = Config.findSectionEnd(entries2, section, subsection, true);
            }
            if (insertPosition < 0) {
                e2 = new ConfigLine();
                e2.section = section;
                e2.subsection = subsection;
                entries2.add(e2);
                insertPosition = entries2.size();
            }
            while (valueIndex < values2.size()) {
                e2 = new ConfigLine();
                e2.section = section;
                e2.subsection = subsection;
                e2.name = name;
                e2.value = values2.get(valueIndex++);
                entries2.add(insertPosition++, e2);
            }
        }
        return this.newState(entries2);
    }

    private static List<ConfigLine> copy(ConfigSnapshot src, List<String> values2) {
        int max2 = src.entryList.size() + values2.size() + 1;
        ArrayList<ConfigLine> r = new ArrayList<ConfigLine>(max2);
        r.addAll(src.entryList);
        return r;
    }

    private static int findSectionEnd(List<ConfigLine> entries2, String section, String subsection, boolean skipIncludedLines) {
        int i2 = 0;
        while (i2 < entries2.size()) {
            ConfigLine e2 = entries2.get(i2);
            if ((e2.includedFrom == null || !skipIncludedLines) && e2.match(section, subsection, null)) {
                ++i2;
                while (i2 < entries2.size()) {
                    e2 = entries2.get(i2);
                    if (!e2.match(section, subsection, e2.name)) break;
                    ++i2;
                }
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public String toText() {
        StringBuilder out2 = new StringBuilder();
        for (ConfigLine e2 : this.state.get().entryList) {
            if (e2.includedFrom != null) continue;
            if (e2.prefix != null) {
                out2.append(e2.prefix);
            }
            if (e2.section != null && e2.name == null) {
                out2.append('[');
                out2.append(e2.section);
                if (e2.subsection != null) {
                    boolean quoted;
                    out2.append(' ');
                    String escaped = Config.escapeValue(e2.subsection);
                    boolean bl = quoted = escaped.startsWith("\"") && escaped.endsWith("\"");
                    if (!quoted) {
                        out2.append('\"');
                    }
                    out2.append(escaped);
                    if (!quoted) {
                        out2.append('\"');
                    }
                }
                out2.append(']');
            } else if (e2.section != null && e2.name != null) {
                if (e2.prefix == null || "".equals(e2.prefix)) {
                    out2.append('\t');
                }
                out2.append(e2.name);
                if (!Config.isMissing(e2.value)) {
                    out2.append(" =");
                    if (e2.value != null) {
                        out2.append(' ');
                        out2.append(Config.escapeValue(e2.value));
                    }
                }
                if (e2.suffix != null) {
                    out2.append(' ');
                }
            }
            if (e2.suffix != null) {
                out2.append(e2.suffix);
            }
            out2.append('\n');
        }
        return out2.toString();
    }

    public void fromText(String text) throws ConfigInvalidException {
        this.state.set(this.newState(this.fromTextRecurse(text, 1, null)));
    }

    private List<ConfigLine> fromTextRecurse(String text, int depth, String includedFrom) throws ConfigInvalidException {
        ArrayList<ConfigLine> newEntries;
        block15: {
            if (depth > 10) {
                throw new ConfigInvalidException(JGitText.get().tooManyIncludeRecursions);
            }
            newEntries = new ArrayList<ConfigLine>();
            StringReader in = new StringReader(text);
            ConfigLine last2 = null;
            ConfigLine e2 = new ConfigLine();
            e2.includedFrom = includedFrom;
            while (true) {
                int input;
                if (-1 == (input = in.read())) {
                    if (e2.section != null) {
                        newEntries.add(e2);
                    }
                    break block15;
                }
                char c2 = (char)input;
                if ('\n' == c2) {
                    newEntries.add(e2);
                    if (e2.section != null) {
                        last2 = e2;
                    }
                    e2 = new ConfigLine();
                    e2.includedFrom = includedFrom;
                    continue;
                }
                if (e2.suffix != null) {
                    e2.suffix = String.valueOf(e2.suffix) + c2;
                    continue;
                }
                if (';' == c2 || '#' == c2) {
                    e2.suffix = String.valueOf(c2);
                    continue;
                }
                if (e2.section == null && Character.isWhitespace(c2)) {
                    if (e2.prefix == null) {
                        e2.prefix = "";
                    }
                    e2.prefix = String.valueOf(e2.prefix) + c2;
                    continue;
                }
                if ('[' == c2) {
                    e2.section = Config.readSectionName(in);
                    input = in.read();
                    if (34 == input) {
                        e2.subsection = Config.readSubsectionName(in);
                        input = in.read();
                    }
                    if (93 != input) {
                        throw new ConfigInvalidException(JGitText.get().badGroupHeader);
                    }
                    e2.suffix = "";
                    continue;
                }
                if (last2 == null) break;
                e2.section = last2.section;
                e2.subsection = last2.subsection;
                in.reset();
                e2.name = Config.readKeyName(in);
                if (e2.name.endsWith("\n")) {
                    e2.name = e2.name.substring(0, e2.name.length() - 1);
                    e2.value = MISSING_ENTRY;
                } else {
                    e2.value = Config.readValue(in);
                }
                if (!e2.section.equalsIgnoreCase("include")) continue;
                this.addIncludedConfig(newEntries, e2, depth);
            }
            throw new ConfigInvalidException(JGitText.get().invalidLineInConfigFile);
        }
        return newEntries;
    }

    protected byte[] readIncludedConfig(String relPath) throws ConfigInvalidException {
        return null;
    }

    private void addIncludedConfig(List<ConfigLine> newEntries, ConfigLine line, int depth) throws ConfigInvalidException {
        if (!line.name.equalsIgnoreCase("path") || line.value == null || line.value.equals(MISSING_ENTRY)) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().invalidLineInConfigFileWithParam, line));
        }
        byte[] bytes = this.readIncludedConfig(line.value);
        if (bytes == null) {
            return;
        }
        String decoded = this.isUtf8(bytes) ? RawParseUtils.decode(StandardCharsets.UTF_8, bytes, 3, bytes.length) : RawParseUtils.decode(bytes);
        try {
            newEntries.addAll(this.fromTextRecurse(decoded, depth + 1, line.value));
        }
        catch (ConfigInvalidException e2) {
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().cannotReadFile, line.value), e2);
        }
    }

    private ConfigSnapshot newState() {
        return new ConfigSnapshot(Collections.emptyList(), this.getBaseState());
    }

    private ConfigSnapshot newState(List<ConfigLine> entries2) {
        return new ConfigSnapshot(Collections.unmodifiableList(entries2), this.getBaseState());
    }

    protected void clear() {
        this.state.set(this.newState());
    }

    protected boolean isUtf8(byte[] bytes) {
        return bytes.length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65;
    }

    private static String readSectionName(StringReader in) throws ConfigInvalidException {
        StringBuilder name;
        block6: {
            name = new StringBuilder();
            while (true) {
                int c2;
                if ((c2 = in.read()) < 0) {
                    throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                }
                if (93 == c2) {
                    in.reset();
                    break block6;
                }
                if (32 == c2 || 9 == c2) {
                    do {
                        if ((c2 = in.read()) < 0) {
                            throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                        }
                        if (34 != c2) continue;
                        in.reset();
                        break block6;
                    } while (32 == c2 || 9 == c2);
                    throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badSectionEntry, name));
                }
                if (!Character.isLetterOrDigit((char)c2) && 46 != c2 && 45 != c2) break;
                name.append((char)c2);
            }
            throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badSectionEntry, name));
        }
        return name.toString();
    }

    private static String readKeyName(StringReader in) throws ConfigInvalidException {
        StringBuilder name;
        block7: {
            int c2;
            name = new StringBuilder();
            while (true) {
                if ((c2 = in.read()) < 0) {
                    throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                }
                if (61 == c2) break block7;
                if (32 == c2 || 9 == c2) {
                    do {
                        if ((c2 = in.read()) < 0) {
                            throw new ConfigInvalidException(JGitText.get().unexpectedEndOfConfigFile);
                        }
                        if (61 == c2) break block7;
                        if (59 != c2 && 35 != c2 && 10 != c2) continue;
                        in.reset();
                        break block7;
                    } while (32 == c2 || 9 == c2);
                    throw new ConfigInvalidException(JGitText.get().badEntryDelimiter);
                }
                if (!Character.isLetterOrDigit((char)c2) && c2 != 45) break;
                name.append((char)c2);
            }
            if (10 == c2) {
                in.reset();
                name.append((char)c2);
            } else {
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badEntryName, name));
            }
        }
        return name.toString();
    }

    private static String readSubsectionName(StringReader in) throws ConfigInvalidException {
        int c2;
        StringBuilder r = new StringBuilder();
        block4: while ((c2 = in.read()) >= 0) {
            if (10 == c2) {
                throw new ConfigInvalidException(JGitText.get().newlineInQuotesNotAllowed);
            }
            if (92 == c2) {
                c2 = in.read();
                switch (c2) {
                    case -1: {
                        throw new ConfigInvalidException(JGitText.get().endOfFileInEscape);
                    }
                    case 34: 
                    case 92: {
                        r.append((char)c2);
                        continue block4;
                    }
                }
                r.append((char)c2);
                continue;
            }
            if (34 == c2) break;
            r.append((char)c2);
        }
        return r.toString();
    }

    private static String readValue(StringReader in) throws ConfigInvalidException {
        int c2;
        StringBuilder value2 = new StringBuilder();
        StringBuilder trailingSpaces = null;
        boolean quote = false;
        boolean inLeadingSpace = true;
        block10: while ((c2 = in.read()) >= 0) {
            if (10 == c2) {
                if (quote) {
                    throw new ConfigInvalidException(JGitText.get().newlineInQuotesNotAllowed);
                }
                in.reset();
                break;
            }
            if (!(quote || 59 != c2 && 35 != c2)) {
                if (trailingSpaces != null) {
                    trailingSpaces.setLength(0);
                }
                in.reset();
                break;
            }
            char cc = (char)c2;
            if (Character.isWhitespace(cc)) {
                if (inLeadingSpace) continue;
                if (trailingSpaces == null) {
                    trailingSpaces = new StringBuilder();
                }
                trailingSpaces.append(cc);
                continue;
            }
            inLeadingSpace = false;
            if (trailingSpaces != null) {
                value2.append((CharSequence)trailingSpaces);
                trailingSpaces.setLength(0);
            }
            if (92 == c2) {
                c2 = in.read();
                switch (c2) {
                    case -1: {
                        throw new ConfigInvalidException(JGitText.get().endOfFileInEscape);
                    }
                    case 10: {
                        continue block10;
                    }
                    case 116: {
                        value2.append('\t');
                        continue block10;
                    }
                    case 98: {
                        value2.append('\b');
                        continue block10;
                    }
                    case 110: {
                        value2.append('\n');
                        continue block10;
                    }
                    case 92: {
                        value2.append('\\');
                        continue block10;
                    }
                    case 34: {
                        value2.append('\"');
                        continue block10;
                    }
                    case 13: {
                        int next2 = in.read();
                        if (next2 == 10) continue block10;
                        if (next2 < 0) break;
                        in.reset();
                        break;
                    }
                }
                throw new ConfigInvalidException(MessageFormat.format(JGitText.get().badEscape, Character.isAlphabetic(c2) ? Character.valueOf((char)c2) : Config.toUnicodeLiteral(c2)));
            }
            if (34 == c2) {
                quote = !quote;
                continue;
            }
            value2.append(cc);
        }
        return value2.length() > 0 ? value2.toString() : null;
    }

    private static String toUnicodeLiteral(int c2) {
        return String.format("\\u%04x", c2);
    }

    public static interface ConfigEnum {
        public String toConfigValue();

        public boolean matchConfigValue(String var1);
    }

    public static interface SectionParser<T> {
        public T parse(Config var1);
    }

    private static class StringReader {
        private final char[] buf;
        private int pos;

        StringReader(String in) {
            this.buf = in.toCharArray();
        }

        int read() {
            if (this.pos >= this.buf.length) {
                return -1;
            }
            return this.buf[this.pos++];
        }

        void reset() {
            --this.pos;
        }
    }
}

