/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.util.StringUtils;

class ConfigLine {
    String prefix;
    String section;
    String subsection;
    String name;
    String value;
    String suffix;
    String includedFrom;

    ConfigLine() {
    }

    ConfigLine forValue(String newValue) {
        ConfigLine e2 = new ConfigLine();
        e2.prefix = this.prefix;
        e2.section = this.section;
        e2.subsection = this.subsection;
        e2.name = this.name;
        e2.value = newValue;
        e2.suffix = this.suffix;
        e2.includedFrom = this.includedFrom;
        return e2;
    }

    boolean match(String aSection, String aSubsection, String aKey) {
        return ConfigLine.eqIgnoreCase(this.section, aSection) && ConfigLine.eqSameCase(this.subsection, aSubsection) && ConfigLine.eqIgnoreCase(this.name, aKey);
    }

    boolean match(String aSection, String aSubsection) {
        return ConfigLine.eqIgnoreCase(this.section, aSection) && ConfigLine.eqSameCase(this.subsection, aSubsection);
    }

    private static boolean eqIgnoreCase(String a2, String b2) {
        if (a2 == null && b2 == null) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase(a2, b2);
    }

    private static boolean eqSameCase(String a2, String b2) {
        if (a2 == null && b2 == null) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        return a2.equals(b2);
    }

    public String toString() {
        if (this.section == null) {
            return "<empty>";
        }
        StringBuilder b2 = new StringBuilder(this.section);
        if (this.subsection != null) {
            b2.append(".").append(this.subsection);
        }
        if (this.name != null) {
            b2.append(".").append(this.name);
        }
        if (this.value != null) {
            b2.append("=").append(this.value);
        }
        return b2.toString();
    }
}

