/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.lib.ConfigLine;
import org.eclipse.jgit.util.StringUtils;

class ConfigSnapshot {
    final List<ConfigLine> entryList;
    final Map<Object, Object> cache;
    final ConfigSnapshot baseState;
    volatile List<ConfigLine> sorted;
    volatile SectionNames names;

    ConfigSnapshot(List<ConfigLine> entries2, ConfigSnapshot base) {
        this.entryList = entries2;
        this.cache = new ConcurrentHashMap<Object, Object>(16, 0.75f, 1);
        this.baseState = base;
    }

    Set<String> getSections() {
        return this.names().sections;
    }

    Set<String> getSubsections(String section) {
        Map<String, Set<String>> m4 = this.names().subsections;
        Set<String> r = m4.get(section);
        if (r == null) {
            r = m4.get(StringUtils.toLowerCase(section));
        }
        if (r == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(r);
    }

    Set<String> getNames(String section, String subsection) {
        return this.getNames(section, subsection, false);
    }

    Set<String> getNames(String section, String subsection, boolean recursive) {
        Map<String, String> m4 = this.getNamesInternal(section, subsection, recursive);
        return new CaseFoldingSet(m4);
    }

    private Map<String, String> getNamesInternal(String section, String subsection, boolean recursive) {
        List<ConfigLine> s2 = this.sorted();
        int idx = this.find(s2, section, subsection, "");
        if (idx < 0) {
            idx = -(idx + 1);
        }
        LinkedHashMap<String, String> m4 = new LinkedHashMap<String, String>();
        while (idx < s2.size()) {
            String l;
            ConfigLine e2;
            if (!(e2 = s2.get(idx++)).match(section, subsection)) break;
            if (e2.name == null || m4.containsKey(l = StringUtils.toLowerCase(e2.name))) continue;
            m4.put(l, e2.name);
        }
        if (recursive && this.baseState != null) {
            m4.putAll(this.baseState.getNamesInternal(section, subsection, recursive));
        }
        return m4;
    }

    String[] get(String section, String subsection, String name) {
        List<ConfigLine> s2 = this.sorted();
        int idx = this.find(s2, section, subsection, name);
        if (idx < 0) {
            return null;
        }
        int end2 = this.end(s2, idx, section, subsection, name);
        String[] r = new String[end2 - idx];
        int i2 = 0;
        while (idx < end2) {
            r[i2++] = s2.get((int)idx++).value;
        }
        return r;
    }

    private int find(List<ConfigLine> s2, String s1, String s22, String name) {
        int low = 0;
        int high = s2.size();
        while (low < high) {
            int mid = low + high >>> 1;
            ConfigLine e2 = s2.get(mid);
            int cmp = ConfigSnapshot.compare2(s1, s22, name, e2.section, e2.subsection, e2.name);
            if (cmp < 0) {
                high = mid;
                continue;
            }
            if (cmp == 0) {
                return this.first(s2, mid, s1, s22, name);
            }
            low = mid + 1;
        }
        return -(low + 1);
    }

    private int first(List<ConfigLine> s2, int i2, String s1, String s22, String n) {
        while (i2 > 0) {
            if (s2.get(i2 - 1).match(s1, s22, n)) {
                --i2;
                continue;
            }
            return i2;
        }
        return i2;
    }

    private int end(List<ConfigLine> s2, int i2, String s1, String s22, String n) {
        while (i2 < s2.size()) {
            if (s2.get(i2).match(s1, s22, n)) {
                ++i2;
                continue;
            }
            return i2;
        }
        return i2;
    }

    private List<ConfigLine> sorted() {
        List<ConfigLine> r = this.sorted;
        if (r == null) {
            this.sorted = r = ConfigSnapshot.sort(this.entryList);
        }
        return r;
    }

    private static List<ConfigLine> sort(List<ConfigLine> in) {
        ArrayList<ConfigLine> sorted2 = new ArrayList<ConfigLine>(in.size());
        for (ConfigLine line : in) {
            if (line.section == null || line.name == null) continue;
            sorted2.add(line);
        }
        Collections.sort(sorted2, new LineComparator());
        return sorted2;
    }

    private static int compare2(String aSection, String aSubsection, String aName, String bSection, String bSubsection, String bName) {
        int c2 = StringUtils.compareIgnoreCase(aSection, bSection);
        if (c2 != 0) {
            return c2;
        }
        if (aSubsection == null && bSubsection != null) {
            return -1;
        }
        if (aSubsection != null && bSubsection == null) {
            return 1;
        }
        if (aSubsection != null && (c2 = StringUtils.compareWithCase(aSubsection, bSubsection)) != 0) {
            return c2;
        }
        return StringUtils.compareIgnoreCase(aName, bName);
    }

    private SectionNames names() {
        SectionNames n = this.names;
        if (n == null) {
            this.names = n = new SectionNames(this);
        }
        return n;
    }

    private static class CaseFoldingSet
    extends AbstractSet<String> {
        private final Map<String, String> names;

        CaseFoldingSet(Map<String, String> names2) {
            this.names = names2;
        }

        @Override
        public boolean contains(Object needle) {
            if (needle instanceof String) {
                String n = (String)needle;
                return this.names.containsKey(n) || this.names.containsKey(StringUtils.toLowerCase(n));
            }
            return false;
        }

        @Override
        public Iterator<String> iterator() {
            final Iterator<String> i2 = this.names.values().iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return i2.hasNext();
                }

                @Override
                public String next() {
                    return (String)i2.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.names.size();
        }
    }

    private static class LineComparator
    implements Comparator<ConfigLine> {
        private LineComparator() {
        }

        @Override
        public int compare(ConfigLine a2, ConfigLine b2) {
            return ConfigSnapshot.compare2(a2.section, a2.subsection, a2.name, b2.section, b2.subsection, b2.name);
        }
    }

    private static class SectionNames {
        final CaseFoldingSet sections;
        final Map<String, Set<String>> subsections;

        SectionNames(ConfigSnapshot cfg) {
            LinkedHashMap<String, String> sec = new LinkedHashMap<String, String>();
            HashMap<String, Set<String>> sub2 = new HashMap<String, Set<String>>();
            while (cfg != null) {
                for (ConfigLine e2 : cfg.entryList) {
                    if (e2.section == null) continue;
                    String l1 = StringUtils.toLowerCase(e2.section);
                    if (!sec.containsKey(l1)) {
                        sec.put(l1, e2.section);
                    }
                    if (e2.subsection == null) continue;
                    LinkedHashSet<String> m4 = (LinkedHashSet<String>)sub2.get(l1);
                    if (m4 == null) {
                        m4 = new LinkedHashSet<String>();
                        sub2.put(l1, m4);
                    }
                    m4.add(e2.subsection);
                }
                cfg = cfg.baseState;
            }
            this.sections = new CaseFoldingSet(sec);
            this.subsections = sub2;
        }
    }
}

