/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreConfig {
    private static final Logger LOG = LoggerFactory.getLogger(CoreConfig.class);
    public static final Config.SectionParser<CoreConfig> KEY = CoreConfig::new;
    public static final boolean DEFAULT_COMMIT_GRAPH_ENABLE = false;
    private final int compression;
    private final int packIndexVersion;
    private final String excludesfile;
    private final String attributesfile;
    private final boolean commitGraph;
    private final TrustStat trustStat;
    private final TrustStat trustPackedRefsStat;
    private final TrustStat trustLooseRefStat;
    private final TrustStat trustPackStat;
    private final TrustStat trustLooseObjectStat;
    private final TrustStat trustTablesListStat;

    CoreConfig(Config rc2) {
        this.compression = rc2.getInt("core", "compression", -1);
        this.packIndexVersion = rc2.getInt("pack", "indexversion", 2);
        this.excludesfile = rc2.getString("core", null, "excludesfile");
        this.attributesfile = rc2.getString("core", null, "attributesfile");
        this.commitGraph = rc2.getBoolean("core", "commitGraph", false);
        this.trustStat = CoreConfig.parseTrustStat(rc2);
        this.trustPackedRefsStat = this.parseTrustPackedRefsStat(rc2);
        this.trustLooseRefStat = this.parseTrustLooseRefStat(rc2);
        this.trustPackStat = this.parseTrustPackFileStat(rc2);
        this.trustLooseObjectStat = this.parseTrustLooseObjectFileStat(rc2);
        this.trustTablesListStat = this.parseTablesListStat(rc2);
    }

    private static TrustStat parseTrustStat(Config rc2) {
        Boolean tfs = rc2.getBoolean("core", "trustfolderstat");
        TrustStat ts = (TrustStat)rc2.getEnum(TrustStat.values(), "core", null, "truststat");
        if (tfs != null) {
            if (ts == null) {
                LOG.warn(JGitText.get().deprecatedTrustFolderStat);
                return tfs != false ? TrustStat.ALWAYS : TrustStat.NEVER;
            }
            LOG.warn(JGitText.get().precedenceTrustConfig);
        }
        if (ts == null) {
            ts = TrustStat.ALWAYS;
        } else if (ts == TrustStat.INHERIT) {
            LOG.warn(JGitText.get().invalidTrustStat);
            ts = TrustStat.ALWAYS;
        }
        return ts;
    }

    private TrustStat parseTrustPackedRefsStat(Config rc2) {
        return this.inheritParseTrustStat(rc2, "trustPackedRefsStat");
    }

    private TrustStat parseTrustLooseRefStat(Config rc2) {
        return this.inheritParseTrustStat(rc2, "trustLooseRefStat");
    }

    private TrustStat parseTrustPackFileStat(Config rc2) {
        return this.inheritParseTrustStat(rc2, "trustPackStat");
    }

    private TrustStat parseTrustLooseObjectFileStat(Config rc2) {
        return this.inheritParseTrustStat(rc2, "trustLooseObjectStat");
    }

    private TrustStat inheritParseTrustStat(Config rc2, String key2) {
        TrustStat t2 = rc2.getEnum("core", null, key2, TrustStat.INHERIT);
        return t2 == TrustStat.INHERIT ? this.trustStat : t2;
    }

    private TrustStat parseTablesListStat(Config rc2) {
        TrustStat t2 = rc2.getEnum("core", null, "trustTablesListStat", TrustStat.INHERIT);
        return t2 == TrustStat.INHERIT ? this.trustStat : t2;
    }

    public int getCompression() {
        return this.compression;
    }

    public int getPackIndexVersion() {
        return this.packIndexVersion;
    }

    public String getExcludesFile() {
        return this.excludesfile;
    }

    public String getAttributesFile() {
        return this.attributesfile;
    }

    public boolean enableCommitGraph() {
        return this.commitGraph;
    }

    public TrustStat getTrustPackedRefsStat() {
        return this.trustPackedRefsStat;
    }

    public TrustStat getTrustLooseRefStat() {
        return this.trustLooseRefStat;
    }

    public TrustStat getTrustPackStat() {
        return this.trustPackStat;
    }

    public TrustStat getTrustLooseObjectStat() {
        return this.trustLooseObjectStat;
    }

    public TrustStat getTrustTablesListStat() {
        return this.trustTablesListStat;
    }

    public static enum AutoCRLF {
        FALSE,
        TRUE,
        INPUT;

    }

    public static enum CheckStat {
        MINIMAL,
        DEFAULT;

    }

    public static enum EOL {
        CRLF,
        LF,
        NATIVE;

    }

    public static enum EolStreamType {
        TEXT_CRLF,
        TEXT_LF,
        AUTO_CRLF,
        AUTO_LF,
        DIRECT;

    }

    public static enum HideDotFiles {
        FALSE,
        TRUE,
        DOTGITONLY;

    }

    public static enum LogRefUpdates {
        FALSE,
        TRUE,
        ALWAYS;

    }

    public static enum SymLinks {
        FALSE,
        TRUE;

    }

    @Deprecated(since="7.2", forRemoval=true)
    public static enum TrustLooseRefStat {
        ALWAYS,
        AFTER_OPEN;

    }

    @Deprecated(since="7.2", forRemoval=true)
    public static enum TrustPackedRefsStat {
        NEVER,
        ALWAYS,
        AFTER_OPEN,
        UNSET;

    }

    public static enum TrustStat {
        NEVER,
        ALWAYS,
        AFTER_OPEN,
        INHERIT;

    }
}

