/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.TypedConfigGetter;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.StringUtils;

public class DefaultTypedConfigGetter
implements TypedConfigGetter {
    @Override
    public boolean getBoolean(Config config2, String section, String subsection, String name, boolean defaultValue) {
        return DefaultTypedConfigGetter.neverNull(this.getBoolean(config2, section, subsection, name, (Boolean)defaultValue));
    }

    @Override
    @Nullable
    public Boolean getBoolean(Config config2, String section, String subsection, String name, @Nullable Boolean defaultValue) {
        String n = config2.getString(section, subsection, name);
        if (n == null) {
            return defaultValue;
        }
        if (Config.isMissing(n)) {
            return Boolean.TRUE;
        }
        try {
            return StringUtils.toBoolean(n);
        }
        catch (IllegalArgumentException err) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidBooleanValue, section, name, n), err);
        }
    }

    @Override
    @Nullable
    public <T extends Enum<?>> T getEnum(Config config2, T[] all, String section, String subsection, String name, @Nullable T defaultValue) {
        String value2 = config2.getString(section, subsection, name);
        if (value2 == null) {
            return defaultValue;
        }
        if (all[0] instanceof Config.ConfigEnum) {
            T[] TArray = all;
            int n = all.length;
            int n2 = 0;
            while (n2 < n) {
                T t2 = TArray[n2];
                if (((Config.ConfigEnum)t2).matchConfigValue(value2)) {
                    return t2;
                }
                ++n2;
            }
        }
        String n = value2.replace(' ', '_');
        n = n.replace('-', '_');
        T trueState = null;
        T falseState = null;
        T[] TArray = all;
        int n3 = all.length;
        int n4 = 0;
        while (n4 < n3) {
            T e2 = TArray[n4];
            if (StringUtils.equalsIgnoreCase(((Enum)e2).name(), n)) {
                return e2;
            }
            if (StringUtils.equalsIgnoreCase(((Enum)e2).name(), "TRUE")) {
                trueState = e2;
            } else if (StringUtils.equalsIgnoreCase(((Enum)e2).name(), "FALSE")) {
                falseState = e2;
            }
            ++n4;
        }
        if (trueState != null && falseState != null) {
            try {
                return StringUtils.toBoolean(n) ? trueState : falseState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (subsection != null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported3, section, subsection, name, value2));
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported2, section, name, value2));
    }

    @Override
    public int getInt(Config config2, String section, String subsection, String name, int defaultValue) {
        return DefaultTypedConfigGetter.neverNull(this.getInt(config2, section, subsection, name, (Integer)defaultValue));
    }

    @Override
    @Nullable
    public Integer getInt(Config config2, String section, String subsection, String name, @Nullable Integer defaultValue) {
        Long longDefault = defaultValue != null ? Long.valueOf(defaultValue.longValue()) : null;
        Long val = config2.getLong(section, subsection, name);
        if (val == null) {
            val = longDefault;
        }
        if (val == null) {
            return null;
        }
        if (Integer.MIN_VALUE <= val && val <= Integer.MAX_VALUE) {
            return Math.toIntExact(val);
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().integerValueOutOfRange, section, name));
    }

    @Override
    public int getIntInRange(Config config2, String section, String subsection, String name, int minValue, int maxValue, int defaultValue) {
        return DefaultTypedConfigGetter.neverNull(this.getIntInRange(config2, section, subsection, name, minValue, maxValue, (Integer)defaultValue));
    }

    @Override
    public Integer getIntInRange(Config config2, String section, String subsection, String name, int minValue, int maxValue, Integer defaultValue) {
        Integer val = this.getInt(config2, section, subsection, name, defaultValue);
        if (val == null) {
            return null;
        }
        if (val >= minValue && val <= maxValue || val == Integer.MIN_VALUE) {
            return val;
        }
        if (subsection == null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().integerValueNotInRange, section, name, val, minValue, maxValue));
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().integerValueNotInRangeSubSection, section, subsection, name, val, minValue, maxValue));
    }

    @Override
    public long getLong(Config config2, String section, String subsection, String name, long defaultValue) {
        return DefaultTypedConfigGetter.neverNull(this.getLong(config2, section, subsection, name, (Long)defaultValue));
    }

    @Override
    @Nullable
    public Long getLong(Config config2, String section, String subsection, String name, @Nullable Long defaultValue) {
        String str = config2.getString(section, subsection, name);
        if (str == null) {
            return defaultValue;
        }
        try {
            return StringUtils.parseLongWithSuffix(str, false);
        }
        catch (StringIndexOutOfBoundsException e2) {
            return defaultValue;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidIntegerValue, section, name, str), nfe);
        }
    }

    @Override
    public long getTimeUnit(Config config2, String section, String subsection, String name, long defaultValue, TimeUnit wantUnit) {
        return DefaultTypedConfigGetter.neverNull(this.getTimeUnit(config2, section, subsection, name, (Long)defaultValue, wantUnit));
    }

    @Override
    public Long getTimeUnit(Config config2, String section, String subsection, String name, @Nullable Long defaultValue, TimeUnit wantUnit) {
        int inputMul;
        TimeUnit inputUnit;
        String valueString = config2.getString(section, subsection, name);
        if (valueString == null) {
            return defaultValue;
        }
        String s2 = valueString.trim();
        if (s2.length() == 0) {
            return defaultValue;
        }
        if (s2.startsWith("-")) {
            throw DefaultTypedConfigGetter.notTimeUnit(section, subsection, name, valueString);
        }
        Matcher m4 = Pattern.compile("^(0|[1-9][0-9]*)\\s*(.*)$").matcher(valueString);
        if (!m4.matches()) {
            return defaultValue;
        }
        String digits = m4.group(1);
        String unitName = m4.group(2).trim();
        if (unitName.isEmpty()) {
            inputUnit = wantUnit;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "ns", "nanoseconds")) {
            inputUnit = TimeUnit.NANOSECONDS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "us", "microseconds")) {
            inputUnit = TimeUnit.MICROSECONDS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "ms", "milliseconds")) {
            inputUnit = TimeUnit.MILLISECONDS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "s", "sec", "second", "seconds")) {
            inputUnit = TimeUnit.SECONDS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "m", "min", "minute", "minutes")) {
            inputUnit = TimeUnit.MINUTES;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "h", "hr", "hour", "hours")) {
            inputUnit = TimeUnit.HOURS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "d", "day", "days")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "w", "week", "weeks")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 7;
        } else if (DefaultTypedConfigGetter.match(unitName, "mon", "month", "months")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 30;
        } else if (DefaultTypedConfigGetter.match(unitName, "y", "year", "years")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 365;
        } else {
            throw DefaultTypedConfigGetter.notTimeUnit(section, subsection, name, valueString);
        }
        try {
            return wantUnit.convert(Long.parseLong(digits) * (long)inputMul, inputUnit);
        }
        catch (NumberFormatException nfe) {
            IllegalArgumentException iae = DefaultTypedConfigGetter.notTimeUnit(section, subsection, unitName, valueString);
            iae.initCause(nfe);
            throw iae;
        }
    }

    private static boolean match(String a2, String ... cases) {
        String[] stringArray = cases;
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            String b2 = stringArray[n2];
            if (b2 != null && b2.equalsIgnoreCase(a2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IllegalArgumentException notTimeUnit(String section, String subsection, String name, String valueString) {
        if (subsection != null) {
            return new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeUnitValue3, section, subsection, name, valueString));
        }
        return new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeUnitValue2, section, name, valueString));
    }

    @Override
    @NonNull
    public List<RefSpec> getRefSpecs(Config config2, String section, String subsection, String name) {
        String[] values2 = config2.getStringList(section, subsection, name);
        ArrayList<RefSpec> result2 = new ArrayList<RefSpec>(values2.length);
        String[] stringArray = values2;
        int n = values2.length;
        int n2 = 0;
        while (n2 < n) {
            String spec = stringArray[n2];
            result2.add(new RefSpec(spec));
            ++n2;
        }
        return result2;
    }

    @NonNull
    private static <T> T neverNull(T one) {
        if (one == null) {
            throw new IllegalArgumentException();
        }
        return one;
    }
}

