/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.IO;

public class ObjectIdSerializer {
    private static final byte NULL_MARKER = 0;
    private static final byte NON_NULL_MARKER = 1;

    public static void write(OutputStream out2, @Nullable AnyObjectId id) throws IOException {
        if (id != null) {
            out2.write(1);
            ObjectIdSerializer.writeWithoutMarker(out2, id);
        } else {
            out2.write(0);
        }
    }

    public static void writeWithoutMarker(OutputStream out2, @NonNull AnyObjectId id) throws IOException {
        id.copyRawTo(out2);
    }

    @Nullable
    public static ObjectId read(InputStream in) throws IOException {
        byte marker = (byte)in.read();
        switch (marker) {
            case 0: {
                return null;
            }
            case 1: {
                return ObjectIdSerializer.readWithoutMarker(in);
            }
        }
        throw new IOException("Invalid flag before ObjectId: " + marker);
    }

    @NonNull
    public static ObjectId readWithoutMarker(InputStream in) throws IOException {
        byte[] b2 = new byte[20];
        IO.readFully(in, b2, 0, 20);
        return ObjectId.fromRaw(b2);
    }

    private ObjectIdSerializer() {
    }
}

