/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.util.sha1.SHA1;

public abstract class ObjectInserter
implements AutoCloseable {
    private final SHA1 hasher = SHA1.newInstance();
    private byte[] tempBuffer;

    protected ObjectInserter() {
    }

    protected byte[] buffer() {
        byte[] b2 = this.tempBuffer;
        if (b2 == null) {
            this.tempBuffer = b2 = new byte[8192];
        }
        return b2;
    }

    protected SHA1 digest() {
        return this.hasher.reset();
    }

    public ObjectId idFor(int type2, byte[] data2) {
        return this.idFor(type2, data2, 0, data2.length);
    }

    public ObjectId idFor(int type2, byte[] data2, int off, int len2) {
        SHA1 md = SHA1.newInstance();
        md.update(Constants.encodedTypeString(type2));
        md.update((byte)32);
        md.update(Constants.encodeASCII(len2));
        md.update((byte)0);
        md.update(data2, off, len2);
        return md.toObjectId();
    }

    public ObjectId idFor(int objectType, long length, InputStream in) throws IOException {
        SHA1 md = SHA1.newInstance();
        md.update(Constants.encodedTypeString(objectType));
        md.update((byte)32);
        md.update(Constants.encodeASCII(length));
        md.update((byte)0);
        byte[] buf = this.buffer();
        while (length > 0L) {
            int n = in.read(buf, 0, (int)Math.min(length, (long)buf.length));
            if (n < 0) {
                throw new EOFException(JGitText.get().unexpectedEndOfInput);
            }
            md.update(buf, 0, n);
            length -= (long)n;
        }
        return md.toObjectId();
    }

    public ObjectId idFor(TreeFormatter formatter) {
        return formatter.computeId(this);
    }

    public final ObjectId insert(TreeFormatter formatter) throws IOException {
        return formatter.insertTo(this);
    }

    public final ObjectId insert(CommitBuilder builder) throws IOException {
        return this.insert(1, builder.build());
    }

    public final ObjectId insert(TagBuilder builder) throws IOException {
        return this.insert(4, builder.build());
    }

    public ObjectId insert(int type2, byte[] data2) throws IOException {
        return this.insert(type2, data2, 0, data2.length);
    }

    public ObjectId insert(int type2, byte[] data2, int off, int len2) throws IOException {
        return this.insert(type2, len2, new ByteArrayInputStream(data2, off, len2));
    }

    public abstract ObjectId insert(int var1, long var2, InputStream var4) throws IOException;

    public abstract PackParser newPackParser(InputStream var1) throws IOException;

    public abstract ObjectReader newReader();

    public abstract void flush() throws IOException;

    @Override
    public abstract void close();

    public static abstract class Filter
    extends ObjectInserter {
        protected abstract ObjectInserter delegate();

        @Override
        protected byte[] buffer() {
            return this.delegate().buffer();
        }

        @Override
        public ObjectId idFor(int type2, byte[] data2) {
            return this.delegate().idFor(type2, data2);
        }

        @Override
        public ObjectId idFor(int type2, byte[] data2, int off, int len2) {
            return this.delegate().idFor(type2, data2, off, len2);
        }

        @Override
        public ObjectId idFor(int objectType, long length, InputStream in) throws IOException {
            return this.delegate().idFor(objectType, length, in);
        }

        @Override
        public ObjectId idFor(TreeFormatter formatter) {
            return this.delegate().idFor(formatter);
        }

        @Override
        public ObjectId insert(int type2, byte[] data2) throws IOException {
            return this.delegate().insert(type2, data2);
        }

        @Override
        public ObjectId insert(int type2, byte[] data2, int off, int len2) throws IOException {
            return this.delegate().insert(type2, data2, off, len2);
        }

        @Override
        public ObjectId insert(int objectType, long length, InputStream in) throws IOException {
            return this.delegate().insert(objectType, length, in);
        }

        @Override
        public PackParser newPackParser(InputStream in) throws IOException {
            return this.delegate().newPackParser(in);
        }

        @Override
        public ObjectReader newReader() {
            final ObjectReader dr = this.delegate().newReader();
            return new ObjectReader.Filter(){

                @Override
                protected ObjectReader delegate() {
                    return dr;
                }

                @Override
                public ObjectInserter getCreatedFromInserter() {
                    return this;
                }
            };
        }

        @Override
        public void flush() throws IOException {
            this.delegate().flush();
        }

        @Override
        public void close() {
            this.delegate().close();
        }
    }

    public static class Formatter
    extends ObjectInserter {
        @Override
        public ObjectId insert(int objectType, long length, InputStream in) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PackParser newPackParser(InputStream in) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectReader newReader() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() {
        }
    }
}

