/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.revwalk.BitmappedObjectReachabilityChecker;
import org.eclipse.jgit.internal.revwalk.BitmappedReachabilityChecker;
import org.eclipse.jgit.internal.revwalk.PedestrianObjectReachabilityChecker;
import org.eclipse.jgit.internal.revwalk.PedestrianReachabilityChecker;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectLoaderQueue;
import org.eclipse.jgit.lib.AsyncObjectSizeQueue;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.revwalk.ObjectReachabilityChecker;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.ReachabilityChecker;
import org.eclipse.jgit.revwalk.RevWalk;

public abstract class ObjectReader
implements AutoCloseable {
    public static final int OBJ_ANY = -1;
    protected int streamFileThreshold;

    public abstract ObjectReader newReader();

    public AbbreviatedObjectId abbreviate(AnyObjectId objectId) throws IOException {
        return this.abbreviate(objectId, 7);
    }

    public AbbreviatedObjectId abbreviate(AnyObjectId objectId, int len2) throws IOException {
        if (len2 == 40) {
            return AbbreviatedObjectId.fromObjectId(objectId);
        }
        AbbreviatedObjectId abbrev = objectId.abbreviate(len2);
        Collection<ObjectId> matches2 = this.resolve(abbrev);
        while (1 < matches2.size() && len2 < 40) {
            abbrev = objectId.abbreviate(++len2);
            ArrayList<ObjectId> n = new ArrayList<ObjectId>(8);
            for (ObjectId candidate : matches2) {
                if (abbrev.prefixCompare(candidate) != 0) continue;
                n.add(candidate);
            }
            matches2 = 1 < n.size() ? n : this.resolve(abbrev);
        }
        return abbrev;
    }

    public abstract Collection<ObjectId> resolve(AbbreviatedObjectId var1) throws IOException;

    public boolean has(AnyObjectId objectId) throws IOException {
        return this.has(objectId, -1);
    }

    public boolean has(AnyObjectId objectId, int typeHint) throws IOException {
        try {
            this.open(objectId, typeHint);
            return true;
        }
        catch (MissingObjectException notFound) {
            return false;
        }
    }

    public ObjectLoader open(AnyObjectId objectId) throws MissingObjectException, IOException {
        return this.open(objectId, -1);
    }

    public abstract ObjectLoader open(AnyObjectId var1, int var2) throws MissingObjectException, IncorrectObjectTypeException, IOException;

    public abstract Set<ObjectId> getShallowCommits() throws IOException;

    public <T extends ObjectId> AsyncObjectLoaderQueue<T> open(Iterable<T> objectIds, boolean reportMissing) {
        final Iterator<T> idItr = objectIds.iterator();
        return new AsyncObjectLoaderQueue<T>(){
            private T cur;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (ObjectId)idItr.next();
                    return true;
                }
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur;
            }

            @Override
            public ObjectLoader open() throws IOException {
                return ObjectReader.this.open((AnyObjectId)this.cur, -1);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public void release() {
            }
        };
    }

    public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.open(objectId, typeHint).getSize();
    }

    public boolean isNotLargerThan(AnyObjectId objectId, int typeHint, long size2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.open(objectId, typeHint).getSize() <= size2;
    }

    public <T extends ObjectId> AsyncObjectSizeQueue<T> getObjectSize(Iterable<T> objectIds, boolean reportMissing) {
        final Iterator<T> idItr = objectIds.iterator();
        return new AsyncObjectSizeQueue<T>(){
            private T cur;
            private long sz;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (ObjectId)idItr.next();
                    this.sz = ObjectReader.this.getObjectSize((AnyObjectId)this.cur, -1);
                    return true;
                }
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur;
            }

            @Override
            public long getSize() {
                return this.sz;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public void release() {
            }
        };
    }

    public void setAvoidUnreachableObjects(boolean avoid) {
    }

    public BitmapIndex getBitmapIndex() throws IOException {
        return null;
    }

    @NonNull
    public ReachabilityChecker createReachabilityChecker(RevWalk rw) throws IOException {
        if (this.getBitmapIndex() != null) {
            return new BitmappedReachabilityChecker(rw);
        }
        return new PedestrianReachabilityChecker(true, rw);
    }

    @NonNull
    public ObjectReachabilityChecker createObjectReachabilityChecker(ObjectWalk ow) throws IOException {
        if (this.getBitmapIndex() != null) {
            return new BitmappedObjectReachabilityChecker(ow);
        }
        return new PedestrianObjectReachabilityChecker(ow);
    }

    public Optional<CommitGraph> getCommitGraph() throws IOException {
        return Optional.empty();
    }

    @Nullable
    public ObjectInserter getCreatedFromInserter() {
        return null;
    }

    @Override
    public abstract void close();

    public void setStreamFileThreshold(int threshold) {
        this.streamFileThreshold = threshold;
    }

    public int getStreamFileThreshold() {
        return this.streamFileThreshold;
    }

    public static abstract class Filter
    extends ObjectReader {
        protected abstract ObjectReader delegate();

        @Override
        public ObjectReader newReader() {
            return this.delegate().newReader();
        }

        @Override
        public AbbreviatedObjectId abbreviate(AnyObjectId objectId) throws IOException {
            return this.delegate().abbreviate(objectId);
        }

        @Override
        public AbbreviatedObjectId abbreviate(AnyObjectId objectId, int len2) throws IOException {
            return this.delegate().abbreviate(objectId, len2);
        }

        @Override
        public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
            return this.delegate().resolve(id);
        }

        @Override
        public boolean has(AnyObjectId objectId) throws IOException {
            return this.delegate().has(objectId);
        }

        @Override
        public boolean has(AnyObjectId objectId, int typeHint) throws IOException {
            return this.delegate().has(objectId, typeHint);
        }

        @Override
        public ObjectLoader open(AnyObjectId objectId) throws MissingObjectException, IOException {
            return this.delegate().open(objectId);
        }

        @Override
        public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.delegate().open(objectId, typeHint);
        }

        @Override
        public Set<ObjectId> getShallowCommits() throws IOException {
            return this.delegate().getShallowCommits();
        }

        @Override
        public <T extends ObjectId> AsyncObjectLoaderQueue<T> open(Iterable<T> objectIds, boolean reportMissing) {
            return this.delegate().open(objectIds, reportMissing);
        }

        @Override
        public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.delegate().getObjectSize(objectId, typeHint);
        }

        @Override
        public <T extends ObjectId> AsyncObjectSizeQueue<T> getObjectSize(Iterable<T> objectIds, boolean reportMissing) {
            return this.delegate().getObjectSize(objectIds, reportMissing);
        }

        @Override
        public void setAvoidUnreachableObjects(boolean avoid) {
            this.delegate().setAvoidUnreachableObjects(avoid);
        }

        @Override
        public BitmapIndex getBitmapIndex() throws IOException {
            return this.delegate().getBitmapIndex();
        }

        @Override
        public Optional<CommitGraph> getCommitGraph() throws IOException {
            return this.delegate().getCommitGraph();
        }

        @Override
        @Nullable
        public ObjectInserter getCreatedFromInserter() {
            return this.delegate().getCreatedFromInserter();
        }

        @Override
        public void close() {
            this.delegate().close();
        }
    }
}

