/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCacheConfig;
import org.eclipse.jgit.lib.internal.WorkQueue;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryCache {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryCache.class);
    private static final RepositoryCache cache = new RepositoryCache();
    private final Map<Key, Repository> cacheMap;
    private final Lock[] openLocks;
    private ScheduledFuture<?> cleanupTask;
    private volatile long expireAfter;
    private final Object schedulerLock = new Lock();

    public static Repository open(Key location) throws IOException, RepositoryNotFoundException {
        return RepositoryCache.open(location, true);
    }

    public static Repository open(Key location, boolean mustExist) throws IOException {
        return cache.openRepository(location, mustExist);
    }

    public static void register(Repository db) {
        if (db.getDirectory() != null) {
            FileKey key2 = FileKey.exact(db.getDirectory(), db.getFS());
            cache.registerRepository(key2, db);
        }
    }

    public static void close(@NonNull Repository db) {
        if (db.getDirectory() != null) {
            FileKey key2 = FileKey.exact(db.getDirectory(), db.getFS());
            cache.unregisterAndCloseRepository(key2);
        }
    }

    public static void unregister(Repository db) {
        if (db.getDirectory() != null) {
            RepositoryCache.unregister(FileKey.exact(db.getDirectory(), db.getFS()));
        }
    }

    public static void unregister(Key location) {
        cache.unregisterRepository(location);
    }

    public static Collection<Key> getRegisteredKeys() {
        return cache.getKeys();
    }

    static boolean isCached(@NonNull Repository repo) {
        File gitDir = repo.getDirectory();
        if (gitDir == null) {
            return false;
        }
        FileKey key2 = new FileKey(gitDir, repo.getFS());
        return RepositoryCache.cache.cacheMap.get(key2) == repo;
    }

    public static void clear() {
        cache.clearAll();
    }

    static void clearExpired() {
        cache.clearAllExpired();
    }

    static void reconfigure(RepositoryCacheConfig repositoryCacheConfig) {
        cache.configureEviction(repositoryCacheConfig);
    }

    private RepositoryCache() {
        this.cacheMap = new ConcurrentHashMap<Key, Repository>();
        this.openLocks = new Lock[4];
        int i2 = 0;
        while (i2 < this.openLocks.length) {
            this.openLocks[i2] = new Lock();
            ++i2;
        }
        this.configureEviction(new RepositoryCacheConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureEviction(RepositoryCacheConfig repositoryCacheConfig) {
        this.expireAfter = repositoryCacheConfig.getExpireAfter();
        ScheduledThreadPoolExecutor scheduler = WorkQueue.getExecutor();
        Object object = this.schedulerLock;
        synchronized (object) {
            long delay2;
            if (this.cleanupTask != null) {
                this.cleanupTask.cancel(false);
            }
            if ((delay2 = repositoryCacheConfig.getCleanupDelay()) == 0L) {
                return;
            }
            this.cleanupTask = scheduler.scheduleWithFixedDelay(() -> {
                try {
                    cache.clearAllExpired();
                }
                catch (Throwable e2) {
                    LOG.error(e2.getMessage(), e2);
                }
            }, delay2, delay2, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Repository openRepository(Key location, boolean mustExist) throws IOException {
        Repository db = this.cacheMap.get(location);
        if (db == null) {
            Lock lock = this.lockFor(location);
            synchronized (lock) {
                db = this.cacheMap.get(location);
                if (db == null) {
                    db = location.open(mustExist);
                    this.cacheMap.put(location, db);
                } else {
                    db.incrementOpen();
                }
            }
        } else {
            db.incrementOpen();
        }
        return db;
    }

    private void registerRepository(Key location, Repository db) {
        Throwable throwable = null;
        Object var4_4 = null;
        try {
            Repository oldDb = this.cacheMap.put(location, db);
            if (oldDb != null) {
                oldDb.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Repository unregisterRepository(Key location) {
        return this.cacheMap.remove(location);
    }

    private boolean isExpired(Repository db) {
        return db != null && db.useCnt.get() <= 0 && System.currentTimeMillis() - db.closedAt.get() > this.expireAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAndCloseRepository(Key location) {
        Lock lock = this.lockFor(location);
        synchronized (lock) {
            Repository oldDb = this.unregisterRepository(location);
            if (oldDb != null) {
                oldDb.doClose();
            }
        }
    }

    private Collection<Key> getKeys() {
        return new ArrayList<Key>(this.cacheMap.keySet());
    }

    private void clearAllExpired() {
        for (Repository db : this.cacheMap.values()) {
            if (!this.isExpired(db)) continue;
            RepositoryCache.close(db);
        }
    }

    private void clearAll() {
        for (Key k2 : this.cacheMap.keySet()) {
            this.unregisterAndCloseRepository(k2);
        }
    }

    private Lock lockFor(Key location) {
        return this.openLocks[(location.hashCode() >>> 1) % this.openLocks.length];
    }

    public static class FileKey
    implements Key {
        private final File path;
        private final FS fs;

        public static FileKey exact(File directory, FS fs) {
            return new FileKey(directory, fs);
        }

        public static FileKey lenient(File directory, FS fs) {
            File gitdir = FileKey.resolve(directory, fs);
            return new FileKey(gitdir != null ? gitdir : directory, fs);
        }

        protected FileKey(File directory, FS fs) {
            this.path = FileKey.canonical(directory);
            this.fs = fs;
        }

        private static File canonical(File path2) {
            try {
                return path2.getCanonicalFile();
            }
            catch (IOException e2) {
                return path2.getAbsoluteFile();
            }
        }

        public final File getFile() {
            return this.path;
        }

        @Override
        public Repository open(boolean mustExist) throws IOException {
            if (mustExist && !FileKey.isGitRepository(this.path, this.fs)) {
                throw new RepositoryNotFoundException(this.path);
            }
            return new FileRepository(this.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof FileKey && this.path.equals(((FileKey)o).path);
        }

        public String toString() {
            return this.path.toString();
        }

        public static boolean isGitRepository(File dir, FS fs) {
            File commonDir;
            try {
                commonDir = fs.getCommonDir(dir);
            }
            catch (IOException e2) {
                commonDir = null;
            }
            if (commonDir == null) {
                commonDir = dir;
            }
            return fs.resolve(commonDir, "objects").exists() && fs.resolve(commonDir, "refs").exists() && (fs.resolve(commonDir, "reftable").exists() || FileKey.isValidHead(new File(commonDir, "HEAD")));
        }

        private static boolean isValidHead(File head2) {
            String ref = FileKey.readFirstLine(head2);
            return ref != null && (ref.startsWith("ref: refs/") || ObjectId.isId(ref));
        }

        private static String readFirstLine(File head2) {
            int n;
            byte[] buf;
            block4: {
                try {
                    buf = IO.readFully(head2, 4096);
                    n = buf.length;
                    if (n != 0) break block4;
                    return null;
                }
                catch (IOException e2) {
                    return null;
                }
            }
            if (buf[n - 1] == 10) {
                --n;
            }
            return RawParseUtils.decode(buf, 0, n);
        }

        public static File resolve(File directory, FS fs) {
            File bareDir;
            if (FileKey.isGitRepository(directory, fs)) {
                return directory;
            }
            File dotDir = new File(directory, ".git");
            if (dotDir.isFile()) {
                try {
                    File refDir = BaseRepositoryBuilder.getSymRef(directory, dotDir, fs);
                    if (refDir != null && FileKey.isGitRepository(refDir, fs)) {
                        return refDir;
                    }
                }
                catch (IOException refDir) {}
            } else if (FileKey.isGitRepository(dotDir, fs)) {
                return dotDir;
            }
            if (FileKey.isGitRepository(bareDir = new File(directory.getParentFile(), directory.getName() + ".git"), fs)) {
                return bareDir;
            }
            return null;
        }
    }

    public static interface Key {
        public Repository open(boolean var1) throws IOException, RepositoryNotFoundException;
    }

    private static class Lock {
        private Lock() {
        }
    }
}

