/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SignatureVerifier;
import org.eclipse.jgit.lib.SignatureVerifierFactory;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignatureVerifiers {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureVerifiers.class);
    private static final byte[] PGP_PREFIX = "-----BEGIN PGP SIGNATURE-----".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] X509_PREFIX = "-----BEGIN SIGNED MESSAGE-----".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SSH_PREFIX = "-----BEGIN SSH SIGNATURE-----".getBytes(StandardCharsets.US_ASCII);
    private static final Map<GpgConfig.GpgFormat, SignatureVerifierFactory> FACTORIES = SignatureVerifiers.loadSignatureVerifiers();
    private static final Map<GpgConfig.GpgFormat, SignatureVerifier> VERIFIERS = new ConcurrentHashMap<GpgConfig.GpgFormat, SignatureVerifier>();

    private static Map<GpgConfig.GpgFormat, SignatureVerifierFactory> loadSignatureVerifiers() {
        EnumMap<GpgConfig.GpgFormat, SignatureVerifierFactory> result2 = new EnumMap<GpgConfig.GpgFormat, SignatureVerifierFactory>(GpgConfig.GpgFormat.class);
        try {
            for (SignatureVerifierFactory factory2 : ServiceLoader.load(SignatureVerifierFactory.class)) {
                GpgConfig.GpgFormat format2 = factory2.getType();
                SignatureVerifierFactory existing = (SignatureVerifierFactory)result2.get(format2);
                if (existing != null) {
                    LOG.warn("{}", (Object)MessageFormat.format(JGitText.get().signatureServiceConflict, "SignatureVerifierFactory", format2, existing.getClass().getCanonicalName(), factory2.getClass().getCanonicalName()));
                    continue;
                }
                result2.put(format2, factory2);
            }
        }
        catch (ServiceConfigurationError e2) {
            LOG.error(e2.getMessage(), e2);
        }
        return result2;
    }

    private SignatureVerifiers() {
    }

    public static SignatureVerifier get(@NonNull GpgConfig.GpgFormat format2) {
        return VERIFIERS.computeIfAbsent(format2, f2 -> {
            SignatureVerifierFactory factory2 = FACTORIES.get(format2);
            if (factory2 == null) {
                return null;
            }
            return factory2.create();
        });
    }

    public static void set(@NonNull GpgConfig.GpgFormat format2, SignatureVerifier verifier) {
        SignatureVerifier previous = verifier == null ? VERIFIERS.remove(format2) : VERIFIERS.put(format2, verifier);
        if (previous != null) {
            previous.clear();
        }
    }

    @Nullable
    public static SignatureVerifier.SignatureVerification verify(@NonNull Repository repository, @NonNull GpgConfig config2, @NonNull RevObject object) throws IOException {
        if (object instanceof RevCommit) {
            RevCommit commit = (RevCommit)object;
            byte[] signatureData = commit.getRawGpgSignature();
            if (signatureData == null) {
                return null;
            }
            byte[] raw = commit.getRawBuffer();
            byte[] header = new byte[]{103, 112, 103, 115, 105, 103};
            int start2 = RawParseUtils.headerStart(header, raw, 0);
            if (start2 < 0) {
                return null;
            }
            int end2 = RawParseUtils.nextLfSkippingSplitLines(raw, start2);
            start2 -= header.length + 1;
            if (end2 < raw.length) {
                ++end2;
            }
            byte[] data2 = new byte[raw.length - (end2 - start2)];
            System.arraycopy(raw, 0, data2, 0, start2);
            System.arraycopy(raw, end2, data2, start2, raw.length - end2);
            return SignatureVerifiers.verify(repository, config2, data2, signatureData);
        }
        if (object instanceof RevTag) {
            RevTag tag = (RevTag)object;
            byte[] signatureData = tag.getRawGpgSignature();
            if (signatureData == null) {
                return null;
            }
            byte[] raw = tag.getRawBuffer();
            byte[] data3 = Arrays.copyOfRange(raw, 0, raw.length - signatureData.length);
            return SignatureVerifiers.verify(repository, config2, data3, signatureData);
        }
        return null;
    }

    @Nullable
    public static SignatureVerifier.SignatureVerification verify(@NonNull Repository repository, @NonNull GpgConfig config2, byte[] data2, byte[] signature) throws IOException {
        GpgConfig.GpgFormat format2 = SignatureVerifiers.getFormat(signature);
        if (format2 == null) {
            return null;
        }
        SignatureVerifier verifier = SignatureVerifiers.get(format2);
        if (verifier == null) {
            return null;
        }
        return verifier.verify(repository, config2, data2, signature);
    }

    @Nullable
    public static GpgConfig.GpgFormat getFormat(byte[] signature) {
        if (RawParseUtils.match(signature, 0, PGP_PREFIX) > 0) {
            return GpgConfig.GpgFormat.OPENPGP;
        }
        if (RawParseUtils.match(signature, 0, X509_PREFIX) > 0) {
            return GpgConfig.GpgFormat.X509;
        }
        if (RawParseUtils.match(signature, 0, SSH_PREFIX) > 0) {
            return GpgConfig.GpgFormat.SSH;
        }
        return null;
    }
}

