/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.UnsupportedSigningFormatException;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgSignature;
import org.eclipse.jgit.lib.ObjectBuilder;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;

public interface Signer {
    default public void signObject(@NonNull Repository repository, @NonNull GpgConfig config2, @NonNull ObjectBuilder object, @NonNull PersonIdent committer, String signingKey, CredentialsProvider credentialsProvider) throws CanceledException, IOException, UnsupportedSigningFormatException {
        try {
            object.setGpgSignature(this.sign(repository, config2, object.build(), committer, signingKey, credentialsProvider));
        }
        catch (UnsupportedEncodingException e2) {
            throw new JGitInternalException(e2.getMessage(), e2);
        }
    }

    public GpgSignature sign(@NonNull Repository var1, @NonNull GpgConfig var2, byte[] var3, @NonNull PersonIdent var4, String var5, CredentialsProvider var6) throws CanceledException, IOException, UnsupportedSigningFormatException;

    public boolean canLocateSigningKey(@NonNull Repository var1, @NonNull GpgConfig var2, @NonNull PersonIdent var3, String var4, CredentialsProvider var5) throws CanceledException;
}

